/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.cfa;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.objectmodel.BlankEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.fshell.cfa.TranslationUnit;

public class Wrapper {
    private LogManager mLogManager;
    private CFAFunctionDefinitionNode mEntry;
    private CFAEdge mAlphaEdge;
    private CFAEdge mOmegaEdge;
    private TranslationUnit mTranslationUnit;

    public Wrapper(FunctionDefinitionNode pMainFunction, Map<String, CFAFunctionDefinitionNode> pCFAs, LogManager pLogManager) {
        this(pMainFunction, pCFAs, pLogManager, Wrapper.getWrapperCFunction(pMainFunction));
    }

    public Wrapper(FunctionDefinitionNode pMainFunction, Map<String, CFAFunctionDefinitionNode> pCFAs, LogManager pLogManager, String pWrapperSource) {
        this(pMainFunction, pCFAs, pLogManager, pWrapperSource, "__FLLESH__main");
    }

    public Wrapper(FunctionDefinitionNode pMainFunction, Map<String, CFAFunctionDefinitionNode> pCFAs, LogManager pLogManager, String pWrapperSource, String pEntryFunction) {
        this.mLogManager = pLogManager;
        TranslationUnit lWrapper = this.getWrapper(pWrapperSource);
        this.mTranslationUnit = new TranslationUnit();
        this.mTranslationUnit.add(lWrapper);
        this.mTranslationUnit.add(pCFAs);
        for (String lFunctionName : this.mTranslationUnit.functionNames()) {
            this.mTranslationUnit.insertCallEdgesRecursively(lFunctionName);
        }
        this.mEntry = this.mTranslationUnit.getFunction(pEntryFunction);
        this.insertGlobalDeclarations(this.mEntry, lWrapper.getGlobalDeclarations());
        this.determineAlphaAndOmegaEdges(this.mEntry, pMainFunction);
    }

    private void determineAlphaAndOmegaEdges(CFANode pInitialNode, CFANode pOriginalInitialNode) {
        assert (pInitialNode != null);
        LinkedHashSet<CFANode> lWorklist = new LinkedHashSet<CFANode>();
        HashSet<CFANode> lVisitedNodes = new HashSet<CFANode>();
        lWorklist.add(pInitialNode);
        while (!lWorklist.isEmpty()) {
            CFANode lCFANode = (CFANode)lWorklist.iterator().next();
            lWorklist.remove(lCFANode);
            if (lVisitedNodes.contains(lCFANode)) continue;
            lVisitedNodes.add(lCFANode);
            CallToReturnEdge lCallToReturnEdge = lCFANode.getLeavingSummaryEdge();
            if (lCallToReturnEdge != null) {
                if (lCFANode.getNumLeavingEdges() != 1) {
                    throw new IllegalArgumentException();
                }
                CFAEdge lEdge = lCFANode.getLeavingEdge(0);
                CFANode lPredecessor = lEdge.getPredecessor();
                CFANode lSuccessor = lEdge.getSuccessor();
                if (lSuccessor.equals(pOriginalInitialNode)) {
                    if (!lEdge.getEdgeType().equals((Object)CFAEdgeType.FunctionCallEdge)) {
                        throw new RuntimeException();
                    }
                    this.mAlphaEdge = lEdge;
                    CallToReturnEdge lSummaryEdge = lPredecessor.getLeavingSummaryEdge();
                    if (lSummaryEdge == null) {
                        throw new RuntimeException();
                    }
                    CFANode lSummarySuccessor = lSummaryEdge.getSuccessor();
                    if (lSummarySuccessor.getNumEnteringEdges() != 1) {
                        throw new RuntimeException("Summary successor has " + lSummarySuccessor.getNumEnteringEdges() + " entering CFA edges!");
                    }
                    this.mOmegaEdge = lSummarySuccessor.getEnteringEdge(0);
                }
                lWorklist.add(lCallToReturnEdge.getSuccessor());
                continue;
            }
            int lNumberOfLeavingEdges = lCFANode.getNumLeavingEdges();
            for (int lEdgeIndex = 0; lEdgeIndex < lNumberOfLeavingEdges; ++lEdgeIndex) {
                CFAEdge lEdge = lCFANode.getLeavingEdge(lEdgeIndex);
                CFANode lSuccessor = lEdge.getSuccessor();
                lWorklist.add(lSuccessor);
            }
        }
    }

    public CFAEdge getAlphaEdge() {
        return this.mAlphaEdge;
    }

    public CFAEdge getOmegaEdge() {
        return this.mOmegaEdge;
    }

    public CFAFunctionDefinitionNode getCFA(String pFunctionName) {
        return this.mTranslationUnit.getFunction(pFunctionName);
    }

    public void toDot(String pFileName) throws IOException {
        this.toDot(new File(pFileName));
    }

    public void toDot(File pFile) throws IOException {
        this.mTranslationUnit.toDot(this.mEntry.getFunctionName(), pFile);
    }

    public CFAFunctionDefinitionNode getEntry() {
        return this.mEntry;
    }

    private static String getWrapperCFunction(FunctionDefinitionNode pMainFunction) {
        StringWriter lWrapperFunction = new StringWriter();
        PrintWriter lWriter = new PrintWriter(lWrapperFunction);
        lWriter.println("void __FLLESH__main()");
        lWriter.println("{");
        lWriter.println("  int __BLAST_NONDET;");
        for (IASTParameterDeclaration lDeclaration : pMainFunction.getFunctionParameters()) {
            lWriter.println("  " + ((IASTSimpleDeclaration)lDeclaration).toASTString() + ";");
        }
        for (IASTParameterDeclaration lDeclaration : pMainFunction.getFunctionParameters()) {
            lWriter.println("  " + lDeclaration.getName() + " = __BLAST_NONDET;");
        }
        lWriter.println();
        lWriter.print("  " + pMainFunction.getFunctionName() + "(");
        boolean isFirst = true;
        for (IASTParameterDeclaration lDeclaration : pMainFunction.getFunctionParameters()) {
            if (isFirst) {
                isFirst = false;
            } else {
                lWriter.print(", ");
            }
            lWriter.print(lDeclaration.getName());
        }
        lWriter.println(");");
        lWriter.println("  return;");
        lWriter.println("}");
        return lWrapperFunction.toString();
    }

    private TranslationUnit getWrapper(String pWrapperFunction) {
        return TranslationUnit.parseString(pWrapperFunction, this.mLogManager);
    }

    private void insertGlobalDeclarations(CFAFunctionDefinitionNode firstNode, List<Pair<IASTDeclaration, String>> globalVars) {
        if (globalVars.isEmpty()) {
            return;
        }
        assert (firstNode.getNumLeavingEdges() == 1);
        CFAEdge firstEdge = firstNode.getLeavingEdge(0);
        assert (firstEdge instanceof BlankEdge);
        CFANode secondNode = firstEdge.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(firstEdge);
        CFANode cur = new CFANode(0, firstNode.getFunctionName());
        BlankEdge be = new BlankEdge("", 0, firstNode, cur, "INIT GLOBAL VARS");
        this.addToCFA(be);
        for (Pair<IASTDeclaration, String> p : globalVars) {
            IASTDeclaration d = (IASTDeclaration)p.getFirst();
            String rawSignature = (String)p.getSecond();
            assert (d.isGlobal());
            CFANode n = new CFANode(d.getFileLocation().getStartingLineNumber(), cur.getFunctionName());
            DeclarationEdge e = new DeclarationEdge(rawSignature, d.getFileLocation().getStartingLineNumber(), cur, n, d);
            this.addToCFA(e);
            cur = n;
        }
        be = new BlankEdge(firstEdge.getRawStatement(), firstEdge.getLineNumber(), cur, secondNode, firstEdge.getDescription());
        this.addToCFA(be);
    }

    private void addToCFA(CFAEdge edge) {
        edge.getPredecessor().addLeavingEdge(edge);
        edge.getSuccessor().addEnteringEdge(edge);
    }
}

