/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.fql2.ast;

import org.sosy_lab.cpachecker.fshell.fql2.ast.Edges;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.CoverageSpecification;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Identity;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.PathPattern;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.Repetition;
import org.sosy_lab.cpachecker.fshell.fql2.parser.FQLParser;

public class FQLSpecification {
    private CoverageSpecification mCoverageSpecification;
    private PathPattern mPathPattern;
    private static PathPattern mDefaultPassingClause = new Repetition(new Edges(Identity.getInstance()));

    public static PathPattern getDefaultPassingClause() {
        return mDefaultPassingClause;
    }

    public FQLSpecification(CoverageSpecification pCoverageSpecification, PathPattern pPathPattern) {
        this.mCoverageSpecification = pCoverageSpecification;
        this.mPathPattern = pPathPattern;
    }

    public FQLSpecification(CoverageSpecification pCoverageSpecification) {
        this.mCoverageSpecification = pCoverageSpecification;
        this.mPathPattern = null;
    }

    public CoverageSpecification getCoverageSpecification() {
        return this.mCoverageSpecification;
    }

    public boolean hasPassingClause() {
        return this.mPathPattern != null;
    }

    public PathPattern getPathPattern() {
        if (!this.hasPassingClause()) {
            throw new UnsupportedOperationException();
        }
        return this.mPathPattern;
    }

    public String toString() {
        if (this.hasPassingClause()) {
            return "COVER " + this.mCoverageSpecification.toString() + " PASSING " + this.mPathPattern.toString();
        }
        return "COVER " + this.mCoverageSpecification.toString();
    }

    public static FQLSpecification parse(String pFQLSpecificationString) throws Exception {
        Object pParseResult;
        FQLParser lParser = new FQLParser(pFQLSpecificationString);
        try {
            pParseResult = lParser.parse().value;
        }
        catch (Exception e) {
            System.out.println(pFQLSpecificationString);
            throw e;
        }
        assert (pParseResult instanceof FQLSpecification);
        return (FQLSpecification)pParseResult;
    }
}

