/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern;

import org.sosy_lab.cpachecker.fshell.fql2.ast.Edges;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Nodes;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Paths;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Predicate;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Compose;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Filter;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.Concatenation;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.PathPattern;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.PathPatternVisitor;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.Repetition;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.Union;

public class ScopePropagator
implements PathPatternVisitor<PathPattern> {
    Filter mFilter;

    public ScopePropagator(Filter pFilter) {
        this.mFilter = pFilter;
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    @Override
    public Concatenation visit(Concatenation pConcatenation) {
        PathPattern lFirstSubpattern = pConcatenation.getFirstSubpattern();
        PathPattern lSecondSubpattern = pConcatenation.getSecondSubpattern();
        PathPattern lNewFirstSubpattern = lFirstSubpattern.accept(this);
        PathPattern lNewSecondSubpattern = lSecondSubpattern.accept(this);
        if (lFirstSubpattern.equals(lNewFirstSubpattern) && lSecondSubpattern.equals(lNewSecondSubpattern)) {
            return pConcatenation;
        }
        return new Concatenation(lNewFirstSubpattern, lNewSecondSubpattern);
    }

    @Override
    public Repetition visit(Repetition pRepetition) {
        PathPattern lNewSubpattern;
        PathPattern lSubpattern = pRepetition.getSubpattern();
        if (lSubpattern.equals(lNewSubpattern = lSubpattern.accept(this))) {
            return pRepetition;
        }
        return new Repetition(lNewSubpattern);
    }

    @Override
    public Union visit(Union pUnion) {
        PathPattern lFirstSubpattern = pUnion.getFirstSubpattern();
        PathPattern lSecondSubpattern = pUnion.getSecondSubpattern();
        PathPattern lNewFirstSubpattern = lFirstSubpattern.accept(this);
        PathPattern lNewSecondSubpattern = lSecondSubpattern.accept(this);
        if (lFirstSubpattern.equals(lNewFirstSubpattern) && lSecondSubpattern.equals(lNewSecondSubpattern)) {
            return pUnion;
        }
        return new Union(lNewFirstSubpattern, lNewSecondSubpattern);
    }

    @Override
    public Edges visit(Edges pEdges) {
        Filter lFilter = pEdges.getFilter();
        return new Edges(new Compose(lFilter, this.getFilter()));
    }

    @Override
    public Nodes visit(Nodes pNodes) {
        Filter lFilter = pNodes.getFilter();
        return new Nodes(new Compose(lFilter, this.getFilter()));
    }

    @Override
    public Paths visit(Paths pPaths) {
        Filter lFilter = pPaths.getFilter();
        int lBound = pPaths.getBound();
        return new Paths(new Compose(lFilter, this.getFilter()), lBound);
    }

    @Override
    public Predicate visit(Predicate pPredicate) {
        return pPredicate;
    }
}

