/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.fql2.parser;

import java.io.StringReader;
import junit.framework.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.fshell.fql2.parser.FQLParser;

public class FQLParserTest {
    @Test
    public void testFQLParserScanner001() throws Exception {
        String lInput = "COVER EDGES(@BASICBLOCKENTRY)";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER EDGES(@BASICBLOCKENTRY)");
    }

    @Test
    public void testFQLParserScanner002() throws Exception {
        String lInput = "COVER EDGES(@CONDITIONEDGE)";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER EDGES(@CONDITIONEDGE)");
    }

    @Test
    public void testFQLParserScanner003() throws Exception {
        String lInput = "COVER EDGES(@DECISIONEDGE)";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER EDGES(@DECISIONEDGE)");
    }

    @Test
    public void testFQLParserScanner004() throws Exception {
        String lInput = "COVER EDGES(@CONDITIONGRAPH)";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER EDGES(@CONDITIONGRAPH)");
    }

    @Test
    public void testFQLParserScanner005() throws Exception {
        String lInput = "COVER EDGES(ID)";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER EDGES(ID)");
    }

    @Test
    public void testFQLParserScanner006() throws Exception {
        String lInput = "COVER EDGES(COMPLEMENT(@BASICBLOCKENTRY))";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER EDGES(COMPLEMENT(@BASICBLOCKENTRY))");
    }

    @Test
    public void testFQLParserScanner007() throws Exception {
        String lInput = "COVER EDGES(INTERSECT(@BASICBLOCKENTRY, @CONDITIONEDGE))";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER EDGES(INTERSECT(@BASICBLOCKENTRY, @CONDITIONEDGE))");
    }

    @Test
    public void testFQLParserScanner008() throws Exception {
        String lInput = "COVER EDGES(UNION(@BASICBLOCKENTRY, @CONDITIONEDGE))";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER EDGES(UNION(@BASICBLOCKENTRY, @CONDITIONEDGE))");
    }

    @Test
    public void testFQLParserScanner009() throws Exception {
        String lInput = "COVER \"EDGES(ID)*\"";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER \"EDGES(ID)*\"");
    }

    @Test
    public void testFQLParserScanner010() throws Exception {
        String lInput = "COVER \"EDGES(ID)*\".EDGES(@CALL(f)).\"EDGES(ID)*\"";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER (\"EDGES(ID)*\".EDGES(@CALL(f))).\"EDGES(ID)*\"");
    }

    @Test
    public void testFQLParserScanner011() throws Exception {
        String lInput = "COVER \"EDGES(ID)*\".NODES(@CALL(f)).\"EDGES(ID)*\"";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER (\"EDGES(ID)*\".NODES(@CALL(f))).\"EDGES(ID)*\"");
    }

    @Test
    public void testFQLParserScanner012() throws Exception {
        String lInput = "COVER \"EDGES(ID)*\".PATHS(@CALL(f), 2).\"EDGES(ID)*\"";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER (\"EDGES(ID)*\".PATHS(@CALL(f), 2)).\"EDGES(ID)*\"");
    }

    @Test
    public void testFQLParserScanner013() throws Exception {
        String lInput = "COVER \"NODES(ID)*\".{ x > 10 }.EDGES(@CALL(f)).\"PATHS(ID, 5)*\"";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER ((\"NODES(ID)*\".{ x > 10 }).EDGES(@CALL(f))).\"PATHS(ID, 5)*\"");
    }

    @Test
    public void testFQLParserScanner014() throws Exception {
        String lInput = "IN @FILE('source.c') COVER \"NODES(ID)*\".{ x > 10 }.EDGES(@CALL(f)).\"PATHS(ID, 5)*\"";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER ((\"NODES(COMPOSE(ID, @FILE('source.c')))*\".{ x > 10 }).EDGES(COMPOSE(@CALL(f), @FILE('source.c')))).\"PATHS(COMPOSE(ID, @FILE('source.c')), 5)*\"");
    }

    @Test
    public void testFQLParserScanner015() throws Exception {
        String lInput = "IN PRED(@FILE('source.c'), {y > 100}) COVER \"NODES(ID)*\".{ x > 10 }.EDGES(@CALL(f)).\"PATHS(ID, 5)*\"";
        System.out.println(lInput);
        FQLParser lParser = new FQLParser(new StringReader(lInput));
        Object lResult = lParser.parse().value;
        System.out.println("RESULT: " + lResult.toString());
        Assert.assertEquals((String)lResult.toString(), (String)"COVER ((\"NODES(COMPOSE(ID, PRED(@FILE('source.c'), { y > 100 })))*\".{ x > 10 }).EDGES(COMPOSE(@CALL(f), PRED(@FILE('source.c'), { y > 100 })))).\"PATHS(COMPOSE(ID, PRED(@FILE('source.c'), { y > 100 })), 5)*\"");
    }
}

