/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.fql2.translators.cfa;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.ecp.ECPPredicate;
import org.sosy_lab.cpachecker.util.predicates.simpleformulas.translators.c.PredicateTranslator;

public class ToFlleShAssumeEdgeTranslator {
    private static Map<String, IASTExpression> mExpressionCache = new HashMap<String, IASTExpression>();

    public static AssumeEdge translate(CFANode pNode, ECPPredicate pPredicate) {
        IASTExpression lPredicateExpression;
        String lPredicateFunction = PredicateTranslator.translate(pPredicate.getPredicate());
        if (mExpressionCache.containsKey(lPredicateFunction)) {
            lPredicateExpression = mExpressionCache.get(lPredicateFunction);
        } else {
            IASTNode statement;
            try {
                CParser parser = CParser.Factory.getParser(null, CParser.Factory.getDefaultOptions());
                statement = parser.parseSingleStatement(lPredicateFunction);
            }
            catch (ParserException e) {
                throw new RuntimeException("Error during parsing C code \"" + lPredicateFunction + "\": " + e.getMessage());
            }
            if (!(statement instanceof IASTExpressionStatement)) {
                throw new RuntimeException("Error: AST does not match the expectations");
            }
            lPredicateExpression = ((IASTExpressionStatement)statement).getExpression();
            mExpressionCache.put(lPredicateFunction, lPredicateExpression);
        }
        return new AssumeEdge(lPredicateExpression.toASTString(), pNode.getLineNumber(), pNode, pNode, lPredicateExpression, true);
    }
}

