/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.fql2.translators.ecp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Edges;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Nodes;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Paths;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Predicate;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.Concatenation;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.CoverageSpecification;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.CoverageSpecificationVisitor;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.Quotation;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.Union;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.PathPattern;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.PathPatternTranslator;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;
import org.sosy_lab.cpachecker.fshell.targetgraph.Path;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraph;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraphUtil;
import org.sosy_lab.cpachecker.util.ecp.ECPConcatenation;
import org.sosy_lab.cpachecker.util.ecp.ECPPredicate;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;

public class CoverageSpecificationTranslator {
    private final Visitor mVisitor = new Visitor();
    public final PathPatternTranslator mPathPatternTranslator;
    private final HashMap<CoverageSpecification, Collection<ElementaryCoveragePattern>> mResultCache;

    public CoverageSpecificationTranslator(CFANode pInitialNode) {
        this(TargetGraphUtil.cfa(pInitialNode), TargetGraphUtil.getBasicBlockEntries(pInitialNode));
    }

    public CoverageSpecificationTranslator(TargetGraph pTargetGraph, Set<CFAEdge> pBasicBlockEntries) {
        this(new PathPatternTranslator(pTargetGraph, pBasicBlockEntries));
    }

    public CoverageSpecificationTranslator(PathPatternTranslator pPatternTranslator) {
        this.mPathPatternTranslator = pPatternTranslator;
        this.mResultCache = new HashMap();
    }

    public int getOverallCacheHits() {
        return this.mVisitor.mCacheHits + this.mPathPatternTranslator.getCacheHits();
    }

    public int getOverallCacheMisses() {
        return this.mVisitor.mCacheMisses + this.mPathPatternTranslator.getCacheMisses();
    }

    public Collection<ElementaryCoveragePattern> translate(CoverageSpecification pCoverageSpecification) {
        return pCoverageSpecification.accept(this.mVisitor);
    }

    public ElementaryCoveragePattern translate(PathPattern pPathPattern) {
        return this.mPathPatternTranslator.translate(pPathPattern);
    }

    private class Visitor
    implements CoverageSpecificationVisitor<Collection<ElementaryCoveragePattern>> {
        public int mCacheHits = 0;
        public int mCacheMisses = 0;

        private Visitor() {
        }

        @Override
        public Collection<ElementaryCoveragePattern> visit(Concatenation pConcatenation) {
            ArrayList<ECPConcatenation> lResultSet = (ArrayList<ECPConcatenation>)CoverageSpecificationTranslator.this.mResultCache.get(pConcatenation);
            if (lResultSet == null) {
                Collection<ElementaryCoveragePattern> lPrefixSet = pConcatenation.getFirstSubspecification().accept(this);
                Collection<ElementaryCoveragePattern> lSuffixSet = pConcatenation.getSecondSubspecification().accept(this);
                lResultSet = new ArrayList<ECPConcatenation>(lPrefixSet.size() * lSuffixSet.size());
                for (ElementaryCoveragePattern lPrefix : lPrefixSet) {
                    for (ElementaryCoveragePattern lSuffix : lSuffixSet) {
                        lResultSet.add(new ECPConcatenation(lPrefix, lSuffix));
                    }
                }
                CoverageSpecificationTranslator.this.mResultCache.put(pConcatenation, lResultSet);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lResultSet;
        }

        @Override
        public Collection<ElementaryCoveragePattern> visit(Quotation pQuotation) {
            Set<ElementaryCoveragePattern> lResultSet = (Set<ElementaryCoveragePattern>)CoverageSpecificationTranslator.this.mResultCache.get(pQuotation);
            if (lResultSet == null) {
                ElementaryCoveragePattern lPattern = CoverageSpecificationTranslator.this.mPathPatternTranslator.translate(pQuotation.getPathPattern());
                lResultSet = Collections.singleton(lPattern);
                CoverageSpecificationTranslator.this.mResultCache.put(pQuotation, lResultSet);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lResultSet;
        }

        @Override
        public Collection<ElementaryCoveragePattern> visit(Union pUnion) {
            ArrayList<ElementaryCoveragePattern> lResultSet = (ArrayList<ElementaryCoveragePattern>)CoverageSpecificationTranslator.this.mResultCache.get(pUnion);
            if (lResultSet == null) {
                Collection<ElementaryCoveragePattern> lPatterns1 = pUnion.getFirstSubspecification().accept(this);
                Collection<ElementaryCoveragePattern> lPatterns2 = pUnion.getSecondSubspecification().accept(this);
                lResultSet = new ArrayList<ElementaryCoveragePattern>(lPatterns1.size() + lPatterns2.size());
                lResultSet.addAll(lPatterns1);
                lResultSet.addAll(lPatterns2);
                CoverageSpecificationTranslator.this.mResultCache.put(pUnion, lResultSet);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lResultSet;
        }

        @Override
        public Collection<ElementaryCoveragePattern> visit(Edges pEdges) {
            TargetGraph lFilteredTargetGraph = CoverageSpecificationTranslator.this.mPathPatternTranslator.getFilterEvaluator().evaluate(pEdges.getFilter());
            ArrayList<ElementaryCoveragePattern> lResultSet = (ArrayList<ElementaryCoveragePattern>)CoverageSpecificationTranslator.this.mResultCache.get(pEdges);
            if (lResultSet == null) {
                lResultSet = new ArrayList<ElementaryCoveragePattern>(lFilteredTargetGraph.getEdges().size());
                for (Edge lEdge : lFilteredTargetGraph.getEdges()) {
                    ElementaryCoveragePattern lPattern = CoverageSpecificationTranslator.this.mPathPatternTranslator.translate(lEdge);
                    lResultSet.add(lPattern);
                }
                CoverageSpecificationTranslator.this.mResultCache.put(pEdges, lResultSet);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lResultSet;
        }

        @Override
        public Collection<ElementaryCoveragePattern> visit(Nodes pNodes) {
            TargetGraph lFilteredTargetGraph = CoverageSpecificationTranslator.this.mPathPatternTranslator.getFilterEvaluator().evaluate(pNodes.getFilter());
            ArrayList<ElementaryCoveragePattern> lResultSet = (ArrayList<ElementaryCoveragePattern>)CoverageSpecificationTranslator.this.mResultCache.get(pNodes);
            if (lResultSet == null) {
                lResultSet = new ArrayList<ElementaryCoveragePattern>(lFilteredTargetGraph.getNodes().size());
                for (Node lNode : lFilteredTargetGraph.getNodes()) {
                    lResultSet.add(CoverageSpecificationTranslator.this.mPathPatternTranslator.translate(lNode));
                }
                CoverageSpecificationTranslator.this.mResultCache.put(pNodes, lResultSet);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lResultSet;
        }

        @Override
        public Collection<ElementaryCoveragePattern> visit(Paths pPaths) {
            TargetGraph lFilteredTargetGraph = CoverageSpecificationTranslator.this.mPathPatternTranslator.getFilterEvaluator().evaluate(pPaths.getFilter());
            ArrayList<ElementaryCoveragePattern> lResultSet = (ArrayList<ElementaryCoveragePattern>)CoverageSpecificationTranslator.this.mResultCache.get(pPaths);
            if (lResultSet == null) {
                Set<Path> lPaths = lFilteredTargetGraph.getBoundedPaths(pPaths.getBound());
                lResultSet = new ArrayList<ElementaryCoveragePattern>(lPaths.size());
                for (Path lPath : lPaths) {
                    lResultSet.add(CoverageSpecificationTranslator.this.mPathPatternTranslator.translate(lPath));
                }
                CoverageSpecificationTranslator.this.mResultCache.put(pPaths, lResultSet);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lResultSet;
        }

        @Override
        public Collection<ElementaryCoveragePattern> visit(Predicate pPredicate) {
            Set<ECPPredicate> lResultSet = (Set<ECPPredicate>)CoverageSpecificationTranslator.this.mResultCache.get(pPredicate);
            if (lResultSet == null) {
                ECPPredicate lPattern = new ECPPredicate(pPredicate.getPredicate());
                lResultSet = Collections.singleton(lPattern);
                CoverageSpecificationTranslator.this.mResultCache.put(pPredicate, lResultSet);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lResultSet;
        }
    }
}

