/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.fql2.translators.ecp;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Atom;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Paths;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.Concatenation;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.CoverageSpecification;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.Quotation;
import org.sosy_lab.cpachecker.fshell.fql2.ast.coveragespecification.Union;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.CoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.PathPatternTranslator;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;
import org.sosy_lab.cpachecker.fshell.targetgraph.Occurrences;
import org.sosy_lab.cpachecker.fshell.targetgraph.Path;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraph;
import org.sosy_lab.cpachecker.util.ecp.ECPConcatenation;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;

public class IncrementalCoverageSpecificationTranslator {
    private final PathPatternTranslator mPathPatternTranslator;
    private final CoverageSpecificationTranslator mCoverageSpecificationTranslator;

    public IncrementalCoverageSpecificationTranslator(PathPatternTranslator pPathPatternTranslator) {
        this.mPathPatternTranslator = pPathPatternTranslator;
        this.mCoverageSpecificationTranslator = new CoverageSpecificationTranslator(this.mPathPatternTranslator);
    }

    public int getNumberOfTestGoals(CoverageSpecification pSpecification) {
        if (pSpecification instanceof Atom || pSpecification instanceof Quotation) {
            return this.mCoverageSpecificationTranslator.translate(pSpecification).size();
        }
        if (pSpecification instanceof Union) {
            Union lUnion = (Union)pSpecification;
            return this.getNumberOfTestGoals(lUnion.getFirstSubspecification()) + this.getNumberOfTestGoals(lUnion.getSecondSubspecification());
        }
        if (pSpecification instanceof Concatenation) {
            Concatenation lConcatenation = (Concatenation)pSpecification;
            return this.getNumberOfTestGoals(lConcatenation.getFirstSubspecification()) * this.getNumberOfTestGoals(lConcatenation.getSecondSubspecification());
        }
        throw new RuntimeException();
    }

    public Iterator<ElementaryCoveragePattern> translate(CoverageSpecification pSpecification) {
        if (pSpecification instanceof Paths) {
            Paths lPaths = (Paths)pSpecification;
            TargetGraph lTargetGraph = this.mPathPatternTranslator.getFilterEvaluator().evaluate(lPaths.getFilter());
            return new PathIterator(lTargetGraph, lPaths.getBound());
        }
        if (pSpecification instanceof Atom || pSpecification instanceof Quotation) {
            return this.mCoverageSpecificationTranslator.translate(pSpecification).iterator();
        }
        if (pSpecification instanceof Union) {
            Union lUnion = (Union)pSpecification;
            return new UnionIterator(lUnion.getFirstSubspecification(), lUnion.getSecondSubspecification());
        }
        if (pSpecification instanceof Concatenation) {
            Concatenation lConcatenation = (Concatenation)pSpecification;
            return new ConcatenationIterator(lConcatenation.getFirstSubspecification(), lConcatenation.getSecondSubspecification());
        }
        throw new RuntimeException();
    }

    private class ConcatenationIterator
    implements Iterator<ElementaryCoveragePattern> {
        private final Iterator<ElementaryCoveragePattern> mIterator1;
        private final CoverageSpecification mSpecification2;
        private Iterator<ElementaryCoveragePattern> mIterator2;
        private ElementaryCoveragePattern mPrefix;

        private ConcatenationIterator(CoverageSpecification pSpecification1, CoverageSpecification pSpecification2) {
            this.mIterator1 = IncrementalCoverageSpecificationTranslator.this.translate(pSpecification1);
            this.mIterator2 = IncrementalCoverageSpecificationTranslator.this.translate(pSpecification2);
            this.mSpecification2 = pSpecification2;
            this.mPrefix = null;
            if (this.mIterator1.hasNext() && this.mIterator2.hasNext()) {
                this.mPrefix = this.mIterator1.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.mPrefix != null;
        }

        @Override
        public ElementaryCoveragePattern next() {
            ECPConcatenation lResult = new ECPConcatenation(this.mPrefix, this.mIterator2.next());
            if (!this.mIterator2.hasNext()) {
                if (this.mIterator1.hasNext()) {
                    this.mPrefix = this.mIterator1.next();
                    this.mIterator2 = IncrementalCoverageSpecificationTranslator.this.translate(this.mSpecification2);
                } else {
                    this.mPrefix = null;
                }
            }
            return lResult;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class UnionIterator
    implements Iterator<ElementaryCoveragePattern> {
        private final Iterator<ElementaryCoveragePattern> mIterator1;
        private final Iterator<ElementaryCoveragePattern> mIterator2;

        private UnionIterator(CoverageSpecification pSpecification1, CoverageSpecification pSpecification2) {
            this.mIterator1 = IncrementalCoverageSpecificationTranslator.this.translate(pSpecification1);
            this.mIterator2 = IncrementalCoverageSpecificationTranslator.this.translate(pSpecification2);
        }

        @Override
        public boolean hasNext() {
            return this.mIterator1.hasNext() || this.mIterator2.hasNext();
        }

        @Override
        public ElementaryCoveragePattern next() {
            if (this.mIterator1.hasNext()) {
                return this.mIterator1.next();
            }
            return this.mIterator2.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PathIterator
    implements Iterator<ElementaryCoveragePattern> {
        private TargetGraph mTargetGraph;
        private int mBound;
        private Iterator<Node> mInitialNodes;
        private SinglePathIterator mCurrentSinglePathIterator;

        public PathIterator(TargetGraph pTargetGraph, int pBound) {
            this.mTargetGraph = pTargetGraph;
            this.mBound = pBound;
            this.mInitialNodes = this.mTargetGraph.initialNodes().iterator();
            if (this.mInitialNodes.hasNext()) {
                Node lCurrentInitialNode = this.mInitialNodes.next();
                this.mCurrentSinglePathIterator = new SinglePathIterator(lCurrentInitialNode);
            } else {
                this.mCurrentSinglePathIterator = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.mCurrentSinglePathIterator == null) {
                return false;
            }
            if (this.mCurrentSinglePathIterator.hasNext()) {
                return true;
            }
            if (this.mInitialNodes.hasNext()) {
                Node lCurrentInitialNode = this.mInitialNodes.next();
                this.mCurrentSinglePathIterator = new SinglePathIterator(lCurrentInitialNode);
            } else {
                this.mCurrentSinglePathIterator = null;
            }
            return this.hasNext();
        }

        @Override
        public ElementaryCoveragePattern next() {
            if (this.hasNext()) {
                return this.mCurrentSinglePathIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new RuntimeException();
        }

        private class SinglePathIterator
        implements Iterator<ElementaryCoveragePattern> {
            private LinkedList<Edge> mEdgeSequence;
            private LinkedList<Iterator<Edge>> mIteratorSequence;
            private LinkedList<ElementaryCoveragePattern> mPatternSequence;
            private ElementaryCoveragePattern mCurrentPattern;
            private final Node mInitialNode;
            private final Occurrences mOccurrences;

            public SinglePathIterator(Node pInitialNode) {
                this.mInitialNode = pInitialNode;
                this.mCurrentPattern = null;
                this.mEdgeSequence = new LinkedList();
                this.mIteratorSequence = new LinkedList();
                this.mPatternSequence = new LinkedList();
                if (PathIterator.this.mTargetGraph.isFinalNode(pInitialNode)) {
                    this.mCurrentPattern = IncrementalCoverageSpecificationTranslator.this.mPathPatternTranslator.translate(new Path(pInitialNode, this.mEdgeSequence));
                }
                this.mIteratorSequence.add(PathIterator.this.mTargetGraph.getOutgoingEdges(this.mInitialNode).iterator());
                this.mOccurrences = new Occurrences();
            }

            @Override
            public boolean hasNext() {
                if (this.mCurrentPattern == null) {
                    Iterator<Edge> lFrontierIterator = this.mIteratorSequence.getLast();
                    if (lFrontierIterator.hasNext()) {
                        Edge lNextEdge = lFrontierIterator.next();
                        int lOccurrences = this.mOccurrences.increment(lNextEdge);
                        if (lOccurrences > PathIterator.this.mBound) {
                            this.mOccurrences.decrement(lNextEdge);
                            Edge lLastEdge = this.mEdgeSequence.getLast();
                            if (lLastEdge == null) {
                                if (PathIterator.this.mTargetGraph.isFinalNode(this.mInitialNode)) {
                                    return false;
                                }
                            } else if (PathIterator.this.mTargetGraph.isFinalNode(lLastEdge.getTarget())) {
                                return this.hasNext();
                            }
                            this.mCurrentPattern = new ECPConcatenation(this.mPatternSequence);
                            return true;
                        }
                        Node lTarget = lNextEdge.getTarget();
                        this.mEdgeSequence.add(lNextEdge);
                        this.mPatternSequence.add(IncrementalCoverageSpecificationTranslator.this.mPathPatternTranslator.translate(lNextEdge));
                        this.mIteratorSequence.add(PathIterator.this.mTargetGraph.getOutgoingEdges(lTarget).iterator());
                        if (PathIterator.this.mTargetGraph.isFinalNode(lTarget)) {
                            this.mCurrentPattern = new ECPConcatenation(this.mPatternSequence);
                            return true;
                        }
                        return this.hasNext();
                    }
                    this.mIteratorSequence.removeLast();
                    if (this.mIteratorSequence.isEmpty()) {
                        if (!this.mEdgeSequence.isEmpty()) {
                            throw new RuntimeException();
                        }
                        return false;
                    }
                    Edge lEdge = this.mEdgeSequence.removeLast();
                    this.mPatternSequence.removeLast();
                    this.mOccurrences.decrement(lEdge);
                    return this.hasNext();
                }
                return true;
            }

            @Override
            public ElementaryCoveragePattern next() {
                if (this.hasNext()) {
                    ElementaryCoveragePattern lPattern = this.mCurrentPattern;
                    this.mCurrentPattern = null;
                    return lPattern;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

