/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.fql2.translators.ecp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Edges;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Nodes;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Paths;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Predicate;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.Concatenation;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.PathPattern;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.PathPatternVisitor;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.Repetition;
import org.sosy_lab.cpachecker.fshell.fql2.ast.pathpattern.Union;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.FilterEvaluator;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;
import org.sosy_lab.cpachecker.fshell.targetgraph.Path;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraph;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraphUtil;
import org.sosy_lab.cpachecker.util.ecp.ECPConcatenation;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPNodeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPPredicate;
import org.sosy_lab.cpachecker.util.ecp.ECPRepetition;
import org.sosy_lab.cpachecker.util.ecp.ECPUnion;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;

public class PathPatternTranslator {
    private final TargetGraph mTargetGraph;
    private final Visitor mVisitor;
    private final FilterEvaluator mFilterEvaluator;

    public PathPatternTranslator(CFANode pInitialNode) {
        this(TargetGraphUtil.cfa(pInitialNode), TargetGraphUtil.getBasicBlockEntries(pInitialNode));
    }

    public PathPatternTranslator(TargetGraph pTargetGraph, Set<CFAEdge> pBasicBlockEntries) {
        this.mTargetGraph = pTargetGraph;
        this.mVisitor = new Visitor();
        this.mFilterEvaluator = new FilterEvaluator(this.mTargetGraph, pBasicBlockEntries);
    }

    public int getCacheHits() {
        return this.mVisitor.mCacheHits;
    }

    public int getCacheMisses() {
        return this.mVisitor.mCacheMisses;
    }

    public FilterEvaluator getFilterEvaluator() {
        return this.mFilterEvaluator;
    }

    public ElementaryCoveragePattern translate(PathPattern pPattern) {
        return pPattern.accept(this.mVisitor);
    }

    public ElementaryCoveragePattern translate(Node pNode) {
        if (!pNode.getPredicates().isEmpty()) {
            return new ECPConcatenation(new ECPNodeSet(pNode.getCFANode()), this.translate(pNode.getPredicates()));
        }
        return new ECPNodeSet(pNode.getCFANode());
    }

    public ElementaryCoveragePattern translate(Edge pEdge) {
        Node lSource = pEdge.getSource();
        Node lTarget = pEdge.getTarget();
        List<Predicate> lSourcePredicates = lSource.getPredicates();
        List<Predicate> lTargetPredicates = lTarget.getPredicates();
        Iterable<CFAEdge> lPattern = new ECPEdgeSet(pEdge.getCFAEdge());
        if (!lSourcePredicates.isEmpty()) {
            lPattern = new ECPConcatenation(this.translate(lSourcePredicates), (ElementaryCoveragePattern)((Object)lPattern));
        }
        if (!lTargetPredicates.isEmpty()) {
            lPattern = new ECPConcatenation((ElementaryCoveragePattern)((Object)lPattern), this.translate(lTargetPredicates));
        }
        return lPattern;
    }

    public ElementaryCoveragePattern translate(Path pPath) {
        if (pPath.length() == 0) {
            return this.translate(pPath.getStartNode());
        }
        Iterable<ElementaryCoveragePattern> lPathPattern = null;
        for (Edge lEdge : pPath) {
            Node lSource = lEdge.getSource();
            List<Predicate> lSourcePredicates = lSource.getPredicates();
            Iterable<CFAEdge> lPattern = new ECPEdgeSet(lEdge.getCFAEdge());
            if (!lSource.getPredicates().isEmpty()) {
                lPattern = new ECPConcatenation(this.translate(lSourcePredicates), (ElementaryCoveragePattern)((Object)lPattern));
            }
            if (lPathPattern == null) {
                lPathPattern = lPattern;
                continue;
            }
            lPathPattern = new ECPConcatenation((ElementaryCoveragePattern)((Object)lPathPattern), (ElementaryCoveragePattern)((Object)lPattern));
        }
        Node lEndNode = pPath.getEndNode();
        List<Predicate> lEndPredicates = lEndNode.getPredicates();
        if (!lEndPredicates.isEmpty()) {
            lPathPattern = new ECPConcatenation((ElementaryCoveragePattern)((Object)lPathPattern), this.translate(lEndPredicates));
        }
        return lPathPattern;
    }

    public ElementaryCoveragePattern translate(List<Predicate> pPredicates) {
        if (pPredicates.size() == 0) {
            throw new IllegalArgumentException();
        }
        ElementaryCoveragePattern lPredicatePattern = new ECPPredicate(pPredicates.get(0).getPredicate());
        for (int lIndex = 1; lIndex < pPredicates.size(); ++lIndex) {
            lPredicatePattern = new ECPConcatenation(new ECPPredicate(pPredicates.get(lIndex).getPredicate()), lPredicatePattern);
        }
        return lPredicatePattern;
    }

    private class Visitor
    implements PathPatternVisitor<ElementaryCoveragePattern> {
        private final HashMap<PathPattern, ElementaryCoveragePattern> mResultCache = new HashMap();
        public int mCacheHits = 0;
        public int mCacheMisses = 0;

        private Visitor() {
        }

        @Override
        public ElementaryCoveragePattern visit(Concatenation pConcatenation) {
            ElementaryCoveragePattern lPattern = this.mResultCache.get(pConcatenation);
            if (lPattern == null) {
                ElementaryCoveragePattern lFirstSubpattern = pConcatenation.getFirstSubpattern().accept(this);
                ElementaryCoveragePattern lSecondSubpattern = pConcatenation.getSecondSubpattern().accept(this);
                lPattern = new ECPConcatenation(lFirstSubpattern, lSecondSubpattern);
                this.mResultCache.put(pConcatenation, lPattern);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lPattern;
        }

        @Override
        public ElementaryCoveragePattern visit(Repetition pRepetition) {
            ElementaryCoveragePattern lPattern = this.mResultCache.get(pRepetition);
            if (lPattern == null) {
                ElementaryCoveragePattern lSubpattern = pRepetition.getSubpattern().accept(this);
                lPattern = new ECPRepetition(lSubpattern);
                this.mResultCache.put(pRepetition, lPattern);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lPattern;
        }

        @Override
        public ElementaryCoveragePattern visit(Union pUnion) {
            ElementaryCoveragePattern lPattern = this.mResultCache.get(pUnion);
            if (lPattern == null) {
                ElementaryCoveragePattern lFirstSubpattern = pUnion.getFirstSubpattern().accept(this);
                ElementaryCoveragePattern lSecondSubpattern = pUnion.getSecondSubpattern().accept(this);
                lPattern = new ECPUnion(lFirstSubpattern, lSecondSubpattern);
                this.mResultCache.put(pUnion, lPattern);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lPattern;
        }

        @Override
        public ElementaryCoveragePattern visit(Edges pEdges) {
            ElementaryCoveragePattern lPattern = this.mResultCache.get(pEdges);
            if (lPattern == null) {
                TargetGraph lFilteredTargetGraph = PathPatternTranslator.this.mFilterEvaluator.evaluate(pEdges.getFilter());
                HashSet<CFAEdge> lCFAEdges = new HashSet<CFAEdge>();
                HashSet<ElementaryCoveragePattern> lToBeUnited = new HashSet<ElementaryCoveragePattern>();
                for (Edge lEdge : lFilteredTargetGraph.getEdges()) {
                    if (!lEdge.getSource().getPredicates().isEmpty() || !lEdge.getTarget().getPredicates().isEmpty()) {
                        lToBeUnited.add(PathPatternTranslator.this.translate(lEdge));
                        continue;
                    }
                    lCFAEdges.add(lEdge.getCFAEdge());
                }
                lPattern = new ECPEdgeSet(lCFAEdges);
                for (ElementaryCoveragePattern lSubpattern : lToBeUnited) {
                    lPattern = new ECPUnion(lPattern, lSubpattern);
                }
                this.mResultCache.put(pEdges, lPattern);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lPattern;
        }

        @Override
        public ElementaryCoveragePattern visit(Nodes pNodes) {
            ElementaryCoveragePattern lPattern = this.mResultCache.get(pNodes);
            if (lPattern == null) {
                TargetGraph lFilteredTargetGraph = PathPatternTranslator.this.mFilterEvaluator.evaluate(pNodes.getFilter());
                HashSet<CFANode> lCFANodes = new HashSet<CFANode>();
                HashSet<ElementaryCoveragePattern> lToBeUnited = new HashSet<ElementaryCoveragePattern>();
                for (Node lNode : lFilteredTargetGraph.getNodes()) {
                    if (!lNode.getPredicates().isEmpty()) {
                        lToBeUnited.add(PathPatternTranslator.this.translate(lNode));
                        continue;
                    }
                    lCFANodes.add(lNode.getCFANode());
                }
                lPattern = new ECPNodeSet(lCFANodes);
                for (ElementaryCoveragePattern lSubpattern : lToBeUnited) {
                    lPattern = new ECPUnion(lPattern, lSubpattern);
                }
                this.mResultCache.put(pNodes, lPattern);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lPattern;
        }

        @Override
        public ElementaryCoveragePattern visit(Paths pPaths) {
            ElementaryCoveragePattern lPattern = this.mResultCache.get(pPaths);
            if (lPattern == null) {
                TargetGraph lFilteredTargetGraph = PathPatternTranslator.this.mFilterEvaluator.evaluate(pPaths.getFilter());
                Set<Path> lPaths = lFilteredTargetGraph.getBoundedPaths(pPaths.getBound());
                if (lPaths.size() == 0) {
                    return ECPNodeSet.EMPTY_NODE_SET;
                }
                ArrayList<ElementaryCoveragePattern> lToBeUnited = new ArrayList<ElementaryCoveragePattern>(lPaths.size());
                for (Path lPath : lFilteredTargetGraph.getBoundedPaths(pPaths.getBound())) {
                    lToBeUnited.add(PathPatternTranslator.this.translate(lPath));
                }
                lPattern = (ElementaryCoveragePattern)lToBeUnited.get(0);
                for (int lIndex = 1; lIndex < lToBeUnited.size(); ++lIndex) {
                    ElementaryCoveragePattern lSubpattern = (ElementaryCoveragePattern)lToBeUnited.get(lIndex);
                    lPattern = new ECPUnion(lPattern, lSubpattern);
                }
                this.mResultCache.put(pPaths, lPattern);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lPattern;
        }

        @Override
        public ElementaryCoveragePattern visit(Predicate pPredicate) {
            ElementaryCoveragePattern lPattern = this.mResultCache.get(pPredicate);
            if (lPattern == null) {
                lPattern = new ECPPredicate(pPredicate.getPredicate());
                this.mResultCache.put(pPredicate, lPattern);
                ++this.mCacheMisses;
            } else {
                ++this.mCacheHits;
            }
            return lPattern;
        }
    }
}

