/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.heuristics;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.fshell.Goal;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;

public class GoalReordering {
    public static Deque<Goal> reorder(Deque<Goal> pGoals) {
        Preconditions.checkNotNull(pGoals);
        HashMap<Goal, Integer> lWeights = new HashMap<Goal, Integer>();
        for (Goal lGoal : pGoals) {
            int lGoalWeight = 0;
            for (NondeterministicFiniteAutomaton.Edge lEdge : lGoal.getAutomaton().getEdges()) {
                ECPEdgeSet lEdgeSet;
                GuardedEdgeLabel lLabel = (GuardedEdgeLabel)lEdge.getLabel();
                if (!lLabel.getClass().equals(GuardedEdgeLabel.class) || (lEdgeSet = lLabel.getEdgeSet()).size() != 1) continue;
                int lTopSortId = Integer.MAX_VALUE;
                for (CFAEdge lTmpCFAEdge : lEdgeSet) {
                    lTopSortId = Math.min(lTmpCFAEdge.getPredecessor().getTopologicalSortId(), lTmpCFAEdge.getSuccessor().getTopologicalSortId());
                }
                lGoalWeight += lTopSortId;
            }
            lWeights.put(lGoal, lGoalWeight);
        }
        PriorityQueue<Goal> lQueue = new PriorityQueue<Goal>(pGoals.size(), new WeightComparator(lWeights));
        lQueue.addAll(pGoals);
        if (lQueue.size() != pGoals.size()) {
            throw new RuntimeException();
        }
        return new LinkedList<Goal>(lQueue);
    }

    private static class WeightComparator
    implements Comparator<Goal> {
        private final Map<Goal, Integer> mWeights;

        public WeightComparator(Map<Goal, Integer> pWeights) {
            this.mWeights = pWeights;
        }

        @Override
        public int compare(Goal pO1, Goal pO2) {
            int lDifference = this.mWeights.get(pO1) - this.mWeights.get(pO2);
            return lDifference;
        }
    }
}

