/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph;

import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.BasicBlockEntry;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Column;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Complement;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Compose;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.ConditionEdge;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.ConditionGraph;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.DecisionEdge;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.EnclosingScopes;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Expression;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.File;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Filter;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.FilterVisitor;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Function;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.FunctionCall;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.FunctionCalls;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.FunctionEntry;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.FunctionExit;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Identity;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Intersection;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Label;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Line;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Predication;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.RegularExpression;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.SetMinus;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Union;
import org.sosy_lab.cpachecker.fshell.targetgraph.FilterEvaluationCache;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraph;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraphUtil;
import org.sosy_lab.cpachecker.fshell.targetgraph.mask.AssumeEdgeMaskFunctor;
import org.sosy_lab.cpachecker.fshell.targetgraph.mask.BasicBlockEntryMaskFunctor;
import org.sosy_lab.cpachecker.fshell.targetgraph.mask.FunctionCallMaskFunctor;
import org.sosy_lab.cpachecker.fshell.targetgraph.mask.FunctionCallsMaskFunctor;
import org.sosy_lab.cpachecker.fshell.targetgraph.mask.FunctionEntryMaskFunctor;
import org.sosy_lab.cpachecker.fshell.targetgraph.mask.LabelMaskFunctor;
import org.sosy_lab.cpachecker.fshell.targetgraph.mask.LineNumberMaskFunctor;

public class FilterEvaluator {
    private final FilterEvaluationCache mCache = new FilterEvaluationCache();
    private final Visitor mVisitor;
    private final BasicBlockEntryMaskFunctor mBasicBlockEntryMaskFunctor;

    public FilterEvaluator(TargetGraph pTargetGraph, Set<CFAEdge> pBasicBlockEntries) {
        this.mVisitor = new Visitor(pTargetGraph);
        this.mBasicBlockEntryMaskFunctor = new BasicBlockEntryMaskFunctor(pBasicBlockEntries);
    }

    public TargetGraph evaluate(Filter pFilter) {
        return pFilter.accept(this.mVisitor);
    }

    private class Visitor
    implements FilterVisitor<TargetGraph> {
        private TargetGraph mTargetGraph;

        public Visitor(TargetGraph pTargetGraph) {
            this.mTargetGraph = pTargetGraph;
        }

        @Override
        public TargetGraph visit(Identity pIdentity) {
            return this.mTargetGraph;
        }

        @Override
        public TargetGraph visit(File pFileFilter) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pFileFilter)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pFileFilter);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TargetGraph visit(BasicBlockEntry pBasicBlockEntry) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pBasicBlockEntry)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pBasicBlockEntry);
            }
            TargetGraph lResultGraph = TargetGraphUtil.applyStandardEdgeBasedFilter(this.mTargetGraph, FilterEvaluator.this.mBasicBlockEntryMaskFunctor);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pBasicBlockEntry, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(ConditionEdge pConditionEdge) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pConditionEdge)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pConditionEdge);
            }
            AssumeEdgeMaskFunctor lMaskFunctor = AssumeEdgeMaskFunctor.getInstance();
            TargetGraph lResultGraph = TargetGraphUtil.applyStandardEdgeBasedFilter(this.mTargetGraph, lMaskFunctor);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pConditionEdge, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(ConditionGraph pConditionGraph) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pConditionGraph)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pConditionGraph);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TargetGraph visit(DecisionEdge pDecisionEdge) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pDecisionEdge)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pDecisionEdge);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TargetGraph visit(Line pLine) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pLine)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pLine);
            }
            LineNumberMaskFunctor lMaskFunctor = new LineNumberMaskFunctor(pLine.getLine());
            TargetGraph lResultGraph = TargetGraphUtil.applyStandardEdgeBasedFilter(this.mTargetGraph, lMaskFunctor);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pLine, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(FunctionCalls pCalls) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pCalls)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pCalls);
            }
            TargetGraph lResultGraph = TargetGraphUtil.applyStandardEdgeBasedFilter(this.mTargetGraph, FunctionCallsMaskFunctor.getInstance());
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pCalls, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(Column pColumn) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pColumn)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pColumn);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TargetGraph visit(Function pFunc) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pFunc)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pFunc);
            }
            TargetGraph lResultGraph = TargetGraphUtil.applyFunctionNameFilter(this.mTargetGraph, pFunc.getFunctionName());
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pFunc, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(FunctionCall pCall) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pCall)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pCall);
            }
            FunctionCallMaskFunctor lMaskFunctor = new FunctionCallMaskFunctor(pCall.getFunctionName());
            TargetGraph lResultGraph = TargetGraphUtil.applyStandardEdgeBasedFilter(this.mTargetGraph, lMaskFunctor);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pCall, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(FunctionEntry pEntry) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pEntry)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pEntry);
            }
            FunctionEntryMaskFunctor lMaskFunctor = new FunctionEntryMaskFunctor(pEntry.getFunctionName());
            TargetGraph lResultGraph = TargetGraphUtil.applyStandardEdgeBasedFilter(this.mTargetGraph, lMaskFunctor);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pEntry, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(FunctionExit pExit) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pExit)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pExit);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TargetGraph visit(Label pLabel) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pLabel)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pLabel);
            }
            LabelMaskFunctor lMaskFunctor = new LabelMaskFunctor(pLabel.getLabel());
            TargetGraph lResultGraph = TargetGraphUtil.applyStandardEdgeBasedFilter(this.mTargetGraph, lMaskFunctor);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pLabel, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(Expression pExpression) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pExpression)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pExpression);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TargetGraph visit(RegularExpression pRegularExpression) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pRegularExpression)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pRegularExpression);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TargetGraph visit(Complement pComplement) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pComplement)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pComplement);
            }
            TargetGraph lFilteredGraph = pComplement.getFilter().accept(this);
            TargetGraph lResultGraph = TargetGraphUtil.minus(this.mTargetGraph, lFilteredGraph);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pComplement, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(Union pUnion) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pUnion)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pUnion);
            }
            TargetGraph lFirstGraph = pUnion.getFirstFilter().accept(this);
            TargetGraph lSecondGraph = pUnion.getSecondFilter().accept(this);
            TargetGraph lResultGraph = TargetGraphUtil.union(lFirstGraph, lSecondGraph);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pUnion, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(Compose pCompose) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pCompose)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pCompose);
            }
            TargetGraph lFirstGraph = pCompose.getFilterAppliedFirst().accept(this);
            Visitor lTmpVisitor = new Visitor(lFirstGraph);
            TargetGraph lResultGraph = pCompose.getFilterAppliedSecond().accept(lTmpVisitor);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pCompose, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(Intersection pIntersection) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pIntersection)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pIntersection);
            }
            TargetGraph lFirstGraph = pIntersection.getFirstFilter().accept(this);
            TargetGraph lSecondGraph = pIntersection.getSecondFilter().accept(this);
            TargetGraph lResultGraph = TargetGraphUtil.intersect(lFirstGraph, lSecondGraph);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pIntersection, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(SetMinus pSetMinus) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pSetMinus)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pSetMinus);
            }
            TargetGraph lFirstGraph = pSetMinus.getFirstFilter().accept(this);
            TargetGraph lSecondGraph = pSetMinus.getSecondFilter().accept(this);
            TargetGraph lResultGraph = TargetGraphUtil.minus(lFirstGraph, lSecondGraph);
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pSetMinus, lResultGraph);
            return lResultGraph;
        }

        @Override
        public TargetGraph visit(EnclosingScopes pEnclosingScopes) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pEnclosingScopes)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pEnclosingScopes);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TargetGraph visit(Predication pPredication) {
            if (FilterEvaluator.this.mCache.isCached(this.mTargetGraph, pPredication)) {
                return FilterEvaluator.this.mCache.get(this.mTargetGraph, pPredication);
            }
            TargetGraph lTargetGraph = pPredication.getFilter().accept(this);
            TargetGraph lPredicatedTargetGraph = TargetGraphUtil.predicate(lTargetGraph, pPredication.getPredicate());
            FilterEvaluator.this.mCache.add(this.mTargetGraph, pPredication, lPredicatedTargetGraph);
            return lPredicatedTargetGraph;
        }
    }
}

