/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;

public class Path
implements Iterable<Edge> {
    private Node mStartNode;
    private Node mEndNode;
    private List<Edge> mEdges;

    public Path(Node pNode, List<Edge> pEdges) {
        if (pEdges.size() == 0) {
            this.mStartNode = pNode;
            this.mEndNode = pNode;
            this.mEdges = Collections.emptyList();
        } else {
            this.mStartNode = pEdges.get(0).getSource();
            this.mEndNode = pEdges.get(pEdges.size() - 1).getTarget();
            if (!pNode.equals(this.mEndNode)) {
                throw new IllegalArgumentException();
            }
            Node lTmpEndNode = this.mStartNode;
            for (Edge lEdge : pEdges) {
                if (!lTmpEndNode.equals(lEdge.getSource())) {
                    throw new IllegalArgumentException();
                }
                lTmpEndNode = lEdge.getTarget();
            }
            this.mEdges = new ArrayList<Edge>(pEdges);
        }
    }

    public int length() {
        return this.mEdges.size();
    }

    public Node getStartNode() {
        return this.mStartNode;
    }

    public Node getEndNode() {
        return this.mEndNode;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (!this.getClass().equals(pOther.getClass())) {
            return false;
        }
        Path lOther = (Path)pOther;
        return lOther.mStartNode.equals(this.mStartNode) && lOther.mEndNode.equals(this.mEndNode) && ((Object)lOther.mEdges).equals(this.mEdges);
    }

    public int hashCode() {
        return (this.mStartNode.hashCode() * 17 + this.mEndNode.hashCode()) * 31 + ((Object)this.mEdges).hashCode();
    }

    public String toString() {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("[");
        if (this.length() > 0) {
            boolean lIsFirst = true;
            for (Edge lEdge : this.mEdges) {
                if (lIsFirst) {
                    lIsFirst = false;
                } else {
                    lBuffer.append(", ");
                }
                lBuffer.append(lEdge.toString());
            }
        } else {
            lBuffer.append(this.mStartNode.toString());
        }
        lBuffer.append("]");
        return lBuffer.toString();
    }

    @Override
    public Iterator<Edge> iterator() {
        return this.mEdges.iterator();
    }
}

