/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DirectedMaskSubgraph;
import org.jgrapht.graph.MaskFunctor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;
import org.sosy_lab.cpachecker.fshell.targetgraph.Occurrences;
import org.sosy_lab.cpachecker.fshell.targetgraph.Path;

public class TargetGraph {
    private Set<Node> mInitialNodes;
    private Set<Node> mFinalNodes;
    private DirectedGraph<Node, Edge> mGraph;

    private TargetGraph() {
        this.mInitialNodes = Collections.emptySet();
        this.mFinalNodes = Collections.emptySet();
        this.mGraph = new DefaultDirectedGraph(Edge.class);
    }

    private TargetGraph(Set<Node> pInitialNodes, Set<Node> pFinalNodes, DirectedGraph<Node, Edge> pGraph) {
        assert (pInitialNodes != null);
        assert (pFinalNodes != null);
        assert (pGraph != null);
        this.mInitialNodes = pInitialNodes;
        this.mFinalNodes = pFinalNodes;
        this.mGraph = pGraph;
    }

    public TargetGraph(TargetGraph pTargetGraph) {
        assert (pTargetGraph != null);
        this.mInitialNodes = new LinkedHashSet<Node>(pTargetGraph.mInitialNodes);
        this.mFinalNodes = new LinkedHashSet<Node>(pTargetGraph.mFinalNodes);
        this.mGraph = new DefaultDirectedGraph(Edge.class);
        for (Node lNode : pTargetGraph.mGraph.vertexSet()) {
            this.mGraph.addVertex((Object)lNode);
        }
        for (Edge lEdge : pTargetGraph.mGraph.edgeSet()) {
            Node lSourceNode = (Node)pTargetGraph.mGraph.getEdgeSource((Object)lEdge);
            Node lTargetNode = (Node)pTargetGraph.mGraph.getEdgeTarget((Object)lEdge);
            this.mGraph.addEdge((Object)lSourceNode, (Object)lTargetNode, (Object)lEdge);
        }
    }

    public TargetGraph(Edge pEdge) {
        assert (pEdge != null);
        Node lSourceNode = new Node(pEdge.getSource());
        Node lTargetNode = new Node(pEdge.getTarget());
        this.mInitialNodes = Collections.singleton(lSourceNode);
        this.mFinalNodes = Collections.singleton(lTargetNode);
        this.mGraph = new DefaultDirectedGraph(Edge.class);
        new Edge(lSourceNode, lTargetNode, pEdge.getCFAEdge(), (Graph<Node, Edge>)this.mGraph);
    }

    public Set<Node> getNodes() {
        return this.mGraph.vertexSet();
    }

    public Set<Edge> getEdges() {
        return this.mGraph.edgeSet();
    }

    public Set<Path> getBoundedPaths(int pBound) {
        if (pBound <= 0) {
            throw new IllegalArgumentException();
        }
        HashSet<Path> lPaths = new HashSet<Path>();
        LinkedList<Edge> lPrefix = new LinkedList<Edge>();
        Occurrences lOccurrences = new Occurrences();
        for (Node lNode : this.mInitialNodes) {
            this.dfs(lNode, lPrefix, lPaths, lOccurrences, pBound);
        }
        return lPaths;
    }

    private void dfs(Node pCurrentNode, LinkedList<Edge> pPrefix, Set<Path> pPaths, Occurrences pOccurrences, int pBound) {
        if (this.mFinalNodes.contains(pCurrentNode)) {
            pPaths.add(new Path(pCurrentNode, pPrefix));
        }
        for (Edge lOutgoingEdge : this.getOutgoingEdges(pCurrentNode)) {
            int lOccurrences = pOccurrences.increment(lOutgoingEdge);
            if (lOccurrences <= pBound) {
                pPrefix.addLast(lOutgoingEdge);
                this.dfs(lOutgoingEdge.getTarget(), pPrefix, pPaths, pOccurrences, pBound);
                pPrefix.pollLast();
            } else {
                Path lPath = new Path(pCurrentNode, pPrefix);
                pPaths.add(lPath);
            }
            pOccurrences.decrement(lOutgoingEdge);
        }
    }

    public Set<Edge> getOutgoingEdges(Node pNode) {
        return this.mGraph.outgoingEdgesOf((Object)pNode);
    }

    public int getNumberOfOutgoingEdges(Node pNode) {
        return this.mGraph.outDegreeOf((Object)pNode);
    }

    public Set<Edge> getIncomingEdges(Node pNode) {
        return this.mGraph.incomingEdgesOf((Object)pNode);
    }

    public int getNumberOfIncomingEdges(Node pNode) {
        return this.mGraph.inDegreeOf((Object)pNode);
    }

    public Iterable<Node> initialNodes() {
        return this.mInitialNodes;
    }

    public Iterable<Node> finalNodes() {
        return this.mFinalNodes;
    }

    public Iterator<Node> getInitialNodes() {
        return this.mInitialNodes.iterator();
    }

    public Iterator<Node> getFinalNodes() {
        return this.mFinalNodes.iterator();
    }

    public boolean contains(Node pNode) {
        return this.mGraph.vertexSet().contains(pNode);
    }

    public boolean contains(Edge pEdge) {
        return this.mGraph.edgeSet().contains(pEdge);
    }

    public boolean isInitialNode(Node pNode) {
        return this.mInitialNodes.contains(pNode);
    }

    public boolean isFinalNode(Node pNode) {
        return this.mFinalNodes.contains(pNode);
    }

    public String toString() {
        String lInitialNodes = "INITIAL NODES: " + this.mInitialNodes.toString() + "\n";
        String lFinalNodes = "FINAL NODES: " + this.mFinalNodes.toString() + "\n";
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append(lInitialNodes);
        lBuffer.append(lFinalNodes);
        for (Edge lEdge : this.mGraph.edgeSet()) {
            lBuffer.append(lEdge.toString());
            lBuffer.append("\n");
        }
        return lBuffer.toString();
    }

    public static class Builder {
        private static TargetGraph mEmptyGraph = new TargetGraph();
        private boolean mIsCopy = false;
        private TargetGraph mTargetGraph;

        public Builder() {
            this.mTargetGraph = mEmptyGraph;
        }

        public Builder(TargetGraph pTargetGraph) {
            this.mTargetGraph = pTargetGraph;
        }

        public Builder(TargetGraph pTargetGraph, MaskFunctor<Node, Edge> pMaskFunctor) {
            DirectedMaskSubgraph lMaskedGraph = new DirectedMaskSubgraph(pTargetGraph.mGraph, pMaskFunctor);
            this.mTargetGraph = new TargetGraph(new LinkedHashSet(), new LinkedHashSet(), (DirectedGraph)lMaskedGraph);
        }

        public Set<Edge> edges() {
            return Collections.unmodifiableSet(this.mTargetGraph.getEdges());
        }

        public Set<Node> nodes() {
            return Collections.unmodifiableSet(this.mTargetGraph.getNodes());
        }

        public Set<Node> initialNodes() {
            return Collections.unmodifiableSet(this.mTargetGraph.mInitialNodes);
        }

        public Set<Node> finalNodes() {
            return Collections.unmodifiableSet(this.mTargetGraph.mFinalNodes);
        }

        public Edge addEdge(Node pSource, Node pTarget, CFAEdge pCFAEdge) {
            if (!this.mIsCopy) {
                this.mIsCopy = true;
                this.mTargetGraph = new TargetGraph(this.mTargetGraph);
            }
            return new Edge(pSource, pTarget, pCFAEdge, (Graph<Node, Edge>)this.mTargetGraph.mGraph);
        }

        public Edge addEdge(Edge pEdge) {
            return this.addEdge(pEdge.getSource(), pEdge.getTarget(), pEdge.getCFAEdge());
        }

        public void addEdges(Iterable<Edge> pEdges) {
            for (Edge lEdge : pEdges) {
                this.addEdge(lEdge);
            }
        }

        public void addNode(Node pNode) {
            if (!this.mIsCopy) {
                this.mIsCopy = true;
                this.mTargetGraph = new TargetGraph(this.mTargetGraph);
            }
            this.mTargetGraph.mGraph.addVertex((Object)pNode);
        }

        public void addNodes(Iterable<Node> pNodes) {
            for (Node lNode : pNodes) {
                this.addNode(lNode);
            }
        }

        public void addInitialNode(Node pNode) {
            this.addNode(pNode);
            this.mTargetGraph.mInitialNodes.add(pNode);
        }

        public void addInitialNodes(Iterable<Node> pInitialNodes) {
            for (Node lInitialNode : pInitialNodes) {
                this.addInitialNode(lInitialNode);
            }
        }

        public void addFinalNode(Node pNode) {
            this.addNode(pNode);
            this.mTargetGraph.mFinalNodes.add(pNode);
        }

        public void addFinalNodes(Iterable<Node> pFinalNodes) {
            for (Node lFinalNode : pFinalNodes) {
                this.addFinalNode(lFinalNode);
            }
        }

        public TargetGraph build() {
            this.mIsCopy = false;
            return this.mTargetGraph;
        }
    }
}

