/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph;

import java.io.IOException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.ConditionEdge;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Function;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.FunctionCall;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.FunctionCalls;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.FunctionEntry;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Identity;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Label;
import org.sosy_lab.cpachecker.fshell.fql2.ast.filter.Line;
import org.sosy_lab.cpachecker.fshell.targetgraph.FilterEvaluator;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraph;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraphUtil;
import org.sosy_lab.cpachecker.util.predicates.simpleformulas.Constant;
import org.sosy_lab.cpachecker.util.predicates.simpleformulas.Predicate;
import org.sosy_lab.cpachecker.util.predicates.simpleformulas.Variable;

public class TargetGraphTest {
    @Test
    public void test_01() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lMainFunction);
        System.out.println(lTargetGraph);
    }

    @Test
    public void test_02() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/loop1.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lMainFunction);
        System.out.println(lTargetGraph);
    }

    @Test
    public void test_03() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/uninitVars.cil.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lMainFunction);
        System.out.println(lTargetGraph);
    }

    @Test
    public void test_04() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/uninitVars.cil.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lMainFunction);
        TargetGraph lFilteredTargetGraph = TargetGraphUtil.applyFunctionNameFilter(lTargetGraph, "func");
        System.out.println(lFilteredTargetGraph);
    }

    @Test
    public void test_05() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/uninitVars.cil.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lMainFunction);
        TargetGraph lFuncTargetGraph = TargetGraphUtil.applyFunctionNameFilter(lTargetGraph, "func");
        TargetGraph lF2TargetGraph = TargetGraphUtil.applyFunctionNameFilter(lTargetGraph, "f2");
        TargetGraph lUnionGraph = TargetGraphUtil.union(lFuncTargetGraph, lF2TargetGraph);
        System.out.println(lUnionGraph);
    }

    @Test
    public void test_06() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/uninitVars.cil.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lMainFunction);
        TargetGraph lFuncTargetGraph = TargetGraphUtil.applyFunctionNameFilter(lTargetGraph, "func");
        TargetGraph lIntersectionGraph = TargetGraphUtil.intersect(lTargetGraph, lFuncTargetGraph);
        System.out.println(lIntersectionGraph);
    }

    @Test
    public void test_07() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lMainFunction);
        TargetGraph lFuncTargetGraph = TargetGraphUtil.applyFunctionNameFilter(lTargetGraph, "f");
        TargetGraph lMinusGraph = TargetGraphUtil.minus(lTargetGraph, lFuncTargetGraph);
        System.out.println(lMinusGraph);
    }

    @Test
    public void test_08() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lMainFunction);
        TargetGraph lFuncTargetGraph = TargetGraphUtil.applyFunctionNameFilter(lTargetGraph, "f");
        Variable lX = new Variable("x");
        Constant l100 = new Constant(100);
        org.sosy_lab.cpachecker.fshell.fql2.ast.Predicate lPredicate = new org.sosy_lab.cpachecker.fshell.fql2.ast.Predicate(new Predicate(lX, Predicate.Comparison.LESS, l100));
        TargetGraph lPredicatedGraph = TargetGraphUtil.predicate(lFuncTargetGraph, lPredicate);
        System.out.println(lPredicatedGraph);
    }

    @Test
    public void test_09() throws IOException, InvalidConfigurationException, CPAException {
        Set<CFAEdge> lBasicBlockEntries;
        LogManager lLogManager;
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager = new LogManager(lConfiguration)).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode));
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(Identity.getInstance());
        Assert.assertTrue((lFilteredTargetGraph == lTargetGraph ? 1 : 0) != 0);
    }

    @Test
    public void test_10() throws IOException, InvalidConfigurationException, CPAException {
        TargetGraph lFilteredTargetGraph2;
        Function lFunctionFilter;
        Set<CFAEdge> lBasicBlockEntries;
        LogManager lLogManager;
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager = new LogManager(lConfiguration)).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode));
        TargetGraph lFilteredTargetGraph1 = lFilterEvaluator.evaluate(lFunctionFilter = new Function("f"));
        Assert.assertTrue((lFilteredTargetGraph1 == (lFilteredTargetGraph2 = lFilterEvaluator.evaluate(lFunctionFilter)) ? 1 : 0) != 0);
        Function lFunctionFilter2 = new Function("f");
        TargetGraph lFilteredTargetGraph3 = lFilterEvaluator.evaluate(lFunctionFilter2);
        Assert.assertTrue((lFilteredTargetGraph1 == lFilteredTargetGraph3 ? 1 : 0) != 0);
        Function lFunctionFilter3 = new Function("foo");
        TargetGraph lFilteredTargetGraph4 = lFilterEvaluator.evaluate(lFunctionFilter3);
        Assert.assertFalse((boolean)lFilteredTargetGraph3.equals(lFilteredTargetGraph4));
    }

    @Test
    public void test_11() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        Set<CFAEdge> lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode);
        FunctionCall lFunctionCallFilter = new FunctionCall("f");
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries);
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(lFunctionCallFilter);
        System.out.println(lFilteredTargetGraph);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lFunctionCallFilter) ? 1 : 0) != 0);
    }

    @Test
    public void test_12() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/uninitVars.cil.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        Set<CFAEdge> lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode);
        FunctionCall lFunctionCallFilter = new FunctionCall("func");
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries);
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(lFunctionCallFilter);
        System.out.println(lFilteredTargetGraph);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lFunctionCallFilter) ? 1 : 0) != 0);
        FunctionCall lFunctionCallFilter2 = new FunctionCall("func");
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lFunctionCallFilter2) ? 1 : 0) != 0);
    }

    @Test
    public void test_13() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/uninitVars.cil.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        Set<CFAEdge> lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode);
        FunctionCalls lFunctionCallsFilter = FunctionCalls.getInstance();
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries);
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(lFunctionCallsFilter);
        System.out.println(lFilteredTargetGraph);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lFunctionCallsFilter) ? 1 : 0) != 0);
    }

    @Test
    public void test_14() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/uninitVars.cil.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        Set<CFAEdge> lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode);
        FunctionEntry lFunctionEntryFilter = new FunctionEntry("func");
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries);
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(lFunctionEntryFilter);
        System.out.println(lFilteredTargetGraph);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lFunctionEntryFilter) ? 1 : 0) != 0);
        FunctionEntry lFunctionEntryFilter2 = new FunctionEntry("func");
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lFunctionEntryFilter2) ? 1 : 0) != 0);
    }

    @Test
    public void test_15() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/uninitVars.cil.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        Set<CFAEdge> lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode);
        Line lLineFilter = new Line(102);
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries);
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(lLineFilter);
        System.out.println(lFilteredTargetGraph);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lLineFilter) ? 1 : 0) != 0);
        Line lLineFilter2 = new Line(102);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lLineFilter2) ? 1 : 0) != 0);
    }

    @Test
    public void test_21() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        Set<CFAEdge> lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode);
        Label lLabelFilter = new Label("ERROR");
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries);
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(lLabelFilter);
        System.out.println(lFilteredTargetGraph);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lLabelFilter) ? 1 : 0) != 0);
        Label lLabelFilter2 = new Label("ERROR");
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lLabelFilter2) ? 1 : 0) != 0);
    }

    @Test
    public void test_22() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        Set<CFAEdge> lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode);
        Label lLabelFilter = new Label("ERROR");
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries);
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(lLabelFilter);
        System.out.println(lFilteredTargetGraph);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lLabelFilter) ? 1 : 0) != 0);
        Label lLabelFilter2 = new Label("ERROR");
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lLabelFilter2) ? 1 : 0) != 0);
        System.out.println(lFilteredTargetGraph.getBoundedPaths(1));
    }

    @Test
    public void test_23() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        System.out.println(lTargetGraph.getBoundedPaths(1));
    }

    @Test
    public void test_24() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/simple/functionCall.c";
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        Set<CFAEdge> lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode);
        ConditionEdge lFilter = ConditionEdge.getInstance();
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries);
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(lFilter);
        System.out.println(lFilteredTargetGraph);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lFilter) ? 1 : 0) != 0);
    }

    @Test
    public void test_25() throws IOException, InvalidConfigurationException, CPAException {
        String lSourceFileName = "test/programs/fql/conditioncoverage.cil.c";
        String lEntryFunction = "foo";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lInitialNode = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        TargetGraph lTargetGraph = TargetGraphUtil.cfa(lInitialNode);
        Set<CFAEdge> lBasicBlockEntries = TargetGraphUtil.getBasicBlockEntries(lInitialNode);
        ConditionEdge lFilter = ConditionEdge.getInstance();
        FilterEvaluator lFilterEvaluator = new FilterEvaluator(lTargetGraph, lBasicBlockEntries);
        TargetGraph lFilteredTargetGraph = lFilterEvaluator.evaluate(lFilter);
        System.out.println(lFilteredTargetGraph);
        Assert.assertTrue((lFilteredTargetGraph == lFilterEvaluator.evaluate(lFilter) ? 1 : 0) != 0);
    }
}

