/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jgrapht.graph.MaskFunctor;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionExitNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.fshell.fql2.ast.Predicate;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;
import org.sosy_lab.cpachecker.fshell.targetgraph.TargetGraph;
import org.sosy_lab.cpachecker.fshell.targetgraph.mask.FunctionNameMaskFunctor;

public class TargetGraphUtil {
    public static Set<CFAEdge> getBasicBlockEntries(CFANode pInitialNode) {
        LinkedHashSet<CFAEdge> lBasicBlockEntries = new LinkedHashSet<CFAEdge>();
        HashSet<CFAEdge> lVisitedEdges = new HashSet<CFAEdge>();
        LinkedList<CFAEdge> lWorklist = new LinkedList<CFAEdge>();
        TargetGraphUtil.addLeavingEdgesToWorklist(pInitialNode, lWorklist);
        while (!lWorklist.isEmpty()) {
            CFAEdge lCurrentEdge = lWorklist.removeFirst();
            if (lVisitedEdges.contains(lCurrentEdge)) continue;
            lVisitedEdges.add(lCurrentEdge);
            LinkedList<CFAEdge> lTrace = new LinkedList<CFAEdge>();
            CFAEdge lCurrentTraceEdge = lCurrentEdge;
            lTrace.add(lCurrentTraceEdge);
            while (!TargetGraphUtil.isLastEdge(lCurrentTraceEdge)) {
                CFANode lSuccessor = lCurrentTraceEdge.getSuccessor();
                if (lSuccessor.getNumLeavingEdges() != 1) {
                    throw new RuntimeException();
                }
                lCurrentTraceEdge = lSuccessor.getLeavingEdge(0);
                lTrace.add(lCurrentTraceEdge);
            }
            while (!lTrace.isEmpty() && ((CFAEdge)lTrace.getFirst()).getEdgeType().equals((Object)CFAEdgeType.AssumeEdge)) {
                lTrace.removeFirst();
            }
            if (!lTrace.isEmpty()) {
                CFAEdgeType lEdgeType;
                lCurrentEdge = (CFAEdge)lTrace.getFirst();
                for (CFAEdge lCFAEdge : lTrace) {
                    CFAEdgeType lEdgeType2 = lCFAEdge.getEdgeType();
                    if (!lEdgeType2.equals((Object)CFAEdgeType.FunctionCallEdge) && !lEdgeType2.equals((Object)CFAEdgeType.FunctionReturnEdge)) continue;
                    lCurrentTraceEdge = lCFAEdge;
                    break;
                }
                if (!(lEdgeType = lCurrentEdge.getEdgeType()).equals((Object)CFAEdgeType.FunctionCallEdge) && !lEdgeType.equals((Object)CFAEdgeType.FunctionReturnEdge)) {
                    lBasicBlockEntries.add(lCurrentEdge);
                }
            }
            TargetGraphUtil.addLeavingEdgesToWorklist(lCurrentTraceEdge.getSuccessor(), lWorklist);
        }
        return lBasicBlockEntries;
    }

    private static void addLeavingEdgesToWorklist(CFANode pCFANode, Collection<CFAEdge> pWorklist) {
        for (int lIndex = 0; lIndex < pCFANode.getNumLeavingEdges(); ++lIndex) {
            CFAEdge lSuccessorEdge = pCFANode.getLeavingEdge(lIndex);
            pWorklist.add(lSuccessorEdge);
        }
    }

    private static boolean isLastEdge(CFAEdge pCFAEdge) {
        CFANode lSuccessor = pCFAEdge.getSuccessor();
        if (lSuccessor.getNumLeavingEdges() != 1) {
            return true;
        }
        if (lSuccessor.getNumEnteringEdges() != 1) {
            return true;
        }
        return pCFAEdge.getEdgeType().equals((Object)CFAEdgeType.FunctionCallEdge);
    }

    public static TargetGraph cfa(CFANode pInitialNode) {
        if (pInitialNode == null) {
            throw new IllegalArgumentException();
        }
        TargetGraph.Builder lBuilder = new TargetGraph.Builder();
        HashMap<CFANode, Node> lNodeMapping = new HashMap<CFANode, Node>();
        LinkedHashSet<CFANode> lWorklist = new LinkedHashSet<CFANode>();
        HashSet<CFANode> lVisitedNodes = new HashSet<CFANode>();
        lWorklist.add(pInitialNode);
        Node lInitialNode = new Node(pInitialNode);
        lBuilder.addInitialNode(lInitialNode);
        lBuilder.addNode(lInitialNode);
        lNodeMapping.put(pInitialNode, lInitialNode);
        while (!lWorklist.isEmpty()) {
            Node lSuccessorNode;
            CFANode lCFANode = (CFANode)lWorklist.iterator().next();
            lWorklist.remove(lCFANode);
            lVisitedNodes.add(lCFANode);
            Node lNode = (Node)lNodeMapping.get(lCFANode);
            int lNumberOfLeavingEdges = lCFANode.getNumLeavingEdges();
            CallToReturnEdge lCallToReturnEdge = lCFANode.getLeavingSummaryEdge();
            if (lNumberOfLeavingEdges == 0 && lCallToReturnEdge == null) {
                assert (lCFANode instanceof CFAFunctionExitNode);
                lBuilder.addFinalNode(lNode);
                continue;
            }
            for (int lEdgeIndex = 0; lEdgeIndex < lNumberOfLeavingEdges; ++lEdgeIndex) {
                Node lSuccessorNode2;
                CFAEdge lEdge = lCFANode.getLeavingEdge(lEdgeIndex);
                CFANode lSuccessor = lEdge.getSuccessor();
                if (lVisitedNodes.contains(lSuccessor)) {
                    lSuccessorNode2 = (Node)lNodeMapping.get(lSuccessor);
                } else {
                    lSuccessorNode2 = new Node(lSuccessor);
                    lNodeMapping.put(lSuccessor, lSuccessorNode2);
                    lBuilder.addNode(lSuccessorNode2);
                    lWorklist.add(lSuccessor);
                }
                lBuilder.addEdge(lNode, lSuccessorNode2, lEdge);
            }
            if (lCallToReturnEdge == null) continue;
            CFANode lSuccessor = lCallToReturnEdge.getSuccessor();
            if (lVisitedNodes.contains(lSuccessor)) {
                lSuccessorNode = (Node)lNodeMapping.get(lSuccessor);
            } else {
                lSuccessorNode = new Node(lSuccessor);
                lNodeMapping.put(lSuccessor, lSuccessorNode);
                lBuilder.addNode(lSuccessorNode);
                lWorklist.add(lSuccessor);
            }
            lBuilder.addEdge(lNode, lSuccessorNode, lCallToReturnEdge);
        }
        return lBuilder.build();
    }

    public static TargetGraph union(TargetGraph pTargetGraph1, TargetGraph pTargetGraph2) {
        if (pTargetGraph1 == null || pTargetGraph2 == null) {
            throw new IllegalArgumentException();
        }
        TargetGraph.Builder lBuilder = new TargetGraph.Builder(pTargetGraph1);
        lBuilder.addInitialNodes(pTargetGraph2.initialNodes());
        lBuilder.addFinalNodes(pTargetGraph2.finalNodes());
        lBuilder.addNodes(pTargetGraph2.getNodes());
        lBuilder.addEdges(pTargetGraph2.getEdges());
        return lBuilder.build();
    }

    public static TargetGraph intersect(TargetGraph pTargetGraph1, TargetGraph pTargetGraph2) {
        if (pTargetGraph1 == null || pTargetGraph2 == null) {
            throw new IllegalArgumentException();
        }
        TargetGraph.Builder lBuilder = new TargetGraph.Builder();
        for (Node lNode : pTargetGraph1.getNodes()) {
            if (!pTargetGraph2.contains(lNode)) continue;
            lBuilder.addNode(lNode);
        }
        for (Edge lEdge : pTargetGraph1.getEdges()) {
            if (!pTargetGraph2.contains(lEdge)) continue;
            lBuilder.addEdge(lEdge);
        }
        for (Node lInitialNode : pTargetGraph1.initialNodes()) {
            if (!pTargetGraph2.isInitialNode(lInitialNode)) continue;
            lBuilder.addInitialNode(lInitialNode);
        }
        for (Node lFinalNode : pTargetGraph1.finalNodes()) {
            if (!pTargetGraph2.isFinalNode(lFinalNode)) continue;
            lBuilder.addFinalNode(lFinalNode);
        }
        return lBuilder.build();
    }

    public static TargetGraph minus(TargetGraph pTargetGraph1, TargetGraph pTargetGraph2) {
        if (pTargetGraph1 == null || pTargetGraph2 == null) {
            throw new IllegalArgumentException();
        }
        TargetGraph.Builder lBuilder = new TargetGraph.Builder();
        for (Edge lEdge : pTargetGraph1.getEdges()) {
            if (pTargetGraph2.contains(lEdge)) continue;
            lBuilder.addEdge(lEdge);
        }
        for (Node lNode : pTargetGraph1.getNodes()) {
            if (pTargetGraph2.contains(lNode) && pTargetGraph1.getNumberOfOutgoingEdges(lNode) == 0 && pTargetGraph1.getNumberOfIncomingEdges(lNode) == 0) continue;
            lBuilder.addNode(lNode);
            if (pTargetGraph1.isInitialNode(lNode)) {
                lBuilder.addInitialNode(lNode);
            }
            if (!pTargetGraph1.isFinalNode(lNode)) continue;
            lBuilder.addFinalNode(lNode);
        }
        return lBuilder.build();
    }

    public static TargetGraph predicate(TargetGraph pTargetGraph, Predicate pPredicate) {
        Pair lPair;
        if (pTargetGraph == null || pPredicate == null) {
            throw new IllegalArgumentException();
        }
        Predicate lNegatedPredicate = new Predicate(pPredicate.getPredicate().negate());
        TargetGraph.Builder lBuilder = new TargetGraph.Builder();
        HashMap<Node, Pair> lMap = new HashMap<Node, Pair>();
        for (Node lNode : pTargetGraph.getNodes()) {
            Node lTrueNode = new Node(lNode);
            lTrueNode.addPredicate(pPredicate);
            lBuilder.addNode(lTrueNode);
            Node lFalseNode = new Node(lNode);
            lFalseNode.addPredicate(lNegatedPredicate);
            lBuilder.addNode(lFalseNode);
            Pair lPair2 = Pair.of((Object)lTrueNode, (Object)lFalseNode);
            lMap.put(lNode, lPair2);
        }
        for (Node lNode : pTargetGraph.initialNodes()) {
            lPair = (Pair)lMap.get(lNode);
            lBuilder.addInitialNode((Node)lPair.getFirst());
            lBuilder.addInitialNode((Node)lPair.getSecond());
        }
        for (Node lNode : pTargetGraph.finalNodes()) {
            lPair = (Pair)lMap.get(lNode);
            lBuilder.addFinalNode((Node)lPair.getFirst());
            lBuilder.addFinalNode((Node)lPair.getSecond());
        }
        for (Edge lEdge : pTargetGraph.getEdges()) {
            Node lSourceNode = lEdge.getSource();
            Pair lSourcePair = (Pair)lMap.get(lSourceNode);
            Node lTargetNode = lEdge.getTarget();
            Pair lTargetPair = (Pair)lMap.get(lTargetNode);
            Node lSourceTrueNode = (Node)lSourcePair.getFirst();
            Node lSourceFalseNode = (Node)lSourcePair.getSecond();
            Node lTargetTrueNode = (Node)lTargetPair.getFirst();
            Node lTargetFalseNode = (Node)lTargetPair.getSecond();
            lBuilder.addEdge(lSourceTrueNode, lTargetTrueNode, lEdge.getCFAEdge());
            lBuilder.addEdge(lSourceTrueNode, lTargetFalseNode, lEdge.getCFAEdge());
            lBuilder.addEdge(lSourceFalseNode, lTargetTrueNode, lEdge.getCFAEdge());
            lBuilder.addEdge(lSourceFalseNode, lTargetFalseNode, lEdge.getCFAEdge());
        }
        return lBuilder.build();
    }

    public static TargetGraph applyFunctionNameFilter(TargetGraph pTargetGraph, String pFunctionName) {
        if (pTargetGraph == null || pFunctionName == null) {
            throw new IllegalArgumentException();
        }
        FunctionNameMaskFunctor lMaskFunctor = new FunctionNameMaskFunctor(pFunctionName);
        TargetGraph.Builder lBuilder = new TargetGraph.Builder(pTargetGraph, lMaskFunctor);
        for (Node lNode : lBuilder.nodes()) {
            CFANode lCFANode = lNode.getCFANode();
            if (lCFANode instanceof CFAFunctionDefinitionNode) {
                lBuilder.addInitialNode(lNode);
            }
            if (!(lCFANode instanceof CFAFunctionExitNode)) continue;
            lBuilder.addFinalNode(lNode);
        }
        return lBuilder.build();
    }

    public static TargetGraph applyStandardEdgeBasedFilter(TargetGraph pTargetGraph, MaskFunctor<Node, Edge> pMaskFunctor) {
        if (pTargetGraph == null || pMaskFunctor == null) {
            throw new IllegalArgumentException();
        }
        TargetGraph.Builder lBuilder = new TargetGraph.Builder(pTargetGraph, pMaskFunctor);
        for (Edge lEdge : lBuilder.edges()) {
            lBuilder.addInitialNode(lEdge.getSource());
            lBuilder.addFinalNode(lEdge.getTarget());
        }
        return lBuilder.build();
    }
}

