/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph.mask;

import org.jgrapht.graph.MaskFunctor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;

public class AssumeEdgeMaskFunctor
implements MaskFunctor<Node, Edge> {
    private static AssumeEdgeMaskFunctor mInstance = new AssumeEdgeMaskFunctor();

    public static AssumeEdgeMaskFunctor getInstance() {
        return mInstance;
    }

    private AssumeEdgeMaskFunctor() {
    }

    public boolean isEdgeMasked(Edge pEdge) {
        if (pEdge == null) {
            throw new IllegalArgumentException();
        }
        boolean lIsAssumeEdge = this.isAssumeEdge(pEdge.getCFAEdge());
        return !lIsAssumeEdge;
    }

    public boolean isVertexMasked(Node pNode) {
        int lIndex;
        assert (pNode != null);
        CFANode lCFANode = pNode.getCFANode();
        for (lIndex = 0; lIndex < lCFANode.getNumEnteringEdges(); ++lIndex) {
            if (!this.isAssumeEdge(lCFANode.getEnteringEdge(lIndex))) continue;
            return false;
        }
        for (lIndex = 0; lIndex < lCFANode.getNumLeavingEdges(); ++lIndex) {
            if (!this.isAssumeEdge(lCFANode.getLeavingEdge(lIndex))) continue;
            return false;
        }
        return true;
    }

    private boolean isAssumeEdge(CFAEdge pCFAEdge) {
        return pCFAEdge.getEdgeType().equals((Object)CFAEdgeType.AssumeEdge);
    }
}

