/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph.mask;

import org.jgrapht.graph.MaskFunctor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;

public class FunctionCallMaskFunctor
implements MaskFunctor<Node, Edge> {
    private String mFunctionName;

    public FunctionCallMaskFunctor(String pFunctionName) {
        assert (pFunctionName != null);
        this.mFunctionName = pFunctionName;
    }

    public String getFunctionName() {
        return this.mFunctionName;
    }

    private boolean isProperFunctionCallEdge(CFAEdge lEdge) {
        assert (lEdge != null);
        if (lEdge.getEdgeType().equals((Object)CFAEdgeType.FunctionCallEdge)) {
            return lEdge.getSuccessor().getFunctionName().equals(this.mFunctionName);
        }
        return false;
    }

    public boolean isEdgeMasked(Edge pArg0) {
        assert (pArg0 != null);
        return !this.isProperFunctionCallEdge(pArg0.getCFAEdge());
    }

    public boolean isVertexMasked(Node pArg0) {
        int lIndex;
        assert (pArg0 != null);
        CFANode lCFANode = pArg0.getCFANode();
        for (lIndex = 0; lIndex < lCFANode.getNumEnteringEdges(); ++lIndex) {
            if (!this.isProperFunctionCallEdge(lCFANode.getEnteringEdge(lIndex))) continue;
            return false;
        }
        for (lIndex = 0; lIndex < lCFANode.getNumLeavingEdges(); ++lIndex) {
            if (!this.isProperFunctionCallEdge(lCFANode.getLeavingEdge(lIndex))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass() == this.getClass()) {
            FunctionCallMaskFunctor lFunctor = (FunctionCallMaskFunctor)pOther;
            return this.mFunctionName.equals(lFunctor.mFunctionName);
        }
        return false;
    }

    public int hashCode() {
        return 87237737 + this.mFunctionName.hashCode();
    }
}

