/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph.mask;

import org.jgrapht.graph.MaskFunctor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;

public class FunctionCallsMaskFunctor
implements MaskFunctor<Node, Edge> {
    private static FunctionCallsMaskFunctor mInstance = new FunctionCallsMaskFunctor();

    private FunctionCallsMaskFunctor() {
    }

    public static FunctionCallsMaskFunctor getInstance() {
        return mInstance;
    }

    private boolean isFunctionCallEdge(CFAEdge lEdge) {
        assert (lEdge != null);
        return lEdge.getEdgeType().equals((Object)CFAEdgeType.FunctionCallEdge);
    }

    public boolean isEdgeMasked(Edge pArg0) {
        assert (pArg0 != null);
        return !this.isFunctionCallEdge(pArg0.getCFAEdge());
    }

    public boolean isVertexMasked(Node pArg0) {
        int lIndex;
        assert (pArg0 != null);
        CFANode lCFANode = pArg0.getCFANode();
        for (lIndex = 0; lIndex < lCFANode.getNumEnteringEdges(); ++lIndex) {
            if (!this.isFunctionCallEdge(lCFANode.getEnteringEdge(lIndex))) continue;
            return false;
        }
        for (lIndex = 0; lIndex < lCFANode.getNumLeavingEdges(); ++lIndex) {
            if (!this.isFunctionCallEdge(lCFANode.getLeavingEdge(lIndex))) continue;
            return false;
        }
        return true;
    }
}

