/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph.mask;

import org.jgrapht.graph.MaskFunctor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;

public class FunctionEntriesMaskFunctor
implements MaskFunctor<Node, Edge> {
    private static FunctionEntriesMaskFunctor mInstance = new FunctionEntriesMaskFunctor();

    private FunctionEntriesMaskFunctor() {
    }

    public static FunctionEntriesMaskFunctor getInstance() {
        return mInstance;
    }

    private boolean isFunctionEntryEdge(CFAEdge lEdge) {
        assert (lEdge != null);
        return lEdge.getEdgeType().equals((Object)CFAEdgeType.BlankEdge) && lEdge.getPredecessor() instanceof CFAFunctionDefinitionNode;
    }

    public boolean isEdgeMasked(Edge pArg0) {
        assert (pArg0 != null);
        return !this.isFunctionEntryEdge(pArg0.getCFAEdge());
    }

    public boolean isVertexMasked(Node pArg0) {
        int lIndex;
        assert (pArg0 != null);
        CFANode lCFANode = pArg0.getCFANode();
        for (lIndex = 0; lIndex < lCFANode.getNumEnteringEdges(); ++lIndex) {
            if (!this.isFunctionEntryEdge(lCFANode.getEnteringEdge(lIndex))) continue;
            return false;
        }
        for (lIndex = 0; lIndex < lCFANode.getNumLeavingEdges(); ++lIndex) {
            if (!this.isFunctionEntryEdge(lCFANode.getLeavingEdge(lIndex))) continue;
            return false;
        }
        return true;
    }
}

