/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.targetgraph.mask;

import org.jgrapht.graph.MaskFunctor;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.fshell.targetgraph.Edge;
import org.sosy_lab.cpachecker.fshell.targetgraph.Node;

public class LineNumberMaskFunctor
implements MaskFunctor<Node, Edge> {
    private int mLineNumber;

    public LineNumberMaskFunctor(int pLineNumber) {
        assert (pLineNumber > 0);
        this.mLineNumber = pLineNumber;
    }

    public boolean isEdgeMasked(Edge pArg0) {
        assert (pArg0 != null);
        return pArg0.getTarget().getCFANode().getLineNumber() != this.mLineNumber;
    }

    public boolean isVertexMasked(Node pArg0) {
        assert (pArg0 != null);
        CFANode lCFANode = pArg0.getCFANode();
        if (pArg0.getCFANode().getLineNumber() != this.mLineNumber) {
            for (int lIndex = 0; lIndex < lCFANode.getNumLeavingEdges(); ++lIndex) {
                CFAEdge lCFAEdge = lCFANode.getLeavingEdge(lIndex);
                if (lCFAEdge.getSuccessor().getLineNumber() != this.mLineNumber) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass() == this.getClass()) {
            LineNumberMaskFunctor lFunctor = (LineNumberMaskFunctor)pOther;
            return this.mLineNumber == lFunctor.mLineNumber;
        }
        return false;
    }

    public int hashCode() {
        return 234677 + this.mLineNumber;
    }
}

