/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.testcases;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.sosy_lab.cpachecker.fshell.testcases.TestCase;
import org.sosy_lab.cpachecker.fshell.testcases.TestSuite;

public class LoggingTestSuite
extends TestSuite {
    private final TestSuite mTestSuite;
    private final PrintWriter mWriter;

    public LoggingTestSuite(TestSuite pTestSuite, String pTestSuiteFilename, boolean pAppend) throws FileNotFoundException {
        this(pTestSuite, new File(pTestSuiteFilename), pAppend);
    }

    @Override
    public void write(String pTestSuiteOutputFilename) throws FileNotFoundException {
        this.mTestSuite.write(pTestSuiteOutputFilename);
    }

    @Override
    public void write(File pTestSuiteOutputFile) throws FileNotFoundException {
        this.mTestSuite.write(pTestSuiteOutputFile);
    }

    @Override
    public Iterator<TestCase> iterator() {
        return this.mTestSuite.iterator();
    }

    public LoggingTestSuite(TestSuite pTestSuite, File pTestSuiteFile, boolean pAppend) throws FileNotFoundException {
        this.mTestSuite = pTestSuite;
        if (!pAppend) {
            this.mTestSuite.write(pTestSuiteFile);
        }
        this.mWriter = new PrintWriter(new FileOutputStream(pTestSuiteFile, true));
    }

    @Override
    public boolean add(TestCase pTestCase) {
        if (this.mTestSuite.add(pTestCase)) {
            this.mWriter.println(pTestCase);
            this.mWriter.flush();
            return true;
        }
        return false;
    }

    public void close() {
        this.mWriter.close();
    }
}

