/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.testcases;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.FShell3Result;
import org.sosy_lab.cpachecker.fshell.testcases.FShell2ToFShell3;
import org.sosy_lab.cpachecker.fshell.testcases.ImpreciseExecutionException;
import org.sosy_lab.cpachecker.fshell.testcases.TestCase;

public class NondetToInput {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: java org.sosy_lab.cpachecker.fshell.testcases.NondetToInput <source-file> <destination-file>");
            return;
        }
        NondetToInput.replace(args[0], args[1]);
    }

    public static void replace(String pSourceFile, String pDestinationFile) throws IOException {
        String lLine;
        BufferedReader lReader = new BufferedReader(new FileReader(pSourceFile));
        PrintWriter lWriter = new PrintWriter(pDestinationFile);
        lWriter.println("int input(void);");
        lWriter.println();
        Pattern lDeclarationPattern = Pattern.compile("\\s*int\\s*__BLAST_NONDET\\s*;\\s*([/][/])?.*");
        Pattern lDeclarationPattern2 = Pattern.compile("\\s*[{]\\s*int\\s*__BLAST_NONDET\\s*;\\s*([/][/])?.*");
        Pattern lAssignmentPattern = Pattern.compile(".*=\\s*__BLAST_NONDET\\s*;\\s*([/][/])?.*");
        Pattern lAssignmentPattern2 = Pattern.compile(".*=\\s*[(]\\s*[l][o][n][g]\\s*[)]\\s*__BLAST_NONDET\\s*;\\s*([/][/])?.*");
        Pattern lAssignmentPattern3 = Pattern.compile(".*=\\s*[(]\\s*[u][n][s][i][g][n][e][d]\\s+[l][o][n][g]\\s*[)]\\s*__BLAST_NONDET\\s*;\\s*([/][/])?.*");
        Pattern lLinePattern = Pattern.compile("#line .*");
        while ((lLine = lReader.readLine()) != null) {
            String[] lParts;
            if (lDeclarationPattern.matcher(lLine).matches() || lLinePattern.matcher(lLine).matches()) continue;
            if (lDeclarationPattern2.matcher(lLine).matches()) {
                lWriter.println("{");
                continue;
            }
            if (lAssignmentPattern.matcher(lLine).matches()) {
                lParts = lLine.split("=");
                lWriter.println(lParts[0] + "= input();");
                continue;
            }
            if (lAssignmentPattern2.matcher(lLine).matches()) {
                lParts = lLine.split("=");
                lWriter.println(lParts[0] + "= (long)input();");
                continue;
            }
            if (lAssignmentPattern3.matcher(lLine).matches()) {
                lParts = lLine.split("=");
                lWriter.println(lParts[0] + "= (unsigned long)input();");
                continue;
            }
            lWriter.println(lLine);
        }
        lWriter.close();
        lReader.close();
    }

    public static void gcov(String pSourceFileName, String pTestSuiteFileName) throws IOException, InterruptedException {
        NondetToInput.gcov(pSourceFileName, TestCase.fromFile(pTestSuiteFileName));
    }

    public static void gcov(String pSourceFileName, Collection<TestCase> pTestSuite) throws IOException, InterruptedException {
        File lTmpSourceFile = File.createTempFile("source", ".c");
        lTmpSourceFile.deleteOnExit();
        NondetToInput.replace(pSourceFileName, lTmpSourceFile.getAbsolutePath());
        File lTmpExecutable = File.createTempFile("main", "");
        lTmpExecutable.deleteOnExit();
        lTmpExecutable.setWritable(true);
        lTmpExecutable.setExecutable(true);
        File lTmpInputObjectFile = File.createTempFile("input", ".o");
        lTmpInputObjectFile.deleteOnExit();
        lTmpInputObjectFile.setWritable(true);
        File lTmpInputFile = File.createTempFile("input", ".txt");
        lTmpInputFile.deleteOnExit();
        lTmpInputFile.setWritable(true);
        LinkedList<String> lCommand2 = new LinkedList<String>();
        lCommand2.add("/usr/bin/gcc");
        lCommand2.add("-c");
        lCommand2.add("-o");
        lCommand2.add(lTmpInputObjectFile.getAbsolutePath());
        lCommand2.add("-DINPUTFILE=\"" + lTmpInputFile.getAbsolutePath() + "\"");
        lCommand2.add("src/org/sosy_lab/cpachecker/fshell/testcases/input.c");
        ProcessBuilder lBuilder = new ProcessBuilder(new String[0]);
        lBuilder.redirectErrorStream(true);
        lBuilder.command(lCommand2);
        Process lProcess1 = lBuilder.start();
        NondetToInput.printOutput(lProcess1);
        lProcess1.waitFor();
        lCommand2.clear();
        lCommand2.add("/usr/bin/gcc");
        lCommand2.add("-o");
        lCommand2.add(lTmpExecutable.getAbsolutePath());
        lCommand2.add("-fprofile-arcs");
        lCommand2.add("-ftest-coverage");
        lCommand2.add(lTmpSourceFile.getAbsolutePath());
        lCommand2.add(lTmpInputObjectFile.getAbsolutePath());
        lBuilder.command(lCommand2);
        lProcess1 = lBuilder.start();
        NondetToInput.printOutput(lProcess1);
        lProcess1.waitFor();
        for (TestCase lTestCase : pTestSuite) {
            lTestCase.toInputFile(lTmpInputFile);
            lBuilder.command(lTmpExecutable.getAbsolutePath());
            lProcess1 = lBuilder.start();
            if (NondetToInput.printOutput(lProcess1)) {
                System.err.println(lTestCase);
            }
            lProcess1.waitFor();
        }
        lCommand2.clear();
        lCommand2.add("/usr/bin/gcov");
        lCommand2.add("-b");
        lCommand2.add(lTmpSourceFile.getAbsolutePath());
        lBuilder.command(lCommand2);
        lProcess1 = lBuilder.start();
        NondetToInput.printOutput(lProcess1);
        lProcess1.waitFor();
        File lTmpGCovFile = new File(lTmpSourceFile.getName() + ".gcov");
        lTmpGCovFile.delete();
        File lTmpGCdaFile = new File(lTmpSourceFile.getName().substring(0, lTmpSourceFile.getName().length() - 2) + ".gcda");
        lTmpGCdaFile.delete();
        File lTmpGCnoFile = new File(lTmpSourceFile.getName().substring(0, lTmpSourceFile.getName().length() - 2) + ".gcno");
        lTmpGCnoFile.delete();
    }

    private static boolean printOutput(Process pProcess) throws IOException {
        String lLine;
        boolean lErrorOccured = false;
        BufferedReader lReader = new BufferedReader(new InputStreamReader(pProcess.getInputStream()));
        while ((lLine = lReader.readLine()) != null) {
            if (lLine.startsWith("[ERROR] #")) {
                lErrorOccured = true;
                System.err.println(lLine);
                continue;
            }
            System.out.println(lLine);
        }
        return lErrorOccured;
    }

    public static void fshell2(String pSourceFile, String pEntryFunction, String pFQLQuery, int pLoopBound) throws IOException, InterruptedException, InvalidConfigurationException, CPAException, ImpreciseExecutionException {
        String lLine;
        File lTmpSourceFile = File.createTempFile("source", ".c");
        lTmpSourceFile.deleteOnExit();
        NondetToInput.replace(pSourceFile, lTmpSourceFile.getAbsolutePath());
        File lTmpQueryFile = File.createTempFile("query", ".fql");
        lTmpQueryFile.deleteOnExit();
        PrintWriter lWriter = new PrintWriter(lTmpQueryFile);
        lWriter.println("ADD SOURCECODE '" + lTmpSourceFile.getAbsolutePath() + "'");
        lWriter.println(pFQLQuery);
        lWriter.println("QUIT");
        lWriter.close();
        File lTmpOutputFile = File.createTempFile("testsuite", ".tst");
        lTmpOutputFile.deleteOnExit();
        LinkedList<String> lCommand = new LinkedList<String>();
        lCommand.add("/home/andreas/fshell2-1.2/fshell");
        lCommand.add("--query-file");
        lCommand.add(lTmpQueryFile.getAbsolutePath());
        lCommand.add("--outfile");
        lCommand.add(lTmpOutputFile.getAbsolutePath());
        lCommand.add("--unwind");
        lCommand.add("" + pLoopBound);
        lCommand.add("--no-unwinding-assertions");
        lCommand.add("--function");
        lCommand.add(pEntryFunction);
        ProcessBuilder lBuilder = new ProcessBuilder(new String[0]);
        lBuilder.command(lCommand);
        lBuilder.redirectErrorStream(true);
        Process lProcess = lBuilder.start();
        BufferedReader lReader = new BufferedReader(new InputStreamReader(lProcess.getInputStream()));
        while ((lLine = lReader.readLine()) != null) {
            System.out.println(lLine);
        }
        lProcess.waitFor();
        File lTmpTestSuite = File.createTempFile("testsuite", ".tst");
        lTmpTestSuite.deleteOnExit();
        FShell2ToFShell3.translateTestsuite(lTmpOutputFile.getAbsolutePath(), lTmpTestSuite.getAbsolutePath());
        Collection<TestCase> lTestSuite = TestCase.fromFile(lTmpTestSuite.getAbsolutePath());
        System.out.println(lTestSuite);
        FShell3 lFShell3 = new FShell3(pSourceFile, pEntryFunction);
        lFShell3.seed(lTestSuite);
        FShell3Result lResult = lFShell3.run("COVER \"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\".EDGES(@BASICBLOCKENTRY).\"EDGES(ID)*\"");
        System.out.println("#Goals: " + lResult.getNumberOfTestGoals() + ", #Feas: " + lResult.getNumberOfFeasibleTestGoals() + ", #Infeas: " + lResult.getNumberOfInfeasibleTestGoals() + ", #Imprecise: " + lResult.getNumberOfImpreciseTestCases());
    }
}

