/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.fshell.testcases;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.fshell.testcases.ImpreciseInputsTestCase;
import org.sosy_lab.cpachecker.fshell.testcases.PreciseInputsTestCase;
import org.sosy_lab.cpachecker.util.predicates.Model;

public abstract class TestCase {
    private int[] mInputs;
    private boolean mIsPrecise;

    protected TestCase(List<Integer> pInputs, boolean pIsPrecise) {
        this.mInputs = new int[pInputs.size()];
        int lIndex = 0;
        for (Integer lValue : pInputs) {
            this.mInputs[lIndex] = lValue;
            ++lIndex;
        }
        this.mIsPrecise = pIsPrecise;
    }

    protected TestCase(int[] pInputs, boolean pIsPrecise) {
        this.mInputs = new int[pInputs.length];
        for (int lIndex = 0; lIndex < this.mInputs.length; ++lIndex) {
            this.mInputs[lIndex] = pInputs[lIndex];
        }
        this.mIsPrecise = pIsPrecise;
    }

    protected static boolean equal(int[] lInputs1, int[] lInputs2) {
        if (lInputs1.length == lInputs2.length) {
            for (int lIndex = 0; lIndex < lInputs1.length; ++lIndex) {
                if (lInputs1[lIndex] == lInputs2[lIndex]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean equalInputs(int[] lOtherInputs) {
        return TestCase.equal(this.mInputs, lOtherInputs);
    }

    public boolean isPrecise() {
        return this.mIsPrecise;
    }

    public int[] getInputs() {
        return this.mInputs;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (this.getClass().equals(pOther.getClass())) {
            TestCase lTestCase = (TestCase)pOther;
            if (this.mIsPrecise == lTestCase.mIsPrecise) {
                return this.equalInputs(lTestCase.mInputs);
            }
        }
        return false;
    }

    public String toInputString() {
        StringBuilder lBuilder = new StringBuilder();
        for (int lValue : this.mInputs) {
            lBuilder.append(lValue + "\n");
        }
        return lBuilder.toString();
    }

    public void toInputFile(File pFile) throws FileNotFoundException {
        PrintWriter lWriter = new PrintWriter(pFile);
        lWriter.print(this.toInputString());
        lWriter.close();
    }

    public String toCFunction() {
        StringBuilder lCFunctionBuilder = new StringBuilder();
        lCFunctionBuilder.append("#include <stdio.h>\n");
        lCFunctionBuilder.append("#include <stdlib.h>\n");
        lCFunctionBuilder.append("\n");
        lCFunctionBuilder.append("int input()\n");
        lCFunctionBuilder.append("{\n");
        lCFunctionBuilder.append("  static int index = 0;\n");
        lCFunctionBuilder.append("  int testcase[] = {");
        for (int lIndex = 0; lIndex < this.mInputs.length; ++lIndex) {
            if (lIndex > 0) {
                lCFunctionBuilder.append(",");
            }
            lCFunctionBuilder.append(this.mInputs[lIndex]);
        }
        lCFunctionBuilder.append("};\n");
        lCFunctionBuilder.append("  if (index == " + this.mInputs.length + ")\n");
        lCFunctionBuilder.append("  {\n");
        lCFunctionBuilder.append("    fprintf(stderr, \"[ERROR] test case too short!\\n\");\n");
        lCFunctionBuilder.append("    exit(-1);\n");
        lCFunctionBuilder.append("  }\n");
        lCFunctionBuilder.append("  return testcase[index++];\n");
        lCFunctionBuilder.append("}\n");
        return lCFunctionBuilder.toString();
    }

    public String toString() {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append(this.isPrecise() ? "p" : "i");
        for (int lIndex = 0; lIndex < this.mInputs.length; ++lIndex) {
            lBuffer.append(",");
            lBuffer.append(this.mInputs[lIndex]);
        }
        return lBuffer.toString();
    }

    public static Collection<TestCase> fromFile(String pFileName) throws IOException {
        return TestCase.fromFile(new File(pFileName));
    }

    public static Collection<TestCase> fromFile(File pFile) throws IOException {
        LinkedList<TestCase> lTestSuite = new LinkedList<TestCase>();
        BufferedReader lReader = new BufferedReader(new FileReader(pFile));
        String lLine = null;
        while ((lLine = lReader.readLine()) != null) {
            if ((lLine = lLine.trim()).length() == 0) continue;
            lTestSuite.add(TestCase.fromString(lLine));
        }
        return lTestSuite;
    }

    public static void toFile(Collection<TestCase> pTestSuite, File pTestSuiteFile) throws FileNotFoundException {
        PrintWriter lWriter = new PrintWriter(pTestSuiteFile);
        for (TestCase lTestCase : pTestSuite) {
            lWriter.println(lTestCase.toString());
        }
        lWriter.close();
    }

    public static TestCase fromString(String pTestCase) {
        boolean lIsPrecise;
        String[] lParts = pTestCase.split(",");
        if (lParts.length == 0) {
            throw new RuntimeException();
        }
        if (lParts[0].equals("p")) {
            lIsPrecise = true;
        } else if (lParts[0].equals("i")) {
            lIsPrecise = false;
        } else {
            throw new RuntimeException();
        }
        int[] lValues = new int[lParts.length - 1];
        for (int lIndex = 0; lIndex < lValues.length; ++lIndex) {
            lValues[lIndex] = Integer.parseInt(lParts[lIndex + 1]);
        }
        if (lIsPrecise) {
            return new PreciseInputsTestCase(lValues);
        }
        return new ImpreciseInputsTestCase(lValues);
    }

    public static TestCase fromCounterexample(CounterexampleInfo pTraceInfo, LogManager pLogManager) {
        Model lModel = (Model)((Object)pTraceInfo.getTargetPathAssignment());
        return TestCase.fromCounterexample(lModel, pLogManager);
    }

    public static TestCase fromCounterexample(Model pCounterexample, LogManager pLogManager) {
        boolean lIsPrecise = true;
        TreeMap<Integer, Double> lNondetMap = new TreeMap<Integer, Double>();
        TreeMap<Integer, Boolean> lNondetFlagMap = new TreeMap<Integer, Boolean>();
        for (Map.Entry lAssignment : pCounterexample.entrySet()) {
            double lDoubleValue;
            Integer lIndex;
            Model.AssignableTerm lTerm = (Model.AssignableTerm)lAssignment.getKey();
            if (!(lTerm instanceof Model.Variable)) continue;
            Model.Variable lVar = (Model.Variable)lTerm;
            String lName = lVar.getName();
            if (lName.equals("__nondet__")) {
                lIndex = lVar.getSSAIndex();
                lDoubleValue = Double.parseDouble(lAssignment.getValue().toString());
                lNondetMap.put(lIndex, lDoubleValue);
                continue;
            }
            if (!lName.equals("__nondet__flag__")) continue;
            lIndex = lVar.getSSAIndex();
            lDoubleValue = Double.parseDouble(lAssignment.getValue().toString());
            if (lDoubleValue != 0.0) {
                lNondetFlagMap.put(lIndex, true);
                continue;
            }
            lNondetFlagMap.put(lIndex, false);
        }
        LinkedList<Integer> lInput = new LinkedList<Integer>();
        for (Map.Entry lEntry : lNondetMap.entrySet()) {
            Integer lKey = (Integer)lEntry.getKey();
            if (!((Boolean)lNondetFlagMap.get(lKey)).booleanValue()) continue;
            Double lValue = (Double)lEntry.getValue();
            int lIntValue = lValue.intValue();
            if (lValue != (double)lIntValue) {
                lIsPrecise = false;
            }
            lInput.add(lIntValue);
        }
        if (lIsPrecise) {
            return new PreciseInputsTestCase(lInput);
        }
        return new ImpreciseInputsTestCase(lInput);
    }
}

