/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElementWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperElement;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingElement;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.util.TreeIterable;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public final class AbstractElements {
    public static final Function<AbstractElement, CFANode> EXTRACT_LOCATION = new Function<AbstractElement, CFANode>(){

        public CFANode apply(AbstractElement pArg0) {
            return AbstractElements.extractLocation(pArg0);
        }
    };
    public static final Predicate<AbstractElement> IS_TARGET_ELEMENT = new Predicate<AbstractElement>(){

        public boolean apply(AbstractElement pArg0) {
            return AbstractElements.isTargetElement(pArg0);
        }
    };
    private static final Function<AbstractElement, Iterator<? extends AbstractElement>> ABSTRACT_ELEMENT_CHILDREN_FUNCTION = new Function<AbstractElement, Iterator<? extends AbstractElement>>(){

        public Iterator<? extends AbstractElement> apply(AbstractElement element) {
            if (element instanceof AbstractSingleWrapperElement) {
                AbstractElement wrapped = ((AbstractSingleWrapperElement)element).getWrappedElement();
                return Iterators.singletonIterator((Object)wrapped);
            }
            if (element instanceof AbstractWrapperElement) {
                return ((AbstractWrapperElement)element).getWrappedElements().iterator();
            }
            return null;
        }
    };
    private static final Function<AbstractElement, Iterable<AbstractElement>> AS_ITERABLE = new Function<AbstractElement, Iterable<AbstractElement>>(){

        public Iterable<AbstractElement> apply(AbstractElement pElement) {
            return AbstractElements.asIterable(pElement);
        }
    };

    private AbstractElements() {
    }

    public static <T extends AbstractElement> T extractElementByType(AbstractElement pElement, Class<T> pType) {
        if (pType.isInstance(pElement)) {
            return (T)((AbstractElement)pType.cast(pElement));
        }
        if (pElement instanceof AbstractSingleWrapperElement) {
            AbstractElement wrapped = ((AbstractSingleWrapperElement)pElement).getWrappedElement();
            return AbstractElements.extractElementByType(wrapped, pType);
        }
        if (pElement instanceof AbstractWrapperElement) {
            for (AbstractElement abstractElement : ((AbstractWrapperElement)pElement).getWrappedElements()) {
                T result = AbstractElements.extractElementByType(abstractElement, pType);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static <T extends AbstractElement> Iterable<T> projectToType(Iterable<AbstractElement> elements, Class<T> pType) {
        return Iterables.filter((Iterable)Iterables.transform(elements, AbstractElements.extractElementByTypeFunction(pType)), (Predicate)Predicates.notNull());
    }

    public static <T extends AbstractElement> Iterable<T> extractAllElementsOfType(AbstractElement pElement, Class<T> pType) {
        return Iterables.filter(AbstractElements.asIterable(pElement), pType);
    }

    public static CFANode extractLocation(AbstractElement pElement) {
        AbstractElementWithLocation e = AbstractElements.extractElementByType(pElement, AbstractElementWithLocation.class);
        return e == null ? null : e.getLocationNode();
    }

    public static Iterable<CFANode> extractLocations(Iterable<? extends AbstractElement> pElements) {
        if (pElements instanceof LocationMappedReachedSet) {
            return ((LocationMappedReachedSet)pElements).getLocations();
        }
        return Iterables.filter((Iterable)Iterables.transform(pElements, EXTRACT_LOCATION), (Predicate)Predicates.notNull());
    }

    public static Iterable<AbstractElement> filterLocation(Iterable<AbstractElement> pElements, CFANode pLoc) {
        if (pElements instanceof LocationMappedReachedSet) {
            return ((LocationMappedReachedSet)pElements).getReached(pLoc);
        }
        return Iterables.filter(pElements, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)pLoc), EXTRACT_LOCATION));
    }

    public static boolean isTargetElement(AbstractElement e) {
        return e instanceof Targetable && ((Targetable)((Object)e)).isTarget();
    }

    public static <T extends AbstractElement> Iterable<T> filterTargetElements(Iterable<T> pElements) {
        return Iterables.filter(pElements, IS_TARGET_ELEMENT);
    }

    public static <T extends AbstractElement> Function<AbstractElement, T> extractElementByTypeFunction(final Class<T> pType) {
        return new Function<AbstractElement, T>(){

            public T apply(AbstractElement ae) {
                return AbstractElements.extractElementByType(ae, pType);
            }
        };
    }

    public static Iterable<AbstractElement> asIterable(AbstractElement ae) {
        return new TreeIterable<AbstractElement>(ae, ABSTRACT_ELEMENT_CHILDREN_FUNCTION);
    }

    public static Iterable<AbstractElement> asIterable(Iterable<AbstractElement> pElements) {
        return Iterables.concat((Iterable)Iterables.transform(pElements, AS_ITERABLE));
    }

    public static Formula extractReportedFormulas(FormulaManager manager, AbstractElement element) {
        Formula result = manager.makeTrue();
        for (FormulaReportingElement e : AbstractElements.extractAllElementsOfType(element, FormulaReportingElement.class)) {
            result = manager.makeAnd(result, e.getFormulaApproximation(manager));
        }
        return result;
    }
}

