/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.exceptions.ParserException;

public class CFAUtils {
    public static Iterable<CFAEdge> allEnteringEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new Iterable<CFAEdge>(){

            @Override
            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i;
                    {
                        this.i = node.getEnteringSummaryEdge() != null ? -1 : 0;
                    }

                    public boolean hasNext() {
                        return this.i < node.getNumEnteringEdges();
                    }

                    public CFAEdge next() {
                        if (this.i == -1) {
                            this.i = 0;
                            return node.getEnteringSummaryEdge();
                        }
                        return node.getEnteringEdge(this.i++);
                    }
                };
            }
        };
    }

    public static Iterable<CFAEdge> enteringEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new Iterable<CFAEdge>(){

            @Override
            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i = 0;

                    public boolean hasNext() {
                        return this.i < node.getNumEnteringEdges();
                    }

                    public CFAEdge next() {
                        return node.getEnteringEdge(this.i++);
                    }
                };
            }
        };
    }

    public static Iterable<CFAEdge> allLeavingEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new Iterable<CFAEdge>(){

            @Override
            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i;
                    {
                        this.i = node.getLeavingSummaryEdge() != null ? -1 : 0;
                    }

                    public boolean hasNext() {
                        return this.i < node.getNumLeavingEdges();
                    }

                    public CFAEdge next() {
                        if (this.i == -1) {
                            this.i = 0;
                            return node.getLeavingSummaryEdge();
                        }
                        return node.getLeavingEdge(this.i++);
                    }
                };
            }
        };
    }

    public static Iterable<CFAEdge> leavingEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new Iterable<CFAEdge>(){

            @Override
            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i = 0;

                    public boolean hasNext() {
                        return this.i < node.getNumLeavingEdges();
                    }

                    public CFAEdge next() {
                        return node.getLeavingEdge(this.i++);
                    }
                };
            }
        };
    }

    public static Collection<Loop> findLoops(SortedSet<CFANode> nodes) throws ParserException {
        boolean changed;
        int min = nodes.first().getNodeNumber();
        int max = nodes.last().getNodeNumber();
        int size = max + 1 - min;
        nodes = new TreeSet<CFANode>(nodes);
        CFANode[] nodesArray = new CFANode[size];
        Edge[][] edges = new Edge[size][size];
        for (CFANode n : nodes) {
            int i = n.getNodeNumber() - min;
            assert (nodesArray[i] == null);
            nodesArray[i] = n;
            for (int e = 0; e < n.getNumLeavingEdges(); ++e) {
                CFAEdge edge = n.getLeavingEdge(e);
                CFANode succ = edge.getSuccessor();
                int j = succ.getNodeNumber() - min;
                edges[i][j] = new Edge();
            }
        }
        ArrayList<Loop> loops = new ArrayList<Loop>();
        do {
            if ((changed = CFAUtils.identifyLoops(false, nodes, min, nodesArray, edges, loops)) || nodes.isEmpty()) continue;
            changed = CFAUtils.identifyLoops(true, nodes, min, nodesArray, edges, loops);
        } while (changed && !nodes.isEmpty());
        if (!nodes.isEmpty()) {
            throw new ParserException("Code structure is too complex, could not detect all loops!");
        }
        TreeSet<Integer> toRemove = new TreeSet<Integer>();
        for (int i1 = 0; i1 < loops.size(); ++i1) {
            Loop l1 = (Loop)loops.get(i1);
            for (int i2 = i1 + 1; i2 < loops.size(); ++i2) {
                Loop l2 = (Loop)loops.get(i2);
                if (!l1.intersectsWith(l2)) continue;
                if (l1.isOuterLoopOf(l2)) {
                    l1.addNodes(l2);
                    continue;
                }
                if (l2.isOuterLoopOf(l1)) {
                    l2.addNodes(l1);
                    continue;
                }
                l1.mergeWith(l2);
                toRemove.add(i2);
            }
        }
        Iterator i$ = toRemove.descendingSet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            loops.remove(i);
        }
        return loops;
    }

    private static boolean identifyLoops(boolean reverseMerge, SortedSet<CFANode> nodes, int offset, CFANode[] nodesArray, Edge[][] edges, List<Loop> loops) {
        int size = edges.length;
        boolean changed = false;
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Edge targetEdge;
            CFANode currentNode = (CFANode)it.next();
            int current = currentNode.getNodeNumber() - offset;
            int predecessor = CFAUtils.findSingleIncomingEdgeOfNode(current, edges);
            int successor = CFAUtils.findSingleOutgoingEdgeOfNode(current, edges);
            if (predecessor == -1 && successor == -1) {
                it.remove();
                continue;
            }
            if (predecessor == -1 && successor > -1) {
                int successor2 = CFAUtils.findSingleOutgoingEdgeOfNode(successor, edges);
                if (successor2 != -1) continue;
                edges[current][successor] = null;
                it.remove();
                continue;
            }
            if (successor == -1 && predecessor > -1) {
                int predecessor2 = CFAUtils.findSingleIncomingEdgeOfNode(predecessor, edges);
                if (predecessor2 != -1) continue;
                edges[predecessor][current] = null;
                it.remove();
                continue;
            }
            if (predecessor > -1 && successor != -1) {
                changed = true;
                for (int j = 0; j < size; ++j) {
                    if (edges[current][j] == null) continue;
                    targetEdge = CFAUtils.getEdge(predecessor, j, edges);
                    targetEdge.add(edges[predecessor][current]);
                    targetEdge.add(edges[current][j]);
                    targetEdge.add(currentNode);
                    edges[current][j] = null;
                }
                edges[predecessor][current] = null;
                it.remove();
                if (edges[predecessor][predecessor] == null) continue;
                CFANode pred = nodesArray[predecessor];
                CFAUtils.handleLoop(pred, predecessor, edges, loops);
                continue;
            }
            if (!reverseMerge || successor <= -1 || predecessor == -1) continue;
            changed = true;
            for (int j = 0; j < size; ++j) {
                if (edges[j][current] == null) continue;
                targetEdge = CFAUtils.getEdge(j, successor, edges);
                targetEdge.add(edges[j][current]);
                targetEdge.add(edges[current][successor]);
                targetEdge.add(currentNode);
                edges[j][current] = null;
            }
            edges[current][successor] = null;
            it.remove();
            if (edges[successor][successor] == null) continue;
            CFANode succ = nodesArray[successor];
            CFAUtils.handleLoop(succ, successor, edges, loops);
        }
        return changed;
    }

    private static Edge getEdge(int i, int j, Edge[][] edges) {
        Edge result = edges[i][j];
        if (edges[i][j] == null) {
            edges[i][j] = result = new Edge();
        }
        return result;
    }

    private static void handleLoop(CFANode loopHead, int loopHeadIndex, Edge[][] edges, Collection<Loop> loops) {
        assert (loopHead != null);
        Loop loop = new Loop(loopHead, edges[loopHeadIndex][loopHeadIndex].asNodeSet());
        loops.add(loop);
        edges[loopHeadIndex][loopHeadIndex] = null;
    }

    private static int findSingleIncomingEdgeOfNode(int i, Edge[][] edges) {
        int size = edges.length;
        int predecessor = -1;
        for (int j = 0; j < size; ++j) {
            if (edges[j][i] == null) continue;
            if (predecessor > -1) {
                return -2;
            }
            predecessor = j;
        }
        return predecessor;
    }

    private static int findSingleOutgoingEdgeOfNode(int i, Edge[][] edges) {
        int size = edges.length;
        int successor = -1;
        for (int j = 0; j < size; ++j) {
            if (edges[i][j] == null) continue;
            if (successor > -1) {
                return -2;
            }
            successor = j;
        }
        return successor;
    }

    public static class Loop {
        private ImmutableSet<CFANode> loopHeads;
        private ImmutableSortedSet<CFANode> nodes;
        private ImmutableSet<CFAEdge> innerLoopEdges;
        private ImmutableSet<CFAEdge> incomingEdges;
        private ImmutableSet<CFAEdge> outgoingEdges;

        public Loop(CFANode loopHead, Set<CFANode> pNodes) {
            this.loopHeads = ImmutableSet.of((Object)loopHead);
            this.nodes = ImmutableSortedSet.naturalOrder().addAll(pNodes).add((Object)loopHead).build();
        }

        private void computeSets() {
            if (this.innerLoopEdges != null) {
                assert (this.incomingEdges != null);
                assert (this.outgoingEdges != null);
            }
            HashSet<CFAEdge> incomingEdges = new HashSet<CFAEdge>();
            HashSet<CFAEdge> outgoingEdges = new HashSet<CFAEdge>();
            for (CFANode n : this.nodes) {
                int i;
                for (i = 0; i < n.getNumEnteringEdges(); ++i) {
                    incomingEdges.add(n.getEnteringEdge(i));
                }
                for (i = 0; i < n.getNumLeavingEdges(); ++i) {
                    outgoingEdges.add(n.getLeavingEdge(i));
                }
            }
            this.innerLoopEdges = Sets.intersection(incomingEdges, outgoingEdges).immutableCopy();
            incomingEdges.removeAll((Collection<?>)this.innerLoopEdges);
            outgoingEdges.removeAll((Collection<?>)this.innerLoopEdges);
            assert (!incomingEdges.isEmpty()) : "Unreachable loop?";
            this.incomingEdges = ImmutableSet.copyOf(incomingEdges);
            this.outgoingEdges = ImmutableSet.copyOf(outgoingEdges);
        }

        void addNodes(Loop l) {
            this.nodes = ImmutableSortedSet.naturalOrder().addAll(this.nodes).addAll(l.nodes).build();
            this.innerLoopEdges = null;
            this.incomingEdges = null;
            this.outgoingEdges = null;
        }

        void mergeWith(Loop l) {
            this.loopHeads = Sets.union(this.loopHeads, l.loopHeads).immutableCopy();
            this.addNodes(l);
        }

        public boolean intersectsWith(Loop l) {
            return !Sets.intersection(this.nodes, l.nodes).isEmpty();
        }

        public boolean isOuterLoopOf(Loop other) {
            this.computeSets();
            other.computeSets();
            return this.innerLoopEdges.containsAll(other.incomingEdges) && this.innerLoopEdges.containsAll(other.outgoingEdges);
        }

        public ImmutableSortedSet<CFANode> getLoopNodes() {
            return this.nodes;
        }

        public ImmutableSet<CFANode> getLoopHeads() {
            return this.loopHeads;
        }

        public ImmutableSet<CFAEdge> getIncomingEdges() {
            this.computeSets();
            return this.incomingEdges;
        }

        public ImmutableSet<CFAEdge> getOutgoingEdges() {
            this.computeSets();
            return this.outgoingEdges;
        }

        public String toString() {
            this.computeSets();
            return "Loop with heads " + this.loopHeads + "\n" + "  incoming: " + this.incomingEdges + "\n" + "  outgoing: " + this.outgoingEdges + "\n" + "  nodes:    " + this.nodes;
        }
    }

    private static class Edge {
        private final Set<CFANode> nodes = new HashSet<CFANode>(1);

        private Edge() {
        }

        private void add(Edge n) {
            this.nodes.addAll(n.nodes);
        }

        private void add(CFANode n) {
            this.nodes.add(n);
        }

        private Set<CFANode> asNodeSet() {
            return this.nodes;
        }
    }
}

