/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;

public class Cilly {
    private static final String mCillyAsmExePath = "cilly.asm.exe";
    private final LogManager logger;
    private boolean mDoSimplify = true;
    private boolean mPrintCilAsIs = true;
    private boolean mDoMakeCFG = true;
    private boolean mDoSimpleMem = false;

    public static void main(String[] pArguments) throws IOException, InvalidConfigurationException {
        assert (pArguments != null);
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = new LogManager(config);
        if (pArguments.length != 1) {
            logger.log(Level.SEVERE, new Object[]{"You have to specify a source file!"});
        } else {
            String lNiceCILName = Cilly.getNiceCILName(pArguments[0]);
            Cilly lCilly = new Cilly(logger);
            lCilly.cillyfy(pArguments[0], lNiceCILName);
            logger.log(Level.INFO, new Object[]{"Wrote output to", lNiceCILName});
        }
    }

    public Cilly(LogManager logger) {
        this.logger = logger;
    }

    public void setDoSimplify(boolean pValue) {
        this.mDoSimplify = pValue;
    }

    public void setPrintCilAsIs(boolean pValue) {
        this.mPrintCilAsIs = pValue;
    }

    public void setDoMakeCFG(boolean pValue) {
        this.mDoMakeCFG = pValue;
    }

    public void setDoSimpleMem(boolean pValue) {
        this.mDoSimpleMem = pValue;
    }

    public boolean isCillyInvariant(String pSourceFile) throws IOException {
        if (pSourceFile == null) {
            throw new IllegalArgumentException("Parameter is null!");
        }
        return this.isCillyInvariant(new File(pSourceFile));
    }

    public boolean isCillyInvariant(File pSourceFile) throws IOException {
        String lCillyfiedLine;
        String lSourceLine;
        if (pSourceFile == null) {
            throw new IllegalArgumentException();
        }
        if (!pSourceFile.exists()) {
            throw new IllegalArgumentException("File " + pSourceFile.getAbsolutePath() + " does not exist!");
        }
        if (!pSourceFile.canRead()) {
            throw new IllegalArgumentException();
        }
        File lCillyfiedFile = this.cillyfy(pSourceFile);
        BufferedReader lSourceReader = new BufferedReader(new FileReader(pSourceFile));
        BufferedReader lCillyfiedReader = new BufferedReader(new FileReader(lCillyfiedFile));
        do {
            lSourceLine = lSourceReader.readLine();
            lCillyfiedLine = lCillyfiedReader.readLine();
            if (lSourceLine != null) continue;
            lSourceReader.close();
            lCillyfiedReader.close();
            return lCillyfiedLine == null;
        } while (lSourceLine.trim().equals(lCillyfiedLine.trim()));
        lSourceReader.close();
        lCillyfiedReader.close();
        return false;
    }

    public File cillyfy(String pSourceFile) throws IOException {
        assert (pSourceFile != null);
        return this.cillyfy(new File(pSourceFile));
    }

    public static String getNiceCILName(String pFileName) {
        String lPostfix;
        String lPrefix;
        assert (pFileName != null);
        int lLastIndex = pFileName.lastIndexOf(".");
        if (lLastIndex < 0) {
            lPrefix = pFileName;
            lPostfix = "c";
        } else {
            lPrefix = pFileName.substring(0, lLastIndex);
            lPostfix = pFileName.substring(lLastIndex + 1, pFileName.length());
        }
        return lPrefix + ".cil." + lPostfix;
    }

    public File cillyfy(File pSourceFile) throws IOException {
        String lPostfix;
        String lPrefix;
        if (pSourceFile == null) {
            throw new IllegalArgumentException();
        }
        String lSourceFileString = pSourceFile.getName();
        int lLastIndex = lSourceFileString.lastIndexOf(".");
        if (lLastIndex < 0) {
            lPrefix = lSourceFileString;
            lPostfix = "c";
        } else {
            lPrefix = lSourceFileString.substring(0, lLastIndex);
            lPostfix = lSourceFileString.substring(lLastIndex + 1, lSourceFileString.length());
        }
        File lTargetFile = File.createTempFile(lPrefix + ".cil.", "." + lPostfix);
        this.cillyfy(pSourceFile, lTargetFile);
        return lTargetFile;
    }

    public File cillyfy(String pSourceFile, String pTargetFile) throws IOException {
        assert (pSourceFile != null);
        assert (pTargetFile != null);
        File lTargetFile = new File(pTargetFile);
        this.cillyfy(new File(pSourceFile), lTargetFile);
        return lTargetFile;
    }

    public void cillyfy(File pSourceFile, File pTargetFile) throws IOException {
        if (pSourceFile == null) {
            throw new IllegalArgumentException();
        }
        if (!pSourceFile.exists()) {
            throw new IllegalArgumentException();
        }
        if (!pSourceFile.canRead()) {
            throw new IllegalArgumentException();
        }
        if (pTargetFile == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer lOptionsString = new StringBuffer();
        if (this.mDoSimplify) {
            lOptionsString.append(" --dosimplify");
        }
        if (this.mPrintCilAsIs) {
            lOptionsString.append(" --printCilAsIs");
        }
        if (this.mDoMakeCFG) {
            lOptionsString.append(" --domakeCFG");
        }
        if (this.mDoSimpleMem) {
            lOptionsString.append(" --dosimpleMem");
        }
        lOptionsString.append(" --out ");
        lOptionsString.append(pTargetFile.toString());
        String lExecString = mCillyAsmExePath + lOptionsString.toString() + " " + pSourceFile.getAbsolutePath();
        ProcessExecutor lCillyProcess = new ProcessExecutor(this.logger, IOException.class, lExecString.split(" "));
        try {
            int lExitValue = lCillyProcess.join();
            if (lExitValue != 0) {
                throw new RuntimeException("Cilly processing failed!");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

