/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.Cilly;

public class CillyTest {
    private static LogManager logger;

    @BeforeClass
    public static void setup() throws IOException, InvalidConfigurationException {
        Configuration config = Configuration.defaultConfiguration();
        logger = new LogManager(config);
    }

    @Test
    public void test001() throws IOException {
        Cilly lCilly = new Cilly(logger);
        lCilly.cillyfy("test/programs/simple/functionCall.c");
    }

    @Test
    public void test002() throws IOException {
        Cilly lCilly = new Cilly(logger);
        Assert.assertFalse((boolean)lCilly.isCillyInvariant("test/programs/simple/functionCall.c"));
    }

    @Test
    public void test003() throws IOException {
        Cilly lCilly = new Cilly(logger);
        File lCillyfiedFile = lCilly.cillyfy("test/programs/simple/functionCall.c");
        System.out.println(lCillyfiedFile);
        Assert.assertTrue((boolean)lCilly.isCillyInvariant(lCillyfiedFile));
    }

    @Test
    public void test004() throws IOException {
        Assert.assertEquals((Object)"test/programs/simple/functionCall.cil.c", (Object)Cilly.getNiceCILName("test/programs/simple/functionCall.c"));
    }
}

