/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier;

public enum MachineModel {
    LINUX32(2, 4, 4, 8, 4, 8, 12, 1, 1),
    LINUX64(2, 4, 8, 8, 4, 8, 16, 1, 1);

    private final int sizeofShort;
    private final int sizeofInt;
    private final int sizeofLongInt;
    private final int sizeofLongLongInt;
    private final int sizeofFloat;
    private final int sizeofDouble;
    private final int sizeofLongDouble;
    private final int sizeofVoid;
    private final int sizeofBool;
    private final int mSizeofChar = 1;

    private MachineModel(int pSizeofShort, int pSizeofInt, int pSizeofLongInt, int pSizeofLongLongInt, int pSizeofFloat, int pSizeofDouble, int pSizeofLongDouble, int pSizeofVoid, int pSizeofBool) {
        this.sizeofShort = pSizeofShort;
        this.sizeofInt = pSizeofInt;
        this.sizeofLongInt = pSizeofLongInt;
        this.sizeofLongLongInt = pSizeofLongLongInt;
        this.sizeofFloat = pSizeofFloat;
        this.sizeofDouble = pSizeofDouble;
        this.sizeofLongDouble = pSizeofLongDouble;
        this.sizeofVoid = pSizeofVoid;
        this.sizeofBool = pSizeofBool;
    }

    public int getSizeofShort() {
        return this.sizeofShort;
    }

    public int getSizeofInt() {
        return this.sizeofInt;
    }

    public int getSizeofLongInt() {
        return this.sizeofLongInt;
    }

    public int getSizeofLongLongInt() {
        return this.sizeofLongLongInt;
    }

    public int getSizeofFloat() {
        return this.sizeofFloat;
    }

    public int getSizeofDouble() {
        return this.sizeofDouble;
    }

    public int getSizeofLongDouble() {
        return this.sizeofLongDouble;
    }

    public int getSizeofVoid() {
        return this.sizeofVoid;
    }

    public int getSizeofBool() {
        return this.sizeofBool;
    }

    public int getSizeofChar() {
        return 1;
    }

    public int getSizeof(IASTSimpleDeclSpecifier type) {
        switch (type.getType()) {
            case UNSPECIFIED: {
                return this.getSizeofInt();
            }
            case VOID: {
                return this.getSizeofVoid();
            }
            case BOOL: {
                return this.getSizeofBool();
            }
            case CHAR: {
                return this.getSizeofChar();
            }
            case FLOAT: {
                return this.getSizeofFloat();
            }
            case INT: {
                if (type.isLongLong()) {
                    return this.getSizeofLongLongInt();
                }
                if (type.isLong()) {
                    return this.getSizeofLongInt();
                }
                if (type.isShort()) {
                    return this.getSizeofShort();
                }
                return this.getSizeofInt();
            }
            case DOUBLE: {
                if (type.isLong()) {
                    return this.getSizeofLongDouble();
                }
                return this.getSizeofDouble();
            }
        }
        throw new AssertionError((Object)("Unrecognized BasicType " + (Object)((Object)type.getType())));
    }
}

