/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class TreeIterable<T>
implements Iterable<T> {
    private final Function<T, Iterator<? extends T>> childrenFunction;
    private final T root;

    public TreeIterable(T pRoot, Function<T, Iterator<? extends T>> pChildrenFunction) {
        this.root = pRoot;
        this.childrenFunction = pChildrenFunction;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Deque<Iterator<? extends T>> stack = new ArrayDeque();
            {
                this.stack.push((Iterator)Iterators.singletonIterator((Object)TreeIterable.this.root));
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public T next() {
                Iterator children;
                Iterator currentIterator = this.stack.peek();
                Preconditions.checkState((boolean)currentIterator.hasNext());
                Object current = currentIterator.next();
                if (!currentIterator.hasNext()) {
                    this.stack.pop();
                }
                if ((children = (Iterator)TreeIterable.this.childrenFunction.apply(current)) != null && children.hasNext()) {
                    this.stack.push(children);
                }
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

