/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.assumptions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class AssumptionWithLocation {
    private final FormulaManager manager;
    private final Map<CFANode, Formula> map = new HashMap<CFANode, Formula>();
    private static final Function<Map.Entry<CFANode, Formula>, String> assumptionFormatter = new Function<Map.Entry<CFANode, Formula>, String>(){

        public String apply(Map.Entry<CFANode, Formula> entry) {
            int nodeId = entry.getKey().getNodeNumber();
            Formula assumption = entry.getValue();
            return "pc = " + nodeId + "\t =====>  " + assumption.toString();
        }
    };

    public AssumptionWithLocation(FormulaManager pManager) {
        this.manager = pManager;
    }

    public static AssumptionWithLocation copyOf(AssumptionWithLocation a) {
        AssumptionWithLocation result = new AssumptionWithLocation(a.manager);
        result.map.putAll(a.map);
        return result;
    }

    public int getNumberOfLocations() {
        return this.map.size();
    }

    public String toString() {
        return Joiner.on((char)'\n').join((Iterable)Collections2.transform(this.map.entrySet(), assumptionFormatter));
    }

    public void add(CFANode node, Formula assumption) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)assumption);
        if (!assumption.isTrue()) {
            Formula oldInvariant = this.map.get(node);
            if (oldInvariant == null) {
                this.map.put(node, assumption);
            } else {
                this.map.put(node, this.manager.makeAnd(oldInvariant, assumption));
            }
        }
    }
}

