/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.blocking;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.blocking.ReducedEdge;
import org.sosy_lab.cpachecker.util.blocking.ReducedFunction;
import org.sosy_lab.cpachecker.util.blocking.ReducedNode;
import org.sosy_lab.cpachecker.util.blocking.interfaces.BlockComputer;

@Options(prefix="blockreducer")
public class BlockedCFAReducer
implements BlockComputer {
    @Option(description="Do at most n summarizations on a node.")
    private int reductionThreshold = 100;
    @Option(description="Allow reduction of loop heads; calculate abstractions alwasy at loop heads?")
    private boolean allowReduceLoopHeads = false;
    @Option(description="Allow reduction of function entries; calculate abstractions alwasy at function entries?")
    private boolean allowReduceFunctionEntries = true;
    @Option(description="Allow reduction of function exits; calculate abstractions alwasy at function exits?")
    private boolean allowReduceFunctionExits = true;
    @Option(name="reducedCfaFile", description="write the reduced cfa to the specified file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File reducedCfaFile = new File("ReducedCfa.rsf");
    private int functionCallSeq = 0;
    private final Deque<CFAFunctionDefinitionNode> inliningStack;

    public BlockedCFAReducer(Configuration pConfig) throws InvalidConfigurationException {
        if (pConfig != null) {
            pConfig.inject((Object)this);
        }
        this.inliningStack = new ArrayDeque<CFAFunctionDefinitionNode>();
    }

    private boolean isAbstractionNode(ReducedNode pNode) {
        return pNode.isLoopHead() && !this.allowReduceLoopHeads || pNode.isFunctionEntry() && !this.allowReduceFunctionEntries || pNode.isFunctionExit() && !this.allowReduceFunctionExits;
    }

    private void incSummarizationsOnNode(ReducedNode pNode, int pIncBy) {
        assert (this.reductionThreshold > 0);
        pNode.incSummarizations(pIncBy);
    }

    public int getSummarizationsOnNode(ReducedNode pNode) {
        return pNode.getSummarizations();
    }

    protected boolean applySequenceRule(ReducedFunction pApplyTo) {
        boolean result = false;
        ArrayDeque<ReducedNode> toTraverse = new ArrayDeque<ReducedNode>();
        HashSet<ReducedEdge> traverseDone = new HashSet<ReducedEdge>();
        toTraverse.add(pApplyTo.getEntryNode());
        while (toTraverse.size() > 0) {
            ReducedNode u = (ReducedNode)toTraverse.remove();
            for (ReducedEdge e : pApplyTo.getLeavingEdges(u)) {
                ReducedEdge[] vLeavingEdges;
                ReducedNode v = e.getPointsTo();
                if (!traverseDone.add(e) || u == v || (vLeavingEdges = pApplyTo.getLeavingEdges(v)).length == 0) continue;
                if (this.getSummarizationsOnNode(u) + vLeavingEdges.length > this.reductionThreshold) {
                    toTraverse.add(v);
                    continue;
                }
                if (pApplyTo.getNumEnteringEdges(v) != 1) {
                    toTraverse.add(v);
                    continue;
                }
                if (this.isAbstractionNode(v)) {
                    toTraverse.add(v);
                    continue;
                }
                boolean uvRemoved = false;
                for (ReducedEdge f : vLeavingEdges) {
                    ReducedNode w = f.getPointsTo();
                    assert (u != v);
                    assert (v != w);
                    ReducedEdge sumEdge = new ReducedEdge(w);
                    sumEdge.addEdge(e);
                    sumEdge.addEdge(f);
                    pApplyTo.removeEdge(v, w, f);
                    if (!uvRemoved) {
                        pApplyTo.removeEdge(u, v, e);
                        this.incSummarizationsOnNode(u, v.getSummarizations());
                        uvRemoved = true;
                    }
                    pApplyTo.addEdge(u, w, sumEdge);
                    this.incSummarizationsOnNode(u, 1);
                }
                toTraverse.clear();
                traverseDone.clear();
                toTraverse.add(u);
                result = true;
            }
        }
        return result;
    }

    protected boolean applyChoiceRule(ReducedFunction pApplyTo) {
        boolean result = false;
        ArrayDeque<ReducedNode> toTraverse = new ArrayDeque<ReducedNode>();
        HashSet<ReducedNode> traverseDone = new HashSet<ReducedNode>();
        toTraverse.add(pApplyTo.getEntryNode());
        while (toTraverse.size() > 0) {
            ReducedNode u = (ReducedNode)toTraverse.removeFirst();
            if (traverseDone.contains(u)) continue;
            ReducedEdge[] leavingEdges = pApplyTo.getLeavingEdges(u);
            if (leavingEdges.length < 2 || this.getSummarizationsOnNode(u) >= this.reductionThreshold) {
                for (ReducedEdge e : leavingEdges) {
                    toTraverse.add(e.getPointsTo());
                }
                traverseDone.add(u);
                continue;
            }
            boolean onePairMerged = false;
            for (int x = 0; x < leavingEdges.length && !onePairMerged; ++x) {
                for (int y = x + 1; y < leavingEdges.length && !onePairMerged; ++y) {
                    ReducedNode v2;
                    ReducedEdge edgeX = leavingEdges[x];
                    ReducedEdge edgeY = leavingEdges[y];
                    ReducedNode v1 = edgeX.getPointsTo();
                    if (v1 == (v2 = edgeY.getPointsTo())) {
                        ReducedEdge sumEdge = new ReducedEdge(v1);
                        sumEdge.addEdge(edgeX);
                        sumEdge.addEdge(edgeY);
                        pApplyTo.removeEdge(u, v1, edgeX);
                        pApplyTo.removeEdge(u, v2, edgeY);
                        pApplyTo.addEdge(u, v1, sumEdge);
                        this.incSummarizationsOnNode(u, 1);
                        onePairMerged = true;
                        continue;
                    }
                    toTraverse.add(v1);
                    toTraverse.add(v2);
                }
            }
            if (onePairMerged) {
                toTraverse.clear();
                traverseDone.clear();
                toTraverse.add(u);
                result = true;
                continue;
            }
            traverseDone.add(u);
        }
        return result;
    }

    private ReducedFunction inlineAndSummarize(CFAFunctionDefinitionNode pFunctionNode) {
        ++this.functionCallSeq;
        this.inliningStack.push(pFunctionNode);
        HashSet<CFAEdge> traversed = new HashSet<CFAEdge>();
        ArrayDeque<ReducedNode> openEndpoints = new ArrayDeque<ReducedNode>();
        FunctionNodeManager functionNodes = new FunctionNodeManager(this.functionCallSeq);
        ReducedNode entryNode = functionNodes.getWrapper(pFunctionNode);
        ReducedNode exitNode = functionNodes.getWrapper(pFunctionNode.getExitNode());
        ReducedFunction result = new ReducedFunction(entryNode, exitNode);
        openEndpoints.add(result.getEntryNode());
        while (openEndpoints.size() > 0) {
            ReducedNode uSn = (ReducedNode)openEndpoints.removeFirst();
            for (CFAEdge e : CFAUtils.leavingEdges(uSn.getWrapped())) {
                if (!traversed.add(e)) continue;
                if (e instanceof FunctionCallEdge) {
                    FunctionCallEdge callEdge = (FunctionCallEdge)e;
                    ReducedNode callReturnTarget = functionNodes.getWrapper(callEdge.getSummaryEdge().getSuccessor());
                    FunctionDefinitionNode calledFunction = callEdge.getSuccessor();
                    if (this.inliningStack.contains(calledFunction)) {
                        System.out.println("Ignoring recursion of " + calledFunction.getFunctionName());
                        result.addEdge(uSn, callReturnTarget);
                    } else {
                        ReducedFunction functionSum = this.inlineAndSummarize(calledFunction);
                        result.insertFunctionSum(functionSum);
                        result.addEdge(uSn, functionSum.getEntryNode());
                        if (functionSum.getExitNode().getWrapped().getNumEnteringEdges() > 0) {
                            result.addEdge(functionSum.getExitNode(), callReturnTarget);
                        }
                    }
                    openEndpoints.add(callReturnTarget);
                    continue;
                }
                if (e.getSuccessor() == pFunctionNode.getExitNode()) {
                    result.addEdge(uSn, exitNode);
                    continue;
                }
                ReducedNode vSn = functionNodes.getWrapper(e.getSuccessor());
                result.addEdge(uSn, vSn);
                openEndpoints.add(vSn);
            }
        }
        this.applyReductionSequences(result);
        this.inliningStack.pop();
        return result;
    }

    protected void applyReductionSequences(ReducedFunction pApplyTo) {
        boolean choiceApplied;
        boolean sequenceApplied;
        do {
            sequenceApplied = this.applySequenceRule(pApplyTo);
            choiceApplied = this.applyChoiceRule(pApplyTo);
        } while (sequenceApplied || choiceApplied);
    }

    private String getRsfEntryFor(ReducedNode pNode) {
        return String.format("%s_%s_%d_%d", pNode.getWrapped().getFunctionName(), pNode.getNodeKindText(), pNode.getFunctionCallId(), pNode.getWrapped().getLineNumber());
    }

    public void printInlinedCfa(Map<ReducedNode, Map<ReducedNode, Set<ReducedEdge>>> pInlinedCfa, PrintStream pOut) {
        for (ReducedNode u : pInlinedCfa.keySet()) {
            Map<ReducedNode, Set<ReducedEdge>> uTarget = pInlinedCfa.get(u);
            for (ReducedNode v : uTarget.keySet()) {
                for (int i = 0; i < uTarget.get(v).size(); ++i) {
                    pOut.println(String.format("REL\t%s\t%s", this.getRsfEntryFor(u), this.getRsfEntryFor(v)));
                }
            }
        }
    }

    @Override
    public synchronized ImmutableSet<CFANode> computeAbstractionNodes(CFA pCfa) {
        assert (pCfa != null);
        assert (this.inliningStack.size() == 0);
        assert (this.functionCallSeq == 0);
        this.functionCallSeq = 0;
        ReducedFunction reducedProgram = this.inlineAndSummarize(pCfa.getMainFunction());
        if (this.reducedCfaFile != null) {
            try {
                Map<ReducedNode, Map<ReducedNode, Set<ReducedEdge>>> inlinedCfa = reducedProgram.getInlinedCfa();
                PrintStream out = new PrintStream(this.reducedCfaFile);
                this.printInlinedCfa(inlinedCfa, out);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Set<ReducedNode> abstractionNodes = reducedProgram.getAllActiveNodes();
        HashSet<CFANode> result = new HashSet<CFANode>(abstractionNodes.size());
        for (ReducedNode n : abstractionNodes) {
            result.add(n.getWrapped());
        }
        System.out.println(String.format("CFANodes: %d, AbstNodes: %d, summarizationThresold: %d", pCfa.getAllNodes().size(), result.size(), this.reductionThreshold));
        return ImmutableSet.copyOf(result);
    }

    private static class FunctionNodeManager {
        private Map<CFANode, ReducedNode> nodeMapping = new HashMap<CFANode, ReducedNode>();
        private int functionCallId;

        public ReducedNode getWrapper(CFANode pNode) {
            ReducedNode result = this.nodeMapping.get(pNode);
            if (result == null) {
                result = new ReducedNode(pNode);
                result.setFunctionCallId(this.functionCallId);
                this.nodeMapping.put(pNode, result);
            }
            return result;
        }

        public FunctionNodeManager(int pFunctionCallId) {
            this.functionCallId = pFunctionCallId;
        }
    }

    public static enum AbstractionMode {
        REDUCTION_REMAINDER_TS,
        FUNCTIONENTRY_ON_TS;

    }
}

