/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.blocking;

import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionExitNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;

public class ReducedNode {
    private static int uniqueNodeIdSequence = 0;
    private final CFANode wrappedNode;
    private final int uniqueNodeId;
    private int summarizations;
    private boolean isAbstractioNode;
    private int functionCallId;

    public ReducedNode(CFANode pWrappedNode) {
        this.wrappedNode = pWrappedNode;
        this.uniqueNodeId = uniqueNodeIdSequence++;
        this.summarizations = 0;
        this.functionCallId = 0;
        this.isAbstractioNode = false;
    }

    public CFANode getWrapped() {
        return this.wrappedNode;
    }

    public int getUniqueNodeId() {
        return this.uniqueNodeId;
    }

    public int getSummarizations() {
        return this.summarizations;
    }

    public void incSummarizations(int pIncBy) {
        this.summarizations += pIncBy;
    }

    public void setIsAbstractionNode(boolean pIsAbstractionNode) {
        this.isAbstractioNode = pIsAbstractionNode;
    }

    public boolean getIsAbstractionNode() {
        return this.isAbstractioNode || this.getWrapped().isLoopStart();
    }

    public boolean isFunctionEntry() {
        return this.getWrapped() instanceof CFAFunctionDefinitionNode;
    }

    public boolean isFunctionExit() {
        return this.getWrapped() instanceof CFAFunctionExitNode;
    }

    public boolean isLoopHead() {
        return this.getWrapped().isLoopStart();
    }

    public String getNodeKindText() {
        if (this.isLoopHead()) {
            return "LoopHead";
        }
        if (this.isFunctionEntry()) {
            return "FunctEntry";
        }
        if (this.isFunctionExit()) {
            return "FunctExit";
        }
        return "Generic";
    }

    public void setFunctionCallId(int pCallId) {
        this.functionCallId = pCallId;
    }

    public int getFunctionCallId() {
        return this.functionCallId;
    }
}

