/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;

class BasicBlock {
    private static final String SINGLE_INDENT = "  ";
    private final int elementId;
    private boolean condition;
    private boolean isClosedBefore = false;
    private final String firstCodeLine;
    private final List<Object> codeList;

    public BasicBlock(int pElementId, String pFunctionName) {
        this.elementId = pElementId;
        this.codeList = new ArrayList<Object>();
        this.firstCodeLine = pFunctionName;
    }

    public BasicBlock(int pElementId, AssumeEdge pEdge, String pConditionString) {
        boolean truthAssumption;
        this.elementId = pElementId;
        this.codeList = new ArrayList<Object>();
        this.condition = truthAssumption = pEdge.getTruthAssumption();
        this.firstCodeLine = pConditionString;
    }

    public int getElementId() {
        return this.elementId;
    }

    public boolean isCondition() {
        return this.condition;
    }

    public boolean isClosedBefore() {
        return this.isClosedBefore;
    }

    public void setClosedBefore(boolean pIsClosedBefore) {
        this.isClosedBefore = pIsClosedBefore;
    }

    public void write(Object pStatement) {
        if (!(pStatement instanceof String) || !((String)pStatement).isEmpty()) {
            this.codeList.add(pStatement);
        }
    }

    public String getCode() {
        return this.getCode("").toString();
    }

    private StringBuilder getCode(String pIndent) {
        StringBuilder ret = new StringBuilder();
        ret.append(pIndent);
        ret.append(this.firstCodeLine);
        ret.append(" {\n");
        String indent = pIndent + SINGLE_INDENT;
        for (Object obj : this.codeList) {
            if (obj instanceof String) {
                ret.append(indent);
                ret.append((String)obj);
            } else if (obj instanceof BasicBlock) {
                ret.append((CharSequence)((BasicBlock)obj).getCode(indent));
            } else assert (false);
            ret.append("\n");
        }
        ret.append(pIndent);
        ret.append("}\n");
        return ret;
    }

    public String toString() {
        return "Element id: " + this.elementId + " Condition: " + this.condition + " .. is closed " + this.isClosedBefore;
    }
}

