/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.util.Stack;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;

class Edge
implements Comparable<Edge> {
    private final ARTElement childElement;
    private final CFAEdge edge;
    private final Stack<FunctionBody> stack;

    public Edge(ARTElement pChildElement, CFAEdge pEdge, Stack<FunctionBody> pStack) {
        this.childElement = pChildElement;
        this.edge = pEdge;
        this.stack = pStack;
    }

    public ARTElement getChildElement() {
        return this.childElement;
    }

    public CFAEdge getEdge() {
        return this.edge;
    }

    public Stack<FunctionBody> getStack() {
        return this.stack;
    }

    @Override
    public int compareTo(Edge pO) {
        int otherElementId = pO.getChildElement().getElementId();
        int thisElementId = this.getChildElement().getElementId();
        if (thisElementId > otherElementId) {
            return 1;
        }
        if (thisElementId < otherElementId) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (pObj instanceof Edge) {
            int otherElementId = ((Edge)pObj).getChildElement().getElementId();
            int thisElementId = this.getChildElement().getElementId();
            return thisElementId == otherElementId;
        }
        return false;
    }

    public int hashCode() {
        return this.getChildElement().getElementId();
    }
}

