/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.util.Iterator;
import java.util.Stack;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.util.cwriter.BasicBlock;

class FunctionBody
implements Iterable<BasicBlock> {
    private final Stack<BasicBlock> stack = new Stack();

    public FunctionBody(int pElementId, String pFunctionName) {
        this.stack.push(new BasicBlock(pElementId, pFunctionName));
    }

    public FunctionBody(FunctionBody oldStack) {
        this.stack.addAll(oldStack.stack);
    }

    public void enterBlock(int pElementId, AssumeEdge pEdge, String pConditionString) {
        BasicBlock block = new BasicBlock(pElementId, pEdge, pConditionString);
        this.stack.peek().write(block);
        this.stack.push(block);
    }

    public void leaveBlock() {
        this.stack.pop();
    }

    public BasicBlock getCurrentBlock() {
        return this.stack.peek();
    }

    public int size() {
        return this.stack.size();
    }

    @Override
    public Iterator<BasicBlock> iterator() {
        return this.stack.iterator();
    }

    public void write(String s) {
        this.stack.peek().write(s);
    }

    public String toString() {
        return ((BasicBlock)this.stack.get(0)).getCode();
    }
}

