/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.util.cwriter.BasicBlock;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;

class MergeNode {
    private final int elementId;
    private final Map<Integer, Pair<Boolean, Boolean>> branchesMap;
    private final List<FunctionBody> incomingElements;

    public MergeNode(int pElementId) {
        this.elementId = pElementId;
        this.branchesMap = new HashMap<Integer, Pair<Boolean, Boolean>>();
        this.incomingElements = new ArrayList<FunctionBody>();
    }

    public int addBranch(FunctionBody currentFunction) {
        this.incomingElements.add(currentFunction);
        HashSet<Integer> processedConditions = new HashSet<Integer>();
        for (BasicBlock elementInStack : currentFunction) {
            int idOfElementInStack = elementInStack.getElementId();
            boolean nextConditionValue = elementInStack.isCondition();
            boolean isClosedBefore = elementInStack.isClosedBefore();
            if (this.branchesMap.containsKey(idOfElementInStack)) {
                Pair<Boolean, Boolean> conditionPair = this.branchesMap.get(idOfElementInStack);
                boolean firstConditionValue = (Boolean)conditionPair.getFirst();
                boolean secondConditionValue = (Boolean)conditionPair.getSecond();
                if (!isClosedBefore && !secondConditionValue && !(firstConditionValue ^ nextConditionValue)) continue;
                processedConditions.add(idOfElementInStack);
                continue;
            }
            this.branchesMap.put(idOfElementInStack, (Pair<Boolean, Boolean>)Pair.of((Object)nextConditionValue, (Object)isClosedBefore));
        }
        this.setProcessedElements(processedConditions);
        return this.incomingElements.size();
    }

    private void setProcessedElements(Set<Integer> pProcessedConditions) {
        for (FunctionBody stack : this.incomingElements) {
            for (BasicBlock elem : stack) {
                if (!pProcessedConditions.contains(elem.getElementId())) continue;
                elem.setClosedBefore(true);
            }
        }
    }

    public List<FunctionBody> getIncomingElements() {
        return this.incomingElements;
    }

    public String toString() {
        return "id: " + this.elementId + " >> " + this.branchesMap;
    }
}

