/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.MultiEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.cwriter.Edge;
import org.sosy_lab.cpachecker.util.cwriter.FunctionBody;
import org.sosy_lab.cpachecker.util.cwriter.MergeNode;

public class PathToCTranslator {
    private static Function<IASTNode, String> RAW_SIGNATURE_FUNCTION = new Function<IASTNode, String>(){

        public String apply(IASTNode pArg0) {
            return pArg0.toASTString();
        }
    };
    private final List<String> mGlobalDefinitionsList = new ArrayList<String>();
    private final List<String> mFunctionDecls = new ArrayList<String>();
    private int mFunctionIndex = 0;
    private final List<FunctionBody> mFunctionBodies = new ArrayList<FunctionBody>();

    private PathToCTranslator() {
    }

    public static String translatePaths(ARTElement artRoot, Set<ARTElement> elementsOnErrorPath) {
        PathToCTranslator translator = new PathToCTranslator();
        translator.translatePaths0(artRoot, elementsOnErrorPath);
        return translator.generateCCode();
    }

    public static String translateSinglePath(Path pPath) {
        PathToCTranslator translator = new PathToCTranslator();
        translator.translateSinglePath0(pPath);
        return translator.generateCCode();
    }

    private String generateCCode() {
        ArrayList<String> includeList = new ArrayList<String>();
        includeList.add("#include<stdio.h>");
        return Joiner.on((char)'\n').join(Iterables.concat(includeList, this.mGlobalDefinitionsList, this.mFunctionDecls, this.mFunctionBodies));
    }

    private void translatePaths0(ARTElement firstElement, Set<ARTElement> elementsOnPath) {
        ArrayList<Edge> waitlist = new ArrayList<Edge>();
        HashMap<Integer, MergeNode> mergeNodes = new HashMap<Integer, MergeNode>();
        Stack<FunctionBody> newStack = new Stack<FunctionBody>();
        this.startFunction(firstElement, newStack);
        waitlist.addAll(this.getRelevantChildrenOfElement(firstElement, newStack, elementsOnPath));
        while (!waitlist.isEmpty()) {
            Collections.sort(waitlist);
            Edge nextEdge = (Edge)waitlist.remove(0);
            waitlist.addAll(this.handleEdge(nextEdge, mergeNodes, elementsOnPath));
        }
    }

    private String startFunction(ARTElement firstFunctionElement, Stack<FunctionBody> functionStack) {
        FunctionDefinitionNode functionStartNode = (FunctionDefinitionNode)AbstractElements.extractLocation(firstFunctionElement);
        String freshFunctionName = this.getFreshFunctionName(functionStartNode);
        String lFunctionHeader = functionStartNode.getFunctionDefinition().getDeclSpecifier().toASTString(freshFunctionName);
        FunctionBody newFunction = new FunctionBody(firstFunctionElement.getElementId(), lFunctionHeader);
        this.mFunctionDecls.add(lFunctionHeader + ";");
        this.mFunctionBodies.add(newFunction);
        functionStack.push(newFunction);
        return freshFunctionName;
    }

    private void translateSinglePath0(Path pPath) {
        assert (pPath.size() >= 1);
        Iterator pathIt = pPath.iterator();
        Pair parentPair = (Pair)pathIt.next();
        ARTElement firstElement = (ARTElement)parentPair.getFirst();
        Stack<FunctionBody> functionStack = new Stack<FunctionBody>();
        this.startFunction(firstElement, functionStack);
        while (pathIt.hasNext()) {
            Pair nextPair = (Pair)pathIt.next();
            CFAEdge currentCFAEdge = (CFAEdge)parentPair.getSecond();
            ARTElement childElement = (ARTElement)nextPair.getFirst();
            this.processEdge(childElement, currentCFAEdge, functionStack);
            parentPair = nextPair;
        }
    }

    private Collection<Edge> handleEdge(Edge nextEdge, Map<Integer, MergeNode> mergeNodes, Set<ARTElement> elementsOnPath) {
        ARTElement childElement = nextEdge.getChildElement();
        CFAEdge edge = nextEdge.getEdge();
        Stack<FunctionBody> functionStack = nextEdge.getStack();
        functionStack = this.cloneStack(functionStack);
        this.processEdge(childElement, edge, functionStack);
        int noOfParents = Sets.intersection(childElement.getParents(), elementsOnPath).size();
        assert (noOfParents >= 1);
        if (noOfParents > 1) {
            int noOfProcessedBranches;
            assert (!(edge instanceof FunctionCallEdge) && !childElement.isTarget());
            int elemId = childElement.getElementId();
            FunctionBody currentFunction = functionStack.peek();
            currentFunction.write("goto label_" + elemId + ";");
            MergeNode mergeNode = mergeNodes.get(elemId);
            if (mergeNode == null) {
                mergeNode = new MergeNode(elemId);
                mergeNodes.put(elemId, mergeNode);
            }
            if (noOfParents == (noOfProcessedBranches = mergeNode.addBranch(currentFunction))) {
                List<FunctionBody> incomingStacks = mergeNode.getIncomingElements();
                FunctionBody newFunction = PathToCTranslator.processIncomingStacks(incomingStacks);
                functionStack.pop();
                functionStack.push(newFunction);
                newFunction.write("label_" + elemId + ": ;");
            } else {
                return Collections.emptySet();
            }
        }
        return this.getRelevantChildrenOfElement(childElement, functionStack, elementsOnPath);
    }

    private Collection<Edge> getRelevantChildrenOfElement(ARTElement currentElement, Stack<FunctionBody> functionStack, Set<ARTElement> elementsOnPath) {
        ImmutableSet relevantChildrenOfElement = Sets.intersection(currentElement.getChildren(), elementsOnPath).immutableCopy();
        if (relevantChildrenOfElement.size() == 1) {
            ARTElement elem = (ARTElement)Iterables.getOnlyElement((Iterable)relevantChildrenOfElement);
            CFAEdge e = currentElement.getEdgeToChild(elem);
            Edge newEdge = new Edge(elem, e, functionStack);
            return Collections.singleton(newEdge);
        }
        if (relevantChildrenOfElement.size() > 1) {
            assert (relevantChildrenOfElement.size() == 2);
            ArrayList<Edge> result = new ArrayList<Edge>(2);
            int ind = 0;
            for (ARTElement elem : relevantChildrenOfElement) {
                Stack<FunctionBody> newStack = this.cloneStack(functionStack);
                CFAEdge e = currentElement.getEdgeToChild(elem);
                FunctionBody currentFunction = newStack.peek();
                assert (e instanceof AssumeEdge);
                AssumeEdge assumeEdge = (AssumeEdge)e;
                boolean truthAssumption = assumeEdge.getTruthAssumption();
                String cond = "";
                if (ind == 0) {
                    cond = "if ";
                } else if (ind == 1) {
                    cond = "else if ";
                } else assert (false);
                ++ind;
                cond = truthAssumption ? cond + "(" + assumeEdge.getExpression().toASTString() + ")" : cond + "(!(" + assumeEdge.getExpression().toASTString() + "))";
                currentFunction.enterBlock(currentElement.getElementId(), assumeEdge, cond);
                Edge newEdge = new Edge(elem, e, newStack);
                result.add(newEdge);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static FunctionBody processIncomingStacks(List<FunctionBody> pIncomingStacks) {
        FunctionBody maxStack = null;
        int maxSizeOfStack = 0;
        for (FunctionBody stack : pIncomingStacks) {
            while (stack.getCurrentBlock().isClosedBefore()) {
                stack.leaveBlock();
            }
            if (stack.size() <= maxSizeOfStack) continue;
            maxStack = stack;
            maxSizeOfStack = maxStack.size();
        }
        return maxStack;
    }

    private void processEdge(ARTElement childElement, CFAEdge edge, Stack<FunctionBody> functionStack) {
        FunctionBody currentFunction = functionStack.peek();
        if (childElement.isTarget()) {
            currentFunction.write("assert(0); // target state ");
        }
        if (edge instanceof FunctionCallEdge) {
            String freshFunctionName = this.startFunction(childElement, functionStack);
            currentFunction.write(this.processFunctionCall(edge, freshFunctionName));
        } else if (edge instanceof FunctionReturnEdge) {
            functionStack.pop();
        } else {
            currentFunction.write(this.processSimpleEdge(edge));
        }
    }

    private String processSimpleEdge(CFAEdge pCFAEdge) {
        switch (pCFAEdge.getEdgeType()) {
            case BlankEdge: 
            case StatementEdge: 
            case ReturnStatementEdge: {
                return pCFAEdge.getCode();
            }
            case AssumeEdge: {
                AssumeEdge lAssumeEdge = (AssumeEdge)pCFAEdge;
                return "__CPROVER_assume(" + lAssumeEdge.getCode() + ");";
            }
            case DeclarationEdge: {
                DeclarationEdge lDeclarationEdge = (DeclarationEdge)pCFAEdge;
                if (lDeclarationEdge.getDeclaration().isGlobal()) {
                    this.mGlobalDefinitionsList.add(lDeclarationEdge.getCode());
                    return "";
                }
                return lDeclarationEdge.getCode();
            }
            case MultiEdge: {
                StringBuilder sb = new StringBuilder();
                for (CFAEdge edge : (MultiEdge)pCFAEdge) {
                    sb.append(this.processSimpleEdge(edge));
                }
                return sb.toString();
            }
        }
        throw new AssertionError((Object)("Unexpected edge " + pCFAEdge + " of type " + (Object)((Object)pCFAEdge.getEdgeType())));
    }

    private String processFunctionCall(CFAEdge pCFAEdge, String functionName) {
        FunctionCallEdge lFunctionCallEdge = (FunctionCallEdge)pCFAEdge;
        List lArguments = Lists.transform(lFunctionCallEdge.getArguments(), RAW_SIGNATURE_FUNCTION);
        String lArgumentString = "(" + Joiner.on((String)", ").join((Iterable)lArguments) + ")";
        CallToReturnEdge summaryEdge = lFunctionCallEdge.getPredecessor().getLeavingSummaryEdge();
        if (summaryEdge == null) {
            return functionName + lArgumentString + ";";
        }
        IASTFunctionCall expressionOnSummaryEdge = summaryEdge.getExpression();
        if (expressionOnSummaryEdge instanceof IASTFunctionCallAssignmentStatement) {
            IASTFunctionCallAssignmentStatement assignExp = (IASTFunctionCallAssignmentStatement)expressionOnSummaryEdge;
            String assignedVarName = assignExp.getLeftHandSide().toASTString();
            return assignedVarName + " = " + functionName + lArgumentString + ";";
        }
        assert (expressionOnSummaryEdge instanceof IASTFunctionCallStatement);
        return functionName + lArgumentString + ";";
    }

    private String getFreshFunctionName(CFAFunctionDefinitionNode functionStartNode) {
        return functionStartNode.getFunctionName() + "_" + this.mFunctionIndex++;
    }

    private Stack<FunctionBody> cloneStack(Stack<FunctionBody> pStack) {
        Stack<FunctionBody> ret = new Stack<FunctionBody>();
        for (FunctionBody functionBody : pStack) {
            ret.push(new FunctionBody(functionBody));
        }
        return ret;
    }
}

