/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ecp;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.sosy_lab.cpachecker.util.ecp.ECPVisitor;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;

public class ECPConcatenation
implements ElementaryCoveragePattern,
Iterable<ElementaryCoveragePattern> {
    private LinkedList<ElementaryCoveragePattern> mSubpatterns;

    public ECPConcatenation(ElementaryCoveragePattern pFirstSubpattern, ElementaryCoveragePattern pSecondSubpattern) {
        this.mSubpatterns = new LinkedList();
        if (pFirstSubpattern instanceof ECPConcatenation) {
            ECPConcatenation lFirstSubpattern = (ECPConcatenation)pFirstSubpattern;
            this.mSubpatterns.addAll(lFirstSubpattern.mSubpatterns);
        } else {
            this.mSubpatterns.add(pFirstSubpattern);
        }
        if (pSecondSubpattern instanceof ECPConcatenation) {
            ECPConcatenation lSecondSubpattern = (ECPConcatenation)pSecondSubpattern;
            this.mSubpatterns.addAll(lSecondSubpattern.mSubpatterns);
        } else {
            this.mSubpatterns.add(pSecondSubpattern);
        }
    }

    public ECPConcatenation(List<ElementaryCoveragePattern> pSubpatterns) {
        Preconditions.checkNotNull(pSubpatterns);
        Preconditions.checkArgument((pSubpatterns.size() > 0 ? 1 : 0) != 0);
        this.mSubpatterns = new LinkedList();
        for (ElementaryCoveragePattern lSubpattern : pSubpatterns) {
            if (lSubpattern instanceof ECPConcatenation) {
                ECPConcatenation lConcatenation = (ECPConcatenation)lSubpattern;
                this.mSubpatterns.addAll(lConcatenation.mSubpatterns);
                continue;
            }
            this.mSubpatterns.add(lSubpattern);
        }
    }

    @Override
    public Iterator<ElementaryCoveragePattern> iterator() {
        return this.mSubpatterns.iterator();
    }

    public ElementaryCoveragePattern get(int lIndex) {
        return this.mSubpatterns.get(lIndex);
    }

    public int size() {
        return this.mSubpatterns.size();
    }

    public boolean isEmpty() {
        return this.mSubpatterns.isEmpty();
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass().equals(this.getClass())) {
            ECPConcatenation lOther = (ECPConcatenation)pOther;
            return this.mSubpatterns.equals(lOther.mSubpatterns);
        }
        return false;
    }

    public int hashCode() {
        return this.mSubpatterns.hashCode();
    }

    public String toString() {
        StringBuffer lResult = new StringBuffer();
        boolean isFirst = true;
        for (ElementaryCoveragePattern lSubpattern : this.mSubpatterns) {
            if (isFirst) {
                isFirst = false;
            } else {
                lResult.append(".");
            }
            lResult.append(lSubpattern.toString());
        }
        return lResult.toString();
    }

    @Override
    public <T> T accept(ECPVisitor<T> pVisitor) {
        return pVisitor.visit(this);
    }
}

