/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ecp;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.util.ecp.ECPAtom;
import org.sosy_lab.cpachecker.util.ecp.ECPNodeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPVisitor;

public class ECPEdgeSet
implements ECPAtom,
Iterable<CFAEdge> {
    private Set<CFAEdge> mCFAEdges = new HashSet<CFAEdge>();

    public ECPEdgeSet(Collection<CFAEdge> pCFAEdges) {
        this.mCFAEdges.addAll(pCFAEdges);
    }

    public ECPEdgeSet(CFAEdge pCFAEdge) {
        this.mCFAEdges.add(pCFAEdge);
    }

    public boolean contains(CFAEdge pCFAEdge) {
        return this.mCFAEdges.contains(pCFAEdge);
    }

    public ECPEdgeSet(ECPEdgeSet pEdgeSet) {
        this(pEdgeSet.mCFAEdges);
    }

    public ECPEdgeSet startIn(ECPNodeSet pNodeSet) {
        HashSet<CFAEdge> lResult = new HashSet<CFAEdge>();
        for (CFAEdge lEdge : this.mCFAEdges) {
            if (!pNodeSet.contains(lEdge.getPredecessor())) continue;
            lResult.add(lEdge);
        }
        return new ECPEdgeSet(lResult);
    }

    public ECPEdgeSet endIn(ECPNodeSet pNodeSet) {
        HashSet<CFAEdge> lResult = new HashSet<CFAEdge>();
        for (CFAEdge lEdge : this.mCFAEdges) {
            if (!pNodeSet.contains(lEdge.getSuccessor())) continue;
            lResult.add(lEdge);
        }
        return new ECPEdgeSet(lResult);
    }

    public ECPEdgeSet intersect(ECPEdgeSet pOther) {
        HashSet<CFAEdge> lIntersection = new HashSet<CFAEdge>();
        lIntersection.addAll(this.mCFAEdges);
        lIntersection.retainAll(pOther.mCFAEdges);
        return new ECPEdgeSet(lIntersection);
    }

    public ECPEdgeSet union(ECPEdgeSet pOther) {
        HashSet<CFAEdge> lUnion = new HashSet<CFAEdge>();
        lUnion.addAll(this.mCFAEdges);
        lUnion.addAll(pOther.mCFAEdges);
        return new ECPEdgeSet(lUnion);
    }

    public int hashCode() {
        return ((Object)this.mCFAEdges).hashCode();
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass().equals(this.getClass())) {
            ECPEdgeSet lOther = (ECPEdgeSet)pOther;
            return ((Object)this.mCFAEdges).equals(lOther.mCFAEdges);
        }
        return false;
    }

    public int size() {
        return this.mCFAEdges.size();
    }

    public boolean isEmpty() {
        return this.mCFAEdges.isEmpty();
    }

    public String toString() {
        return this.mCFAEdges.toString();
    }

    @Override
    public Iterator<CFAEdge> iterator() {
        return this.mCFAEdges.iterator();
    }

    @Override
    public <T> T accept(ECPVisitor<T> pVisitor) {
        return pVisitor.visit(this);
    }
}

