/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ecp;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.util.ecp.ECPGuard;
import org.sosy_lab.cpachecker.util.ecp.ECPVisitor;

public class ECPNodeSet
implements ECPGuard,
Iterable<CFANode> {
    public static final ECPNodeSet EMPTY_NODE_SET = new ECPNodeSet();
    private Set<CFANode> mCFANodes;

    private ECPNodeSet() {
        this.mCFANodes = Collections.emptySet();
    }

    public ECPNodeSet(Set<CFANode> pCFANodes) {
        this.mCFANodes = new HashSet<CFANode>();
        this.mCFANodes.addAll(pCFANodes);
    }

    public ECPNodeSet(CFANode pCFANode) {
        this.mCFANodes = new HashSet<CFANode>();
        this.mCFANodes.add(pCFANode);
    }

    public ECPNodeSet(ECPNodeSet pNodeSet) {
        this(pNodeSet.mCFANodes);
    }

    public ECPNodeSet intersect(ECPNodeSet pOther) {
        HashSet<CFANode> lIntersection = new HashSet<CFANode>();
        lIntersection.addAll(this.mCFANodes);
        lIntersection.retainAll(pOther.mCFANodes);
        return new ECPNodeSet(lIntersection);
    }

    public ECPNodeSet union(ECPNodeSet pOther) {
        HashSet<CFANode> lUnion = new HashSet<CFANode>();
        lUnion.addAll(this.mCFANodes);
        lUnion.addAll(pOther.mCFANodes);
        return new ECPNodeSet(lUnion);
    }

    public int hashCode() {
        return ((Object)this.mCFANodes).hashCode();
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass().equals(this.getClass())) {
            ECPNodeSet lECPNodeSet = (ECPNodeSet)pOther;
            return ((Object)this.mCFANodes).equals(lECPNodeSet.mCFANodes);
        }
        return false;
    }

    public int size() {
        return this.mCFANodes.size();
    }

    public boolean isEmpty() {
        return this.mCFANodes.isEmpty();
    }

    public boolean contains(CFANode pNode) {
        return this.mCFANodes.contains(pNode);
    }

    public String toString() {
        return this.mCFANodes.toString();
    }

    @Override
    public Iterator<CFANode> iterator() {
        return this.mCFANodes.iterator();
    }

    @Override
    public <T> T accept(ECPVisitor<T> pVisitor) {
        return pVisitor.visit(this);
    }
}

