/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ecp;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.util.ecp.ECPAtom;
import org.sosy_lab.cpachecker.util.ecp.ECPConcatenation;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPNodeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPPredicate;
import org.sosy_lab.cpachecker.util.ecp.ECPRepetition;
import org.sosy_lab.cpachecker.util.ecp.ECPUnion;
import org.sosy_lab.cpachecker.util.ecp.ECPVisitor;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;

public class ECPPrettyPrinter {
    private Visitor mVisitor = new Visitor();

    public String printPretty(ElementaryCoveragePattern pPattern) {
        String lPatternString = pPattern.accept(this.mVisitor);
        StringBuffer lResult = new StringBuffer();
        for (Map.Entry lEntry : this.mVisitor.mEdgeSetIds.entrySet()) {
            lResult.append("E" + lEntry.getValue() + ": " + ((ECPEdgeSet)lEntry.getKey()).toString());
            lResult.append("\n");
        }
        for (Map.Entry lEntry : this.mVisitor.mNodeSetIds.entrySet()) {
            lResult.append("N" + lEntry.getValue() + ": " + ((ECPNodeSet)lEntry.getKey()).toString());
            lResult.append("\n");
        }
        lResult.append(lPatternString);
        return lResult.toString();
    }

    private static class Visitor
    implements ECPVisitor<String> {
        private Map<ECPEdgeSet, Integer> mEdgeSetIds = new HashMap<ECPEdgeSet, Integer>();
        private Map<ECPNodeSet, Integer> mNodeSetIds = new HashMap<ECPNodeSet, Integer>();

        private int getEdgeSetId(ECPEdgeSet pEdgeSet) {
            if (this.mEdgeSetIds.containsKey(pEdgeSet)) {
                return this.mEdgeSetIds.get(pEdgeSet);
            }
            int lId = this.mEdgeSetIds.size();
            this.mEdgeSetIds.put(pEdgeSet, lId);
            return lId;
        }

        private int getNodeSetId(ECPNodeSet pNodeSet) {
            if (this.mNodeSetIds.containsKey(pNodeSet)) {
                return this.mNodeSetIds.get(pNodeSet);
            }
            int lId = this.mNodeSetIds.size();
            this.mNodeSetIds.put(pNodeSet, lId);
            return lId;
        }

        @Override
        public String visit(ECPEdgeSet pEdgeSet) {
            return "E" + this.getEdgeSetId(pEdgeSet);
        }

        @Override
        public String visit(ECPNodeSet pNodeSet) {
            return "N" + this.getNodeSetId(pNodeSet);
        }

        @Override
        public String visit(ECPPredicate pPredicate) {
            return "{ " + pPredicate.toString() + " }";
        }

        @Override
        public String visit(ECPConcatenation pConcatenation) {
            StringBuffer lResult = new StringBuffer();
            boolean isFirst = true;
            for (ElementaryCoveragePattern lSubpattern : pConcatenation) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    lResult.append(".");
                }
                if (lSubpattern instanceof ECPUnion) {
                    lResult.append("(");
                }
                lResult.append(lSubpattern.accept(this));
                if (!(lSubpattern instanceof ECPUnion)) continue;
                lResult.append(")");
            }
            return lResult.toString();
        }

        @Override
        public String visit(ECPUnion pUnion) {
            StringBuffer lResult = new StringBuffer();
            boolean isFirst = true;
            for (ElementaryCoveragePattern lSubpattern : pUnion) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    lResult.append(" + ");
                }
                if (lSubpattern instanceof ECPConcatenation) {
                    lResult.append("(");
                }
                lResult.append(lSubpattern.accept(this));
                if (!(lSubpattern instanceof ECPConcatenation)) continue;
                lResult.append(")");
            }
            return lResult.toString();
        }

        @Override
        public String visit(ECPRepetition pRepetition) {
            if (pRepetition.getSubpattern() instanceof ECPAtom) {
                return pRepetition.getSubpattern().accept(this) + "*";
            }
            return "(" + pRepetition.getSubpattern().accept(this) + ")*";
        }
    }
}

