/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ecp;

import java.util.Iterator;
import java.util.LinkedList;
import org.sosy_lab.cpachecker.util.ecp.ECPVisitor;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;

public class ECPUnion
implements ElementaryCoveragePattern,
Iterable<ElementaryCoveragePattern> {
    private LinkedList<ElementaryCoveragePattern> mSubpatterns = new LinkedList();

    public ECPUnion(ElementaryCoveragePattern pFirstSubpattern, ElementaryCoveragePattern pSecondSubpattern) {
        if (pFirstSubpattern instanceof ECPUnion) {
            ECPUnion lFirstSubpattern = (ECPUnion)pFirstSubpattern;
            this.mSubpatterns.addAll(lFirstSubpattern.mSubpatterns);
        } else {
            this.mSubpatterns.add(pFirstSubpattern);
        }
        if (pSecondSubpattern instanceof ECPUnion) {
            ECPUnion lSecondSubpattern = (ECPUnion)pSecondSubpattern;
            this.mSubpatterns.addAll(lSecondSubpattern.mSubpatterns);
        } else {
            this.mSubpatterns.add(pSecondSubpattern);
        }
    }

    @Override
    public Iterator<ElementaryCoveragePattern> iterator() {
        return this.mSubpatterns.iterator();
    }

    public int size() {
        return this.mSubpatterns.size();
    }

    public boolean isEmpty() {
        return this.mSubpatterns.isEmpty();
    }

    public ElementaryCoveragePattern get(int lIndex) {
        return this.mSubpatterns.get(lIndex);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass().equals(this.getClass())) {
            ECPUnion lOther = (ECPUnion)pOther;
            return this.mSubpatterns.equals(lOther.mSubpatterns);
        }
        return false;
    }

    public int hashCode() {
        return this.mSubpatterns.hashCode();
    }

    public String toString() {
        StringBuffer lResult = new StringBuffer();
        boolean isFirst = true;
        for (ElementaryCoveragePattern lSubpattern : this.mSubpatterns) {
            if (isFirst) {
                isFirst = false;
            } else {
                lResult.append(" + ");
            }
            lResult.append(lSubpattern.toString());
        }
        return lResult.toString();
    }

    @Override
    public <T> T accept(ECPVisitor<T> pVisitor) {
        return pVisitor.visit(this);
    }
}

