/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ecp.translators;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPGuard;
import org.sosy_lab.cpachecker.util.ecp.ECPNodeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPPredicate;
import org.sosy_lab.cpachecker.util.ecp.translators.AllCFAEdgesGuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedLabelVisitor;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedLambdaLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.InverseGuardedEdgeLabel;

public class AutomatonPrettyPrinter {
    private Map<NondeterministicFiniteAutomaton.State, String> mStateIds = new HashMap<NondeterministicFiniteAutomaton.State, String>();
    private Map<ECPEdgeSet, String> mEdgeSetIds = new HashMap<ECPEdgeSet, String>();
    private Map<ECPNodeSet, String> mNodeSetIds = new HashMap<ECPNodeSet, String>();
    private Visitor mVisitor = new Visitor();

    public static String print(NondeterministicFiniteAutomaton<? extends GuardedLabel> pAutomaton) {
        AutomatonPrettyPrinter lPrettyPrinter = new AutomatonPrettyPrinter();
        return lPrettyPrinter.printPretty(pAutomaton);
    }

    private String getId(NondeterministicFiniteAutomaton.State pState) {
        if (!this.mStateIds.containsKey(pState)) {
            this.mStateIds.put(pState, "S" + this.mStateIds.size());
        }
        return this.mStateIds.get(pState);
    }

    private String getId(ECPEdgeSet pEdgeSet) {
        if (!this.mEdgeSetIds.containsKey(pEdgeSet)) {
            this.mEdgeSetIds.put(pEdgeSet, "E" + this.mEdgeSetIds.size());
        }
        return this.mEdgeSetIds.get(pEdgeSet);
    }

    private String getId(ECPNodeSet pNodeSet) {
        if (!this.mNodeSetIds.containsKey(pNodeSet)) {
            this.mNodeSetIds.put(pNodeSet, "N" + this.mNodeSetIds.size());
        }
        return this.mNodeSetIds.get(pNodeSet);
    }

    public String printPretty(NondeterministicFiniteAutomaton.Edge pEdge) {
        return this.printPretty(pEdge.getSource()) + " -[" + ((GuardedLabel)pEdge.getLabel()).accept(this.mVisitor) + "]> " + this.printPretty(pEdge.getTarget());
    }

    public String printPretty(NondeterministicFiniteAutomaton.State pState) {
        return this.getId(pState);
    }

    public String printPretty(NondeterministicFiniteAutomaton<? extends GuardedLabel> pAutomaton) {
        StringBuffer lBuffer = new StringBuffer();
        boolean lIsFirst = true;
        lBuffer.append("States: {");
        for (NondeterministicFiniteAutomaton.State lState : pAutomaton.getStates()) {
            if (lIsFirst) {
                lIsFirst = false;
            } else {
                lBuffer.append(", ");
            }
            lBuffer.append(this.getId(lState));
        }
        lBuffer.append("}\n");
        lBuffer.append("Initial State: ");
        lBuffer.append(this.getId(pAutomaton.getInitialState()));
        lBuffer.append("\n");
        lBuffer.append("Final States: {");
        lIsFirst = true;
        for (NondeterministicFiniteAutomaton.State lFinalState : pAutomaton.getFinalStates()) {
            if (lIsFirst) {
                lIsFirst = false;
            } else {
                lBuffer.append(", ");
            }
            lBuffer.append(this.getId(lFinalState));
        }
        lBuffer.append("}\n");
        StringBuffer lTmpBuffer = new StringBuffer();
        for (NondeterministicFiniteAutomaton.Edge edge : pAutomaton.getEdges()) {
            lTmpBuffer.append(this.printPretty(edge));
            lTmpBuffer.append("\n");
        }
        for (Map.Entry entry : this.mNodeSetIds.entrySet()) {
            lBuffer.append((String)entry.getValue() + ": " + ((ECPNodeSet)entry.getKey()).toString());
            lBuffer.append("\n");
        }
        for (Map.Entry entry : this.mEdgeSetIds.entrySet()) {
            lBuffer.append((String)entry.getValue() + ": " + ((ECPEdgeSet)entry.getKey()).toString());
            lBuffer.append("\n");
        }
        lBuffer.append(lTmpBuffer);
        return lBuffer.toString();
    }

    private class Visitor
    implements GuardedLabelVisitor<String> {
        private Visitor() {
        }

        @Override
        public String visit(GuardedLambdaLabel pLabel) {
            if (pLabel.hasGuards()) {
                StringBuffer lGuardBuffer = new StringBuffer();
                lGuardBuffer.append("[");
                boolean lIsFirst = true;
                for (ECPGuard lGuard : pLabel.getGuards()) {
                    if (lIsFirst) {
                        lIsFirst = false;
                    } else {
                        lGuardBuffer.append(", ");
                    }
                    if (lGuard instanceof ECPPredicate) {
                        lGuardBuffer.append(lGuard.toString());
                        continue;
                    }
                    assert (lGuard instanceof ECPNodeSet);
                    ECPNodeSet lNodeSet = (ECPNodeSet)lGuard;
                    lGuardBuffer.append(AutomatonPrettyPrinter.this.getId(lNodeSet));
                }
                lGuardBuffer.append("]");
                return "Lambda " + lGuardBuffer.toString();
            }
            return "Lambda";
        }

        @Override
        public String visit(GuardedEdgeLabel pLabel) {
            if (pLabel instanceof InverseGuardedEdgeLabel) {
                return this.visitInverseGuardedEdgeLabel((InverseGuardedEdgeLabel)pLabel);
            }
            if (pLabel instanceof AllCFAEdgesGuardedEdgeLabel) {
                return "TRUE";
            }
            if (pLabel.hasGuards()) {
                StringBuffer lGuardBuffer = new StringBuffer();
                lGuardBuffer.append("[");
                boolean lIsFirst = true;
                for (ECPGuard lGuard : pLabel.getGuards()) {
                    if (lIsFirst) {
                        lIsFirst = false;
                    } else {
                        lGuardBuffer.append(", ");
                    }
                    if (lGuard instanceof ECPPredicate) {
                        lGuardBuffer.append(lGuard.toString());
                        continue;
                    }
                    assert (lGuard instanceof ECPNodeSet);
                    ECPNodeSet lNodeSet = (ECPNodeSet)lGuard;
                    lGuardBuffer.append(AutomatonPrettyPrinter.this.getId(lNodeSet));
                }
                lGuardBuffer.append("]");
                return AutomatonPrettyPrinter.this.getId(pLabel.getEdgeSet()) + " " + lGuardBuffer.toString();
            }
            return AutomatonPrettyPrinter.this.getId(pLabel.getEdgeSet());
        }

        private String visitInverseGuardedEdgeLabel(InverseGuardedEdgeLabel pLabel) {
            return "!" + pLabel.getInvertedLabel().accept(this);
        }
    }
}

