/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ecp.translators;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPGuard;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedLabelVisitor;

public class GuardedEdgeLabel
extends GuardedLabel {
    private static Map<ECPEdgeSet, Integer> mIds = new HashMap<ECPEdgeSet, Integer>();
    private final ECPEdgeSet mEdgeSet;

    public GuardedEdgeLabel(ECPEdgeSet pEdgeSet) {
        this.mEdgeSet = pEdgeSet;
    }

    public GuardedEdgeLabel(ECPEdgeSet pEdgeSet, ECPGuard pGuard) {
        super(pGuard);
        this.mEdgeSet = pEdgeSet;
    }

    public GuardedEdgeLabel(ECPEdgeSet pEdgeSet, Set<ECPGuard> pGuards) {
        super(pGuards);
        this.mEdgeSet = pEdgeSet;
    }

    public GuardedEdgeLabel(GuardedEdgeLabel pGuard) {
        this(pGuard.mEdgeSet, pGuard.getGuards());
    }

    public ECPEdgeSet getEdgeSet() {
        return this.mEdgeSet;
    }

    public boolean contains(CFAEdge pCFAEdge) {
        return this.mEdgeSet.contains(pCFAEdge);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass().equals(this.getClass())) {
            GuardedEdgeLabel lLabel = (GuardedEdgeLabel)pOther;
            return ((Object)this.getGuards()).equals(lLabel.getGuards()) && this.mEdgeSet.equals(lLabel.mEdgeSet);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.getGuards()).hashCode() + this.mEdgeSet.hashCode() + 234209;
    }

    @Override
    public <T> T accept(GuardedLabelVisitor<T> pVisitor) {
        return pVisitor.visit(this);
    }

    public String toString() {
        if (!mIds.containsKey(this.mEdgeSet)) {
            mIds.put(this.mEdgeSet, mIds.size());
        }
        String lIdString = null;
        lIdString = this.mEdgeSet.size() == 1 ? this.mEdgeSet.toString() : "E" + mIds.get(this.mEdgeSet);
        return lIdString + " " + this.getGuards().toString();
    }
}

