/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ecp.translators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.ECPAtom;
import org.sosy_lab.cpachecker.util.ecp.ECPConcatenation;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPGuard;
import org.sosy_lab.cpachecker.util.ecp.ECPNodeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPPredicate;
import org.sosy_lab.cpachecker.util.ecp.ECPRepetition;
import org.sosy_lab.cpachecker.util.ecp.ECPUnion;
import org.sosy_lab.cpachecker.util.ecp.ECPVisitor;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedLambdaLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedState;
import org.sosy_lab.cpachecker.util.ecp.translators.InverseGuardedEdgeLabel;

public class ToGuardedAutomatonTranslator {
    public static NondeterministicFiniteAutomaton<GuardedEdgeLabel> toAutomaton(ElementaryCoveragePattern pPattern, GuardedEdgeLabel pAlphaLabel, GuardedEdgeLabel pInverseAlphaLabel, GuardedEdgeLabel pOmegaLabel) {
        NondeterministicFiniteAutomaton<GuardedLabel> lAutomaton1 = ToGuardedAutomatonTranslator.translate(pPattern);
        NondeterministicFiniteAutomaton<GuardedLabel> lAutomaton2 = ToGuardedAutomatonTranslator.removeLambdaEdges(lAutomaton1, pAlphaLabel, pOmegaLabel);
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lAutomaton3 = ToGuardedAutomatonTranslator.removeNodeSetGuards(lAutomaton2);
        lAutomaton3.createEdge(lAutomaton3.getInitialState(), lAutomaton3.getInitialState(), pInverseAlphaLabel);
        return lAutomaton3;
    }

    public static NondeterministicFiniteAutomaton<GuardedLabel> translate(ElementaryCoveragePattern pPattern) {
        Visitor lVisitor = new Visitor();
        pPattern.accept(lVisitor);
        lVisitor.getAutomaton().addToFinalStates(lVisitor.getFinalState());
        return lVisitor.getAutomaton();
    }

    public static NondeterministicFiniteAutomaton<GuardedLabel> removeLambdaEdges(NondeterministicFiniteAutomaton<GuardedLabel> pAutomaton, GuardedEdgeLabel pAlphaLabel, GuardedEdgeLabel pOmegaLabel) {
        NondeterministicFiniteAutomaton.State lNewInitialState = pAutomaton.createState();
        NondeterministicFiniteAutomaton.Edge lInitialEdge = pAutomaton.createEdge(lNewInitialState, pAutomaton.getInitialState(), pAlphaLabel);
        pAutomaton.setInitialState(lNewInitialState);
        NondeterministicFiniteAutomaton.State lNewFinalState = pAutomaton.createState();
        for (NondeterministicFiniteAutomaton.State lFinalState : pAutomaton.getFinalStates()) {
            pAutomaton.createEdge(lFinalState, lNewFinalState, pOmegaLabel);
        }
        pAutomaton.setFinalStates(Collections.singleton(lNewFinalState));
        NondeterministicFiniteAutomaton<GuardedLabel> lAutomaton = new NondeterministicFiniteAutomaton<GuardedLabel>();
        HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State> lStateMap = new HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State>();
        lStateMap.put(lNewInitialState, lAutomaton.getInitialState());
        LinkedList<NondeterministicFiniteAutomaton.Edge> lWorklist = new LinkedList<NondeterministicFiniteAutomaton.Edge>();
        lWorklist.add(lInitialEdge);
        HashSet<NondeterministicFiniteAutomaton.Edge> lReachedEdges = new HashSet<NondeterministicFiniteAutomaton.Edge>();
        while (!lWorklist.isEmpty()) {
            NondeterministicFiniteAutomaton.Edge lCurrentEdge = (NondeterministicFiniteAutomaton.Edge)lWorklist.remove(0);
            if (lReachedEdges.contains(lCurrentEdge)) continue;
            lReachedEdges.add(lCurrentEdge);
            GuardedState lInitialGuardedState = new GuardedState(lCurrentEdge.getTarget(), ((GuardedLabel)lCurrentEdge.getLabel()).getGuards());
            LinkedList<GuardedState> lStatesWorklist = new LinkedList<GuardedState>();
            lStatesWorklist.add(lInitialGuardedState);
            HashSet<GuardedState> lReachedStates = new HashSet<GuardedState>();
            while (!lStatesWorklist.isEmpty()) {
                GuardedState lCurrentState = (GuardedState)lStatesWorklist.remove(0);
                boolean lIsCovered = false;
                for (GuardedState lGuardedState : lReachedStates) {
                    if (!lGuardedState.covers(lCurrentState)) continue;
                    lIsCovered = true;
                    break;
                }
                if (lIsCovered) continue;
                lReachedStates.add(lCurrentState);
                for (NondeterministicFiniteAutomaton.Edge lOutgoingEdge : pAutomaton.getOutgoingEdges(lCurrentState.getState())) {
                    if (!(lOutgoingEdge.getLabel() instanceof GuardedLambdaLabel)) continue;
                    GuardedState lNewState = new GuardedState(lOutgoingEdge.getTarget(), lCurrentState, ((GuardedLabel)lOutgoingEdge.getLabel()).getGuards());
                    lStatesWorklist.add(lNewState);
                }
            }
            NondeterministicFiniteAutomaton.State lOldSource = lCurrentEdge.getSource();
            if (!lStateMap.containsKey(lOldSource)) {
                lStateMap.put(lOldSource, lAutomaton.createState());
            }
            NondeterministicFiniteAutomaton.State lSource = (NondeterministicFiniteAutomaton.State)lStateMap.get(lOldSource);
            GuardedLabel lCurrentLabel = (GuardedLabel)lCurrentEdge.getLabel();
            GuardedEdgeLabel lEdgeLabel = (GuardedEdgeLabel)lCurrentLabel;
            ECPEdgeSet lCurrentEdgeSet = lEdgeLabel.getEdgeSet();
            for (GuardedState lReachedState : lReachedStates) {
                boolean lHasNonLambdaEdge = false;
                for (NondeterministicFiniteAutomaton.Edge lOutgoingEdge : pAutomaton.getOutgoingEdges(lReachedState.getState())) {
                    if (lOutgoingEdge.getLabel() instanceof GuardedLambdaLabel) continue;
                    lHasNonLambdaEdge = true;
                    lWorklist.add(lOutgoingEdge);
                }
                if (pAutomaton.getOutgoingEdges(lReachedState.getState()).isEmpty()) {
                    lHasNonLambdaEdge = true;
                }
                if (!lHasNonLambdaEdge) continue;
                NondeterministicFiniteAutomaton.State lOldTarget = lReachedState.getState();
                if (!lStateMap.containsKey(lOldTarget)) {
                    lStateMap.put(lOldTarget, lAutomaton.createState());
                }
                NondeterministicFiniteAutomaton.State lTarget = (NondeterministicFiniteAutomaton.State)lStateMap.get(lOldTarget);
                lAutomaton.createEdge(lSource, lTarget, new GuardedEdgeLabel(lCurrentEdgeSet, lReachedState.getGuards()));
            }
        }
        for (NondeterministicFiniteAutomaton.State lFinalState : pAutomaton.getFinalStates()) {
            lAutomaton.addToFinalStates((NondeterministicFiniteAutomaton.State)lStateMap.get(lFinalState));
        }
        return lAutomaton;
    }

    public static NondeterministicFiniteAutomaton<GuardedEdgeLabel> removeNodeSetGuards(NondeterministicFiniteAutomaton<GuardedLabel> pAutomaton) {
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lAutomaton = new NondeterministicFiniteAutomaton<GuardedEdgeLabel>();
        HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State> lStateMap = new HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State>();
        lStateMap.put(pAutomaton.getInitialState(), lAutomaton.getInitialState());
        LinkedList<NondeterministicFiniteAutomaton.Edge> lWorklist = new LinkedList<NondeterministicFiniteAutomaton.Edge>();
        lWorklist.addAll(pAutomaton.getOutgoingEdges(pAutomaton.getInitialState()));
        HashSet<NondeterministicFiniteAutomaton.Edge> lReachedEdges = new HashSet<NondeterministicFiniteAutomaton.Edge>();
        while (!lWorklist.isEmpty()) {
            NondeterministicFiniteAutomaton.Edge lCurrentEdge = (NondeterministicFiniteAutomaton.Edge)lWorklist.remove(0);
            if (lReachedEdges.contains(lCurrentEdge)) continue;
            lReachedEdges.add(lCurrentEdge);
            GuardedLabel lLabel = (GuardedLabel)lCurrentEdge.getLabel();
            if (lLabel.hasGuards()) {
                GuardedEdgeLabel lEdgeLabel;
                ECPNodeSet lNodeSet = null;
                HashSet<ECPGuard> lRemainingGuards = new HashSet<ECPGuard>();
                for (ECPGuard lGuard : lLabel.getGuards()) {
                    if (lGuard instanceof ECPNodeSet) {
                        if (lNodeSet == null) {
                            lNodeSet = (ECPNodeSet)lGuard;
                            continue;
                        }
                        lNodeSet = lNodeSet.intersect((ECPNodeSet)lGuard);
                        continue;
                    }
                    lRemainingGuards.add(lGuard);
                }
                if (lNodeSet != null) {
                    if (!lNodeSet.isEmpty()) {
                        assert (lLabel instanceof GuardedEdgeLabel);
                        lEdgeLabel = (GuardedEdgeLabel)lLabel;
                        ECPEdgeSet lCurrentEdgeSet = lEdgeLabel.getEdgeSet();
                        HashSet<CFAEdge> lRemainingCFAEdges = new HashSet<CFAEdge>();
                        for (CFAEdge lCFAEdge : lCurrentEdgeSet) {
                            if (!lNodeSet.contains(lCFAEdge.getSuccessor())) continue;
                            lRemainingCFAEdges.add(lCFAEdge);
                        }
                        if (!lRemainingCFAEdges.isEmpty()) {
                            ECPEdgeSet lNewEdgeSet = new ECPEdgeSet(lRemainingCFAEdges);
                            GuardedEdgeLabel lNewGuard = new GuardedEdgeLabel(lNewEdgeSet, lRemainingGuards);
                            NondeterministicFiniteAutomaton.State lCurrentSource = lCurrentEdge.getSource();
                            NondeterministicFiniteAutomaton.State lCurrentTarget = lCurrentEdge.getTarget();
                            if (!lStateMap.containsKey(lCurrentSource)) {
                                lStateMap.put(lCurrentSource, lAutomaton.createState());
                            }
                            if (!lStateMap.containsKey(lCurrentTarget)) {
                                lStateMap.put(lCurrentTarget, lAutomaton.createState());
                            }
                            NondeterministicFiniteAutomaton.State lSourceState = (NondeterministicFiniteAutomaton.State)lStateMap.get(lCurrentSource);
                            NondeterministicFiniteAutomaton.State lTargetState = (NondeterministicFiniteAutomaton.State)lStateMap.get(lCurrentTarget);
                            lAutomaton.createEdge(lSourceState, lTargetState, lNewGuard);
                        }
                    }
                } else {
                    assert (lLabel instanceof GuardedEdgeLabel);
                    lEdgeLabel = (GuardedEdgeLabel)lLabel;
                    if (!lEdgeLabel.getEdgeSet().isEmpty()) {
                        NondeterministicFiniteAutomaton.State lCurrentSource = lCurrentEdge.getSource();
                        NondeterministicFiniteAutomaton.State lCurrentTarget = lCurrentEdge.getTarget();
                        if (!lStateMap.containsKey(lCurrentSource)) {
                            lStateMap.put(lCurrentSource, lAutomaton.createState());
                        }
                        if (!lStateMap.containsKey(lCurrentTarget)) {
                            lStateMap.put(lCurrentTarget, lAutomaton.createState());
                        }
                        NondeterministicFiniteAutomaton.State lSourceState = (NondeterministicFiniteAutomaton.State)lStateMap.get(lCurrentSource);
                        NondeterministicFiniteAutomaton.State lTargetState = (NondeterministicFiniteAutomaton.State)lStateMap.get(lCurrentTarget);
                        lAutomaton.createEdge(lSourceState, lTargetState, lEdgeLabel);
                    }
                }
            } else {
                assert (lLabel instanceof GuardedEdgeLabel);
                GuardedEdgeLabel lEdgeLabel = (GuardedEdgeLabel)lLabel;
                if (!lEdgeLabel.getEdgeSet().isEmpty()) {
                    NondeterministicFiniteAutomaton.State lCurrentSource = lCurrentEdge.getSource();
                    NondeterministicFiniteAutomaton.State lCurrentTarget = lCurrentEdge.getTarget();
                    if (!lStateMap.containsKey(lCurrentSource)) {
                        lStateMap.put(lCurrentSource, lAutomaton.createState());
                    }
                    if (!lStateMap.containsKey(lCurrentTarget)) {
                        lStateMap.put(lCurrentTarget, lAutomaton.createState());
                    }
                    NondeterministicFiniteAutomaton.State lSourceState = (NondeterministicFiniteAutomaton.State)lStateMap.get(lCurrentSource);
                    NondeterministicFiniteAutomaton.State lTargetState = (NondeterministicFiniteAutomaton.State)lStateMap.get(lCurrentTarget);
                    lAutomaton.createEdge(lSourceState, lTargetState, lEdgeLabel);
                }
            }
            lWorklist.addAll(pAutomaton.getOutgoingEdges(lCurrentEdge.getTarget()));
        }
        for (NondeterministicFiniteAutomaton.State lFinalState : pAutomaton.getFinalStates()) {
            if (!lStateMap.containsKey(lFinalState)) continue;
            lAutomaton.addToFinalStates((NondeterministicFiniteAutomaton.State)lStateMap.get(lFinalState));
        }
        return lAutomaton;
    }

    public static NondeterministicFiniteAutomaton<GuardedEdgeLabel> removeDeadEnds(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pAutomaton) {
        HashSet<NondeterministicFiniteAutomaton.State> lClosure = new HashSet<NondeterministicFiniteAutomaton.State>();
        for (NondeterministicFiniteAutomaton.State lFinalState : pAutomaton.getFinalStates()) {
            LinkedList<NondeterministicFiniteAutomaton.State> lWorklist = new LinkedList<NondeterministicFiniteAutomaton.State>();
            lWorklist.add(lFinalState);
            lClosure.add(lFinalState);
            while (!lWorklist.isEmpty()) {
                NondeterministicFiniteAutomaton.State lCurrentState = (NondeterministicFiniteAutomaton.State)lWorklist.removeFirst();
                for (NondeterministicFiniteAutomaton.Edge lIncomingTransition : pAutomaton.getIncomingEdges(lCurrentState)) {
                    NondeterministicFiniteAutomaton.State lSource = lIncomingTransition.getSource();
                    if (lClosure.contains(lSource)) continue;
                    lWorklist.add(lSource);
                    lClosure.add(lSource);
                }
            }
        }
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lNewAutomaton = new NondeterministicFiniteAutomaton<GuardedEdgeLabel>();
        if (lClosure.contains(pAutomaton.getInitialState())) {
            HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State> lStateMap = new HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State>();
            lStateMap.put(pAutomaton.getInitialState(), lNewAutomaton.getInitialState());
            for (NondeterministicFiniteAutomaton.State lState : pAutomaton.getStates()) {
                if (lState.equals(pAutomaton.getInitialState())) continue;
                lStateMap.put(lState, lNewAutomaton.createState());
            }
            for (NondeterministicFiniteAutomaton.Edge lTransition : pAutomaton.getEdges()) {
                if (!lClosure.contains(lTransition.getTarget())) continue;
                lNewAutomaton.createEdge((NondeterministicFiniteAutomaton.State)lStateMap.get(lTransition.getSource()), (NondeterministicFiniteAutomaton.State)lStateMap.get(lTransition.getTarget()), (GuardedEdgeLabel)lTransition.getLabel());
            }
            for (NondeterministicFiniteAutomaton.State lFinalState : pAutomaton.getFinalStates()) {
                if (!lClosure.contains(lFinalState)) continue;
                lNewAutomaton.addToFinalStates((NondeterministicFiniteAutomaton.State)lStateMap.get(lFinalState));
            }
        }
        return lNewAutomaton;
    }

    public static NondeterministicFiniteAutomaton<GuardedEdgeLabel> reduceEdgeSets(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pAutomaton) {
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lNewAutomaton = new NondeterministicFiniteAutomaton<GuardedEdgeLabel>();
        HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State> lStateMap = new HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State>();
        lStateMap.put(pAutomaton.getInitialState(), lNewAutomaton.getInitialState());
        for (NondeterministicFiniteAutomaton.State lState : pAutomaton.getStates()) {
            if (lState.equals(pAutomaton.getInitialState())) continue;
            lStateMap.put(lState, lNewAutomaton.createState());
        }
        for (NondeterministicFiniteAutomaton.State lState : pAutomaton.getStates()) {
            NondeterministicFiniteAutomaton.Edge lOutgoingEdge;
            GuardedEdgeLabel lLabel;
            ECPEdgeSet lEdgeSet;
            boolean lMatch = false;
            if (!pAutomaton.isFinalState(lState) && !pAutomaton.getInitialState().equals(lState) && pAutomaton.getOutgoingEdges(lState).size() == 1 && (lEdgeSet = (lLabel = (GuardedEdgeLabel)(lOutgoingEdge = pAutomaton.getOutgoingEdges(lState).iterator().next()).getLabel()).getEdgeSet()).size() == 1) {
                CFAEdge lOutgoingCFAEdge = lEdgeSet.iterator().next();
                if (pAutomaton.getIncomingEdges(lState).size() == 1) {
                    NondeterministicFiniteAutomaton.Edge lIncomingEdge = pAutomaton.getIncomingEdges(lState).iterator().next();
                    ECPEdgeSet lIncomingEdgeSet = ((GuardedEdgeLabel)lIncomingEdge.getLabel()).getEdgeSet();
                    CFANode lPredecessor = lOutgoingCFAEdge.getPredecessor();
                    ArrayList<CFAEdge> lIncomingCFAEdges = new ArrayList<CFAEdge>(lPredecessor.getNumEnteringEdges());
                    for (int lIndex = 0; lIndex < lPredecessor.getNumEnteringEdges(); ++lIndex) {
                        CFAEdge lIncomingCFAEdge = lPredecessor.getEnteringEdge(lIndex);
                        if (!lIncomingEdgeSet.contains(lIncomingCFAEdge)) continue;
                        lIncomingCFAEdges.add(lIncomingCFAEdge);
                    }
                    ECPEdgeSet lNewEdgeSet = new ECPEdgeSet(lIncomingCFAEdges);
                    GuardedEdgeLabel lNewLabel = new GuardedEdgeLabel(lNewEdgeSet, ((GuardedEdgeLabel)lIncomingEdge.getLabel()).getGuards());
                    lNewAutomaton.createEdge((NondeterministicFiniteAutomaton.State)lStateMap.get(lIncomingEdge.getSource()), (NondeterministicFiniteAutomaton.State)lStateMap.get(lIncomingEdge.getTarget()), lNewLabel);
                    lMatch = true;
                }
            }
            if (lMatch) continue;
            for (NondeterministicFiniteAutomaton.Edge lIncomingEdge : pAutomaton.getIncomingEdges(lState)) {
                lNewAutomaton.createEdge((NondeterministicFiniteAutomaton.State)lStateMap.get(lIncomingEdge.getSource()), (NondeterministicFiniteAutomaton.State)lStateMap.get(lIncomingEdge.getTarget()), (GuardedEdgeLabel)lIncomingEdge.getLabel());
            }
        }
        for (NondeterministicFiniteAutomaton.State lFinalState : pAutomaton.getFinalStates()) {
            lNewAutomaton.addToFinalStates((NondeterministicFiniteAutomaton.State)lStateMap.get(lFinalState));
        }
        return lNewAutomaton;
    }

    public static NondeterministicFiniteAutomaton<GuardedEdgeLabel> removeInfeasibleTransitions(NondeterministicFiniteAutomaton<GuardedEdgeLabel> pAutomaton) {
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lNewAutomaton = new NondeterministicFiniteAutomaton<GuardedEdgeLabel>();
        HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State> lStateMap = new HashMap<NondeterministicFiniteAutomaton.State, NondeterministicFiniteAutomaton.State>();
        lStateMap.put(pAutomaton.getInitialState(), lNewAutomaton.getInitialState());
        for (NondeterministicFiniteAutomaton.State lState : pAutomaton.getStates()) {
            if (lState.equals(pAutomaton.getInitialState())) continue;
            lStateMap.put(lState, lNewAutomaton.createState());
        }
        for (NondeterministicFiniteAutomaton.State lState : pAutomaton.getStates()) {
            for (NondeterministicFiniteAutomaton.Edge lIncomingEdge : pAutomaton.getIncomingEdges(lState)) {
                boolean lMatch = false;
                GuardedEdgeLabel lIncomingLabel = (GuardedEdgeLabel)lIncomingEdge.getLabel();
                if (!(lIncomingLabel instanceof InverseGuardedEdgeLabel) && !pAutomaton.getFinalStates().contains(lState)) {
                    for (NondeterministicFiniteAutomaton.Edge lOutgoingEdge : pAutomaton.getOutgoingEdges(lState)) {
                        GuardedEdgeLabel lOutgoingLabel = (GuardedEdgeLabel)lOutgoingEdge.getLabel();
                        for (CFAEdge lIncomingCFAEdge : lIncomingLabel.getEdgeSet()) {
                            for (CFAEdge lOutgoingCFAEdge : lOutgoingLabel.getEdgeSet()) {
                                if (!lIncomingCFAEdge.getSuccessor().equals(lOutgoingCFAEdge.getPredecessor())) continue;
                                lMatch = true;
                                break;
                            }
                            if (!lMatch) continue;
                            break;
                        }
                        if (!lMatch) continue;
                        break;
                    }
                } else {
                    lMatch = true;
                }
                if (!lMatch) continue;
                lNewAutomaton.createEdge((NondeterministicFiniteAutomaton.State)lStateMap.get(lIncomingEdge.getSource()), (NondeterministicFiniteAutomaton.State)lStateMap.get(lIncomingEdge.getTarget()), lIncomingLabel);
            }
        }
        for (NondeterministicFiniteAutomaton.State lFinalState : pAutomaton.getFinalStates()) {
            lNewAutomaton.addToFinalStates((NondeterministicFiniteAutomaton.State)lStateMap.get(lFinalState));
        }
        return lNewAutomaton;
    }

    private static class Visitor
    implements ECPVisitor<Void> {
        private static final Map<ECPAtom, GuardedLabel> sLabelCache = new HashMap<ECPAtom, GuardedLabel>();
        private NondeterministicFiniteAutomaton<GuardedLabel> mAutomaton;
        private NondeterministicFiniteAutomaton.State mInitialState;
        private NondeterministicFiniteAutomaton.State mFinalState;

        public Visitor(NondeterministicFiniteAutomaton<GuardedLabel> pAutomaton) {
            this.mAutomaton = pAutomaton;
            this.setInitialState(this.mAutomaton.getInitialState());
            this.setFinalState(this.mAutomaton.createState());
        }

        public Visitor() {
            this(new NondeterministicFiniteAutomaton<GuardedLabel>());
        }

        public NondeterministicFiniteAutomaton<GuardedLabel> getAutomaton() {
            return this.mAutomaton;
        }

        public NondeterministicFiniteAutomaton.State getInitialState() {
            return this.mInitialState;
        }

        public NondeterministicFiniteAutomaton.State getFinalState() {
            return this.mFinalState;
        }

        public void setInitialState(NondeterministicFiniteAutomaton.State pInitialState) {
            this.mInitialState = pInitialState;
        }

        public void setFinalState(NondeterministicFiniteAutomaton.State pFinalState) {
            this.mFinalState = pFinalState;
        }

        @Override
        public Void visit(ECPEdgeSet pEdgeSet) {
            GuardedLabel lLabel = sLabelCache.get(pEdgeSet);
            if (lLabel == null) {
                lLabel = new GuardedEdgeLabel(pEdgeSet);
                sLabelCache.put(pEdgeSet, lLabel);
            }
            this.mAutomaton.createEdge(this.getInitialState(), this.getFinalState(), lLabel);
            return null;
        }

        @Override
        public Void visit(ECPNodeSet pNodeSet) {
            GuardedLabel lLabel = sLabelCache.get(pNodeSet);
            if (lLabel == null) {
                lLabel = new GuardedLambdaLabel(pNodeSet);
                sLabelCache.put(pNodeSet, lLabel);
            }
            this.mAutomaton.createEdge(this.getInitialState(), this.getFinalState(), lLabel);
            return null;
        }

        @Override
        public Void visit(ECPPredicate pPredicate) {
            GuardedLabel lLabel = sLabelCache.get(pPredicate);
            if (lLabel == null) {
                lLabel = new GuardedLambdaLabel(pPredicate);
                sLabelCache.put(pPredicate, lLabel);
            }
            this.mAutomaton.createEdge(this.getInitialState(), this.getFinalState(), lLabel);
            return null;
        }

        @Override
        public Void visit(ECPConcatenation pConcatenation) {
            if (pConcatenation.isEmpty()) {
                this.mAutomaton.createEdge(this.getInitialState(), this.getFinalState(), GuardedLambdaLabel.UNGUARDED_LAMBDA_LABEL);
            } else {
                NondeterministicFiniteAutomaton.State lTmpInitialState = this.getInitialState();
                NondeterministicFiniteAutomaton.State lTmpFinalState = this.getFinalState();
                for (int i = 0; i < pConcatenation.size(); ++i) {
                    ElementaryCoveragePattern lSubpattern = pConcatenation.get(i);
                    if (i > 0) {
                        this.setInitialState(this.getFinalState());
                    }
                    if (i == pConcatenation.size() - 1) {
                        this.setFinalState(lTmpFinalState);
                    } else {
                        this.setFinalState(this.mAutomaton.createState());
                    }
                    lSubpattern.accept(this);
                }
                this.setInitialState(lTmpInitialState);
            }
            return null;
        }

        @Override
        public Void visit(ECPUnion pUnion) {
            if (pUnion.isEmpty()) {
                this.mAutomaton.createEdge(this.getInitialState(), this.getFinalState(), GuardedLambdaLabel.UNGUARDED_LAMBDA_LABEL);
            } else if (pUnion.size() == 1) {
                pUnion.get(0).accept(this);
            } else {
                NondeterministicFiniteAutomaton.State lTmpInitialState = this.getInitialState();
                for (ElementaryCoveragePattern lSubpattern : pUnion) {
                    this.setInitialState(this.mAutomaton.createState());
                    this.mAutomaton.createEdge(lTmpInitialState, this.getInitialState(), GuardedLambdaLabel.UNGUARDED_LAMBDA_LABEL);
                    lSubpattern.accept(this);
                }
                this.setInitialState(lTmpInitialState);
            }
            return null;
        }

        @Override
        public Void visit(ECPRepetition pRepetition) {
            NondeterministicFiniteAutomaton.State lTmpInitialState = this.getInitialState();
            NondeterministicFiniteAutomaton.State lTmpFinalState = this.getFinalState();
            this.mAutomaton.createEdge(lTmpInitialState, lTmpFinalState, GuardedLambdaLabel.UNGUARDED_LAMBDA_LABEL);
            this.setInitialState(this.mAutomaton.createState());
            this.setFinalState(lTmpInitialState);
            this.mAutomaton.createEdge(lTmpInitialState, this.getInitialState(), GuardedLambdaLabel.UNGUARDED_LAMBDA_LABEL);
            pRepetition.getSubpattern().accept(this);
            this.setInitialState(lTmpInitialState);
            this.setFinalState(lTmpFinalState);
            return null;
        }
    }
}

