/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.ecp.translators;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.fshell.FShell3;
import org.sosy_lab.cpachecker.fshell.cfa.Wrapper;
import org.sosy_lab.cpachecker.fshell.fql2.ast.FQLSpecification;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.CoverageSpecificationTranslator;
import org.sosy_lab.cpachecker.fshell.fql2.translators.ecp.PathPatternTranslator;
import org.sosy_lab.cpachecker.util.Cilly;
import org.sosy_lab.cpachecker.util.automaton.NondeterministicFiniteAutomaton;
import org.sosy_lab.cpachecker.util.ecp.ECPEdgeSet;
import org.sosy_lab.cpachecker.util.ecp.ECPPrettyPrinter;
import org.sosy_lab.cpachecker.util.ecp.ElementaryCoveragePattern;
import org.sosy_lab.cpachecker.util.ecp.translators.AutomatonPrettyPrinter;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedEdgeLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.GuardedLabel;
import org.sosy_lab.cpachecker.util.ecp.translators.ToGuardedAutomatonTranslator;

public class ToGuardedAutomatonTranslatorTest {
    private Cilly lCilly;

    @Before
    public void setup() throws InvalidConfigurationException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = new LogManager(config);
        this.lCilly = new Cilly(logger);
    }

    @Test
    public void testMain001() throws Exception {
        String lSpecificationString = "COVER \"EDGES(ID)*\".EDGES(@CALL(f)).\"EDGES(ID)*\"";
        FQLSpecification lSpecification = FQLSpecification.parse(lSpecificationString);
        System.out.println(lSpecification);
        String lSourceFileName = "test/programs/simple/functionCall.c";
        if (!this.lCilly.isCillyInvariant(lSourceFileName)) {
            File lCillyProcessedFile = this.lCilly.cillyfy(lSourceFileName);
            lCillyProcessedFile.deleteOnExit();
            lSourceFileName = lCillyProcessedFile.getAbsolutePath();
            System.err.println("WARNING: Given source file is not CIL invariant ... did preprocessing!");
        }
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        PathPatternTranslator lPatternTranslator = new PathPatternTranslator(lMainFunction);
        CoverageSpecificationTranslator lSpecificationTranslator = new CoverageSpecificationTranslator(lPatternTranslator);
        Collection<ElementaryCoveragePattern> lGoals = lSpecificationTranslator.translate(lSpecification.getCoverageSpecification());
        ElementaryCoveragePattern lPassing = lPatternTranslator.translate(lSpecification.getPathPattern());
        ECPPrettyPrinter lPrettyPrinter = new ECPPrettyPrinter();
        System.out.println("TEST GOALS:");
        int lIndex = 0;
        for (ElementaryCoveragePattern lGoal : lGoals) {
            System.out.println("Goal #" + ++lIndex);
            System.out.println(lPrettyPrinter.printPretty(lGoal));
        }
        System.out.println("PASSING:");
        System.out.println(lPrettyPrinter.printPretty(lPassing));
        System.out.println(ToGuardedAutomatonTranslator.translate(lPassing));
    }

    @Test
    public void testMain002() throws Exception {
        String lSpecificationString = "COVER \"EDGES(ID)*\".(EDGES(@CALL(f)) + NODES(@CALL(f))).\"EDGES(ID)*\"";
        FQLSpecification lSpecification = FQLSpecification.parse(lSpecificationString);
        System.out.println(lSpecification);
        String lSourceFileName = "test/programs/simple/functionCall.c";
        if (!this.lCilly.isCillyInvariant(lSourceFileName)) {
            File lCillyProcessedFile = this.lCilly.cillyfy(lSourceFileName);
            lCillyProcessedFile.deleteOnExit();
            lSourceFileName = lCillyProcessedFile.getAbsolutePath();
            System.err.println("WARNING: Given source file is not CIL invariant ... did preprocessing!");
        }
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        PathPatternTranslator lPatternTranslator = new PathPatternTranslator(lMainFunction);
        CoverageSpecificationTranslator lSpecificationTranslator = new CoverageSpecificationTranslator(lPatternTranslator);
        Collection<ElementaryCoveragePattern> lGoals = lSpecificationTranslator.translate(lSpecification.getCoverageSpecification());
        ElementaryCoveragePattern lPassing = lPatternTranslator.translate(lSpecification.getPathPattern());
        ECPPrettyPrinter lPrettyPrinter = new ECPPrettyPrinter();
        System.out.println("TEST GOALS:");
        int lIndex = 0;
        for (ElementaryCoveragePattern lGoal : lGoals) {
            System.out.println("Goal #" + ++lIndex);
            System.out.println(lPrettyPrinter.printPretty(lGoal));
        }
        System.out.println("PASSING:");
        System.out.println(lPrettyPrinter.printPretty(lPassing));
        System.out.println(ToGuardedAutomatonTranslator.translate(lPassing));
    }

    @Test
    public void testMain003() throws Exception {
        String lSpecificationString = "COVER \"EDGES(ID)*\".(EDGES(@CALL(f)) + NODES(@CALL(f))).\"EDGES(ID)*\" PASSING { x > 10 }";
        FQLSpecification lSpecification = FQLSpecification.parse(lSpecificationString);
        System.out.println(lSpecification);
        String lSourceFileName = "test/programs/simple/functionCall.c";
        if (!this.lCilly.isCillyInvariant(lSourceFileName)) {
            File lCillyProcessedFile = this.lCilly.cillyfy(lSourceFileName);
            lCillyProcessedFile.deleteOnExit();
            lSourceFileName = lCillyProcessedFile.getAbsolutePath();
            System.err.println("WARNING: Given source file is not CIL invariant ... did preprocessing!");
        }
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        PathPatternTranslator lPatternTranslator = new PathPatternTranslator(lMainFunction);
        CoverageSpecificationTranslator lSpecificationTranslator = new CoverageSpecificationTranslator(lPatternTranslator);
        Collection<ElementaryCoveragePattern> lGoals = lSpecificationTranslator.translate(lSpecification.getCoverageSpecification());
        ElementaryCoveragePattern lPassing = lPatternTranslator.translate(lSpecification.getPathPattern());
        ECPPrettyPrinter lPrettyPrinter = new ECPPrettyPrinter();
        System.out.println("TEST GOALS:");
        int lIndex = 0;
        for (ElementaryCoveragePattern lGoal : lGoals) {
            System.out.println("Goal #" + ++lIndex);
            System.out.println(lPrettyPrinter.printPretty(lGoal));
        }
        System.out.println("PASSING:");
        System.out.println(lPrettyPrinter.printPretty(lPassing));
        System.out.println(ToGuardedAutomatonTranslator.translate(lPassing));
    }

    @Test
    public void testMain004() throws Exception {
        String lSpecificationString = "COVER \"EDGES(ID)*\".(EDGES(@CALL(f)) + NODES(@CALL(f))).\"EDGES(ID)*\" PASSING EDGES(ID)*.{ x > 10 }";
        FQLSpecification lSpecification = FQLSpecification.parse(lSpecificationString);
        System.out.println(lSpecification);
        String lSourceFileName = "test/programs/simple/functionCall.c";
        if (!this.lCilly.isCillyInvariant(lSourceFileName)) {
            File lCillyProcessedFile = this.lCilly.cillyfy(lSourceFileName);
            lCillyProcessedFile.deleteOnExit();
            lSourceFileName = lCillyProcessedFile.getAbsolutePath();
            System.err.println("WARNING: Given source file is not CIL invariant ... did preprocessing!");
        }
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        CFAFunctionDefinitionNode lMainFunction = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager).get(lEntryFunction);
        PathPatternTranslator lPatternTranslator = new PathPatternTranslator(lMainFunction);
        CoverageSpecificationTranslator lSpecificationTranslator = new CoverageSpecificationTranslator(lPatternTranslator);
        Collection<ElementaryCoveragePattern> lGoals = lSpecificationTranslator.translate(lSpecification.getCoverageSpecification());
        ElementaryCoveragePattern lPassing = lPatternTranslator.translate(lSpecification.getPathPattern());
        ECPPrettyPrinter lPrettyPrinter = new ECPPrettyPrinter();
        System.out.println("TEST GOALS:");
        int lIndex = 0;
        for (ElementaryCoveragePattern lGoal : lGoals) {
            System.out.println("Goal #" + ++lIndex);
            System.out.println(lPrettyPrinter.printPretty(lGoal));
        }
        System.out.println("PASSING:");
        System.out.println(lPrettyPrinter.printPretty(lPassing));
        System.out.println(ToGuardedAutomatonTranslator.translate(lPassing));
    }

    @Test
    public void testMain005() throws Exception {
        String lSpecificationString = "COVER \"EDGES(ID)*\".(EDGES(@CALL(f)) + NODES(@CALL(f))).\"EDGES(ID)*\" PASSING EDGES(ID)*.{ x > 10 }.EDGES(@CALL(f))";
        FQLSpecification lSpecification = FQLSpecification.parse(lSpecificationString);
        System.out.println(lSpecification);
        String lSourceFileName = "test/programs/simple/functionCall.c";
        if (!this.lCilly.isCillyInvariant(lSourceFileName)) {
            File lCillyProcessedFile = this.lCilly.cillyfy(lSourceFileName);
            lCillyProcessedFile.deleteOnExit();
            lSourceFileName = lCillyProcessedFile.getAbsolutePath();
            System.err.println("WARNING: Given source file is not CIL invariant ... did preprocessing!");
        }
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        Map<String, CFAFunctionDefinitionNode> lCFAMap = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager);
        CFAFunctionDefinitionNode lMainFunction = lCFAMap.get(lEntryFunction);
        PathPatternTranslator lPatternTranslator = new PathPatternTranslator(lMainFunction);
        CoverageSpecificationTranslator lSpecificationTranslator = new CoverageSpecificationTranslator(lPatternTranslator);
        Collection<ElementaryCoveragePattern> lGoals = lSpecificationTranslator.translate(lSpecification.getCoverageSpecification());
        ElementaryCoveragePattern lPassing = lPatternTranslator.translate(lSpecification.getPathPattern());
        ECPPrettyPrinter lPrettyPrinter = new ECPPrettyPrinter();
        System.out.println("TEST GOALS:");
        int lIndex = 0;
        for (ElementaryCoveragePattern lGoal : lGoals) {
            System.out.println("Goal #" + ++lIndex);
            System.out.println(lPrettyPrinter.printPretty(lGoal));
        }
        System.out.println("PASSING:");
        System.out.println(lPrettyPrinter.printPretty(lPassing));
        NondeterministicFiniteAutomaton<GuardedLabel> lInitialAutomaton = ToGuardedAutomatonTranslator.translate(lPassing);
        System.out.println(lInitialAutomaton);
        Wrapper lWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, lLogManager);
        GuardedEdgeLabel lAlphaLabel = new GuardedEdgeLabel(new ECPEdgeSet(lWrapper.getAlphaEdge()));
        GuardedEdgeLabel lOmegaLabel = new GuardedEdgeLabel(new ECPEdgeSet(lWrapper.getOmegaEdge()));
        NondeterministicFiniteAutomaton<GuardedLabel> lLambdaFreeAutomaton = ToGuardedAutomatonTranslator.removeLambdaEdges(lInitialAutomaton, lAlphaLabel, lOmegaLabel);
        System.out.println(AutomatonPrettyPrinter.print(lLambdaFreeAutomaton));
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lNodeSetFreeAutomaton = ToGuardedAutomatonTranslator.removeNodeSetGuards(lLambdaFreeAutomaton);
        System.out.println(AutomatonPrettyPrinter.print(lNodeSetFreeAutomaton));
    }

    @Test
    public void testMain006() throws Exception {
        String lSpecificationString = "COVER \"EDGES(ID)*\".(EDGES(@CALL(f)) + NODES(@CALL(f))).\"EDGES(ID)*\" PASSING EDGES(ID)*.{ x > 10 }.NODES(@CALL(f))";
        FQLSpecification lSpecification = FQLSpecification.parse(lSpecificationString);
        System.out.println(lSpecification);
        String lSourceFileName = "test/programs/simple/functionCall.c";
        if (!this.lCilly.isCillyInvariant(lSourceFileName)) {
            File lCillyProcessedFile = this.lCilly.cillyfy(lSourceFileName);
            lCillyProcessedFile.deleteOnExit();
            lSourceFileName = lCillyProcessedFile.getAbsolutePath();
            System.err.println("WARNING: Given source file is not CIL invariant ... did preprocessing!");
        }
        String lEntryFunction = "main";
        Configuration lConfiguration = FShell3.createConfiguration(lSourceFileName, lEntryFunction);
        LogManager lLogManager = new LogManager(lConfiguration);
        Map<String, CFAFunctionDefinitionNode> lCFAMap = FShell3.getCFAMap(lSourceFileName, lConfiguration, lLogManager);
        CFAFunctionDefinitionNode lMainFunction = lCFAMap.get(lEntryFunction);
        PathPatternTranslator lPatternTranslator = new PathPatternTranslator(lMainFunction);
        CoverageSpecificationTranslator lSpecificationTranslator = new CoverageSpecificationTranslator(lPatternTranslator);
        Collection<ElementaryCoveragePattern> lGoals = lSpecificationTranslator.translate(lSpecification.getCoverageSpecification());
        ElementaryCoveragePattern lPassing = lPatternTranslator.translate(lSpecification.getPathPattern());
        ECPPrettyPrinter lPrettyPrinter = new ECPPrettyPrinter();
        System.out.println("TEST GOALS:");
        int lIndex = 0;
        for (ElementaryCoveragePattern lGoal : lGoals) {
            System.out.println("Goal #" + ++lIndex);
            System.out.println(lPrettyPrinter.printPretty(lGoal));
        }
        System.out.println("PASSING:");
        System.out.println(lPrettyPrinter.printPretty(lPassing));
        NondeterministicFiniteAutomaton<GuardedLabel> lInitialAutomaton = ToGuardedAutomatonTranslator.translate(lPassing);
        System.out.println(lInitialAutomaton);
        System.out.println(AutomatonPrettyPrinter.print(lInitialAutomaton));
        Wrapper lWrapper = new Wrapper((FunctionDefinitionNode)lMainFunction, lCFAMap, lLogManager);
        GuardedEdgeLabel lAlphaLabel = new GuardedEdgeLabel(new ECPEdgeSet(lWrapper.getAlphaEdge()));
        GuardedEdgeLabel lOmegaLabel = new GuardedEdgeLabel(new ECPEdgeSet(lWrapper.getOmegaEdge()));
        NondeterministicFiniteAutomaton<GuardedLabel> lLambdaFreeAutomaton = ToGuardedAutomatonTranslator.removeLambdaEdges(lInitialAutomaton, lAlphaLabel, lOmegaLabel);
        System.out.println(AutomatonPrettyPrinter.print(lLambdaFreeAutomaton));
        NondeterministicFiniteAutomaton<GuardedEdgeLabel> lNodeSetFreeAutomaton = ToGuardedAutomatonTranslator.removeNodeSetGuards(lLambdaFreeAutomaton);
        System.out.println(AutomatonPrettyPrinter.print(lNodeSetFreeAutomaton));
    }
}

