/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.globalinfo;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cpa.location.LocationElement;

public class CFAInfo {
    private final CFA cfa;
    private final Map<Integer, CFANode> nodeNumberToNode;
    private LocationElement.LocationElementFactory locationElementFactory;

    CFAInfo(CFA cfa) {
        this.cfa = cfa;
        HashMap<Integer, CFANode> nodeNumberToNode = new HashMap<Integer, CFANode>();
        for (CFANode node : cfa.getAllNodes()) {
            nodeNumberToNode.put(node.getNodeNumber(), node);
        }
        this.nodeNumberToNode = nodeNumberToNode;
    }

    public CFANode getNodeByNodeNumber(int nodeNumber) {
        return this.nodeNumberToNode.get(nodeNumber);
    }

    public void storeLocationElementFactory(LocationElement.LocationElementFactory pElementFactory) {
        this.locationElementFactory = pElementFactory;
    }

    public LocationElement.LocationElementFactory getLocationElementFactory() {
        return this.locationElementFactory;
    }
}

