/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.globalinfo;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.util.globalinfo.AutomatonInfo;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;

public class GlobalInfo {
    private static GlobalInfo instance;
    private CFAInfo cfaInfo;
    private AutomatonInfo automatonInfo = new AutomatonInfo();
    private ExtendedFormulaManager formulaManager;
    private ArrayList<Serializable> helperStorages = new ArrayList();

    private GlobalInfo() {
    }

    public static GlobalInfo getInstance() {
        if (instance == null) {
            instance = new GlobalInfo();
        }
        return instance;
    }

    public void storeCFA(CFA cfa) {
        this.cfaInfo = new CFAInfo(cfa);
    }

    public CFAInfo getCFAInfo() {
        Preconditions.checkState((this.cfaInfo != null ? 1 : 0) != 0);
        return this.cfaInfo;
    }

    public void storeAutomaton(Automaton automaton) {
        this.automatonInfo.register(automaton);
    }

    public AutomatonInfo getAutomatonInfo() {
        Preconditions.checkState((this.automatonInfo != null ? 1 : 0) != 0);
        return this.automatonInfo;
    }

    public void storeFormulaManager(ExtendedFormulaManager formulaManager) {
        this.formulaManager = formulaManager;
    }

    public ExtendedFormulaManager getFormulaManager() {
        Preconditions.checkState((this.formulaManager != null ? 1 : 0) != 0);
        return this.formulaManager;
    }

    public int addHelperStorage(Serializable e) {
        this.helperStorages.add(e);
        return this.helperStorages.size() - 1;
    }

    public Serializable getHelperStorage(int index) {
        return this.helperStorages.get(index);
    }

    public int getNumberOfHelperStorages() {
        return this.helperStorages.size();
    }
}

