/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants;

import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateNumber;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSum;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class Coeff {
    private final TemplateSum value;
    private VariableWriteMode vwm = VariableWriteMode.REDLOG;

    public Coeff(TemplateSum s) {
        this.value = s;
    }

    public Coeff(TemplateSum s, VariableWriteMode vwm) {
        this.value = s;
        this.vwm = vwm;
    }

    public RationalFunction makeRationalFunction(Map<String, Variable> paramVars) {
        Polynomial num = this.value.makePolynomial(paramVars);
        Polynomial denom = new Polynomial(1);
        RationalFunction f = new RationalFunction(num, denom);
        f.simplify();
        return f;
    }

    public Coeff(String s) {
        TemplateNumber n = new TemplateNumber(s);
        TemplateTerm t = new TemplateTerm();
        t.setCoefficient(n);
        this.value = t;
    }

    public String toString() {
        return this.value.toString(this.vwm);
    }

    public Coeff negative() {
        TemplateSum s = this.value.copy();
        s.negate();
        return new Coeff(s);
    }

    public static String coeffsToString(List<Coeff> list) {
        String s = "";
        for (Coeff c : list) {
            s = s + " " + c.toString();
        }
        return s;
    }
}

