/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants;

import java.util.List;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.ExtendedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.PathFormulaManagerImpl;

public class FMtester {
    private static String testpath = "/home/skieffer/sosy-lab/test_programs/";
    private static int loopnum = 12;
    private static String testfile = testpath + "loop" + Integer.toString(loopnum) + ".c";
    private static PathFormulaManagerImpl pfmgr;

    public static void main(String[] args) {
        Configuration config = Configuration.defaultConfiguration();
        CFAFunctionDefinitionNode root = null;
        TemplateFormulaManager fmgr = null;
        try {
            LogManager logger = new LogManager(config);
            CFACreator cfac = new CFACreator(config, logger);
            CFA cfa = cfac.parseFileAndCreateCFA(testfile);
            root = cfa.getMainFunction();
            fmgr = new TemplateFormulaManager();
            ExtendedFormulaManager emgr = new ExtendedFormulaManager(fmgr, config, logger);
            pfmgr = new PathFormulaManagerImpl(emgr, config, logger);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        List<CFAEdge> edgeSet = FMtester.getEdgeSet(root);
        for (CFAEdge e : edgeSet) {
            PathFormula pf = FMtester.makepf(e);
            System.out.println(pf);
        }
    }

    private static List<CFAEdge> getEdgeSet(CFAFunctionDefinitionNode root) {
        CFATraversal.EdgeCollectingCFAVisitor visitor = new CFATraversal.EdgeCollectingCFAVisitor();
        CFATraversal.dfs().ignoreSummaryEdges().traverse(root, visitor);
        return visitor.getVisitedEdges();
    }

    private static PathFormula makepf(CFAEdge edge) {
        PathFormula empty = null;
        PathFormula pf = null;
        try {
            empty = pfmgr.makeEmptyPathFormula();
            pf = pfmgr.makeAnd(empty, edge);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return pf;
    }
}

