/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.LinearInequality;

public class Farkas {
    private static AtomicInteger nextUsableIndex = new AtomicInteger(0);
    private static boolean exqx = false;

    public static void resetConstantIndices() {
        nextUsableIndex.set(0);
    }

    public static void setExqx(boolean exqx) {
        Farkas.exqx = exqx;
    }

    public static boolean willDoExqx() {
        return exqx;
    }

    public static String makeRedlogFormula(LinearInequality prem, LinearInequality concl) {
        String cj2;
        int J = prem.getNumIneqs();
        int K = concl.getNumIneqs();
        int I = prem.getNumVars();
        String s = "";
        boolean begun_statements = false;
        boolean begun_terms = false;
        HashSet<String> jUsed = new HashSet<String>();
        HashSet<String> allc = new HashSet<String>();
        int[] cColumn = new int[J];
        for (int k = 0; k < K; ++k) {
            String b;
            String a;
            int j;
            for (j = 0; j < J; ++j) {
                cColumn[j] = nextUsableIndex.incrementAndGet();
            }
            jUsed.clear();
            for (int i = 0; i < I; ++i) {
                if (begun_statements) {
                    s = s + " and ";
                }
                for (int j2 = 0; j2 < J; ++j2) {
                    a = prem.getCoeff(j2, i).toString();
                    if (a.matches("-*0")) continue;
                    if (begun_terms) {
                        s = s + " + ";
                    }
                    cj2 = "c" + Integer.toString(cColumn[j2]);
                    s = s + a + "*" + cj2;
                    begun_terms = true;
                    jUsed.add(cj2);
                    allc.add(cj2);
                }
                if (!begun_terms) {
                    s = s + "0";
                }
                b = concl.getCoeff(k, i).toString();
                s = s + " = " + b;
                begun_statements = true;
                begun_terms = false;
            }
            if (begun_statements) {
                s = s + " and ";
            }
            for (j = 0; j < J; ++j) {
                a = prem.getRHSCoeff(j).toString();
                if (a.matches("-*0")) continue;
                if (begun_terms) {
                    s = s + " + ";
                }
                cj2 = "c" + Integer.toString(cColumn[j]);
                s = s + a + "*" + cj2;
                begun_terms = true;
                jUsed.add(cj2);
                allc.add(cj2);
            }
            if (!begun_terms) {
                s = s + "0";
            }
            b = concl.getRHSCoeff(k).toString();
            String rel = concl.getReln(k).toString();
            s = s + " " + rel + " " + b;
            begun_statements = true;
            begun_terms = false;
            for (String cj2 : jUsed) {
                s = s + " and " + cj2 + " >= 0";
            }
        }
        if (exqx) {
            Iterator thec = allc.iterator();
            String q = "ex({";
            boolean begun = false;
            while (thec.hasNext()) {
                cj2 = (String)thec.next();
                if (begun) {
                    q = q + ",";
                }
                q = q + cj2;
                begun = true;
            }
            q = q + "},";
            s = q + s + ")";
        }
        return s;
    }

    public static String makeRedlogFormulaUsingPremiseStrength(LinearInequality prem, LinearInequality concl) {
        String cj2;
        int J = prem.getNumIneqs();
        int K = concl.getNumIneqs();
        int I = prem.getNumVars();
        Vector<Integer> strict = prem.findStrict();
        if (strict.size() == 0) {
            return Farkas.makeRedlogFormula(prem, concl);
        }
        String s = "";
        boolean begun_statements = false;
        boolean begun_terms = false;
        HashSet<String> jUsed = new HashSet<String>();
        HashSet<String> allc = new HashSet<String>();
        int[] cColumn = new int[J];
        for (int k = 0; k < K; ++k) {
            String b;
            String a;
            int j;
            for (j = 0; j < J; ++j) {
                cColumn[j] = nextUsableIndex.incrementAndGet();
            }
            jUsed.clear();
            for (int i = 0; i < I; ++i) {
                if (begun_statements) {
                    s = s + " and ";
                }
                for (int j2 = 0; j2 < J; ++j2) {
                    a = prem.getCoeff(j2, i).toString();
                    if (a.matches("-*0")) continue;
                    if (begun_terms) {
                        s = s + " + ";
                    }
                    cj2 = "c" + Integer.toString(cColumn[j2]);
                    s = s + a + "*" + cj2;
                    begun_terms = true;
                    jUsed.add(cj2);
                    allc.add(cj2);
                }
                if (!begun_terms) {
                    s = s + "0";
                }
                b = concl.getCoeff(k, i).toString();
                s = s + " = " + b;
                begun_statements = true;
                begun_terms = false;
            }
            if (begun_statements) {
                s = s + " and ";
            }
            for (j = 0; j < J; ++j) {
                a = prem.getRHSCoeff(j).toString();
                if (a.matches("-*0")) continue;
                if (begun_terms) {
                    s = s + " + ";
                }
                cj2 = "c" + Integer.toString(cColumn[j]);
                s = s + a + "*" + cj2;
                begun_terms = true;
                jUsed.add(cj2);
                allc.add(cj2);
            }
            if (!begun_terms) {
                s = s + "0";
            }
            b = concl.getRHSCoeff(k).toString();
            InfixReln rel = concl.getReln(k);
            if (rel.equals((Object)InfixReln.LT)) {
                String slackVar = "c" + Integer.toString(nextUsableIndex.incrementAndGet());
                jUsed.add(slackVar);
                s = s + " + " + slackVar + " = " + b + " and (";
                for (Integer idx : strict) {
                    cj2 = "c" + Integer.toString(cColumn[idx]);
                    s = s + cj2 + " > 0 or ";
                }
                s = s + slackVar + " > 0)";
            } else {
                s = s + " <= " + b;
            }
            begun_statements = true;
            begun_terms = false;
            for (String cj2 : jUsed) {
                s = s + " and " + cj2 + " >= 0";
            }
        }
        if (exqx) {
            Iterator thec = allc.iterator();
            String q = "ex({";
            boolean begun = false;
            while (thec.hasNext()) {
                cj2 = (String)thec.next();
                if (begun) {
                    q = q + ",";
                }
                q = q + cj2;
                begun = true;
            }
            q = q + "},";
            s = q + s + ")";
        }
        return s;
    }

    @Deprecated
    public static String makeRedlogFormula(LinearInequality prem, LinearInequality concl, int thirdIndex) {
        String xjk2;
        int J = prem.getNumIneqs();
        int K = concl.getNumIneqs();
        int I = prem.getNumVars();
        String s = "";
        String x = "mkid(mkid(mkid(x," + Integer.toString(thirdIndex) + "),";
        boolean begun_statements = false;
        boolean begun_terms = false;
        HashSet<String> jUsed = new HashSet<String>();
        HashSet<String> allx = new HashSet<String>();
        for (int k = 0; k < K; ++k) {
            String b;
            String a;
            jUsed.clear();
            for (int i = 0; i < I; ++i) {
                if (begun_statements) {
                    s = s + " and ";
                }
                for (int j = 0; j < J; ++j) {
                    a = prem.getCoeff(j, i).toString();
                    if (a.matches("-*0")) continue;
                    if (begun_terms) {
                        s = s + " + ";
                    }
                    xjk2 = x + Integer.toString(j) + ")," + Integer.toString(k) + ")";
                    s = s + a + "*" + xjk2;
                    begun_terms = true;
                    jUsed.add(xjk2);
                    allx.add(xjk2);
                }
                if (!begun_terms) {
                    s = s + "0";
                }
                b = concl.getCoeff(k, i).toString();
                s = s + " = " + b;
                begun_statements = true;
                begun_terms = false;
            }
            if (begun_statements) {
                s = s + " and ";
            }
            for (int j = 0; j < J; ++j) {
                a = prem.getRHSCoeff(j).toString();
                if (a.matches("-*0")) continue;
                if (begun_terms) {
                    s = s + " + ";
                }
                xjk2 = x + Integer.toString(j) + ")," + Integer.toString(k) + ")";
                s = s + a + "*" + xjk2;
                begun_terms = true;
                jUsed.add(xjk2);
                allx.add(xjk2);
            }
            if (!begun_terms) {
                s = s + "0";
            }
            b = concl.getRHSCoeff(k).toString();
            s = s + " <= " + b;
            begun_statements = true;
            begun_terms = false;
            for (String xjk2 : jUsed) {
                s = s + " and " + xjk2 + " >= 0";
            }
        }
        if (exqx) {
            Iterator thex = allx.iterator();
            String q = "ex({";
            boolean begun = false;
            while (thex.hasNext()) {
                xjk2 = (String)thex.next();
                if (begun) {
                    q = q + ",";
                }
                q = q + xjk2;
                begun = true;
            }
            q = q + "},";
            s = q + s + ")";
        }
        return s;
    }
}

